/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.costmap;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.LongFormatTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapExportPanel;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapImportDialog;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapItemEditorForm;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapPanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapRange;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicRange;
import ru.bitel.bgbilling.modules.voice.common.dto.VoiceCostMapRangeItem;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceCostMapService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.IdTitle;

class VoiceCostMapEditorForm
extends BGUPanel {
    private static final String SAVE = "save";
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.RESET, BGButtonPanel.GLUE, BGButtonPanel.OK, new BGButtonPanel.ButtonItem("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "save"), BGButtonPanel.CANCEL});
    private BGTextField costMapTitle = new BGTextField(50);
    private BGTextField comment = new BGTextField();
    private VoiceCostMapItem root;
    private BGUTreeTable costMapItemTable;
    private VoiceCostMapItemTreeTableModel costMapItemModel;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private VoiceCostMapItemEditorForm itemEditor;
    private VoiceCostMapExportPanel exportPanel;
    private BGControlPanelDateNoB codeDate;
    private BGTextField codeDestinationFilter;
    private BGControlPanelDateNoB rangeDate;
    private BGTextField rangeDestinationFilter;
    private BGUTable rangeTable;
    private VoiceRandeTableModel rangeModel = new VoiceRandeTableModel();
    private List<CostMapRangeItem> rangeList = new ArrayList<CostMapRangeItem>();
    private JLabel rangeRecords = new JLabel("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: 0");
    private JLabel codeRecords = new JLabel("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: 0");
    private VoiceCostMap currentCostMap;
    private final VoiceCostMapPanel parentPanel;

    public VoiceCostMapEditorForm(ClientContext clientContext, VoiceCostMapPanel voiceCostMapPanel) {
        super((LayoutManager)new GridBagLayout(), clientContext);
        this.parentPanel = voiceCostMapPanel;
    }

    protected void jbInit() throws Exception {
        this.costMapItemModel = new VoiceCostMapItemTreeTableModel();
        this.costMapItemTable = new BGUTreeTable((BGTreeTableModel)this.costMapItemModel);
        this.buttonPanel.addActionListener(e -> this.performAction(e.getActionCommand()));
        this.tabbedPane.add("\u041a\u043e\u0434\u044b", this.getCodePanel());
        this.tabbedPane.add("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b", this.getRangePanel());
        this.add(this.getTitleCommentPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.costMapItemTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VoiceCostMapEditorForm.this.performAction(BGDialogToolBar.ButtonData.EDIT_ITEM.getName());
                }
            }
        });
    }

    private JPanel getCodePanel() {
        this.itemEditor = new VoiceCostMapItemEditorForm((ClientContext)this.getContext(), this);
        this.itemEditor.setVisible(false);
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.itemEditor), (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0430");
        this.exportPanel = new VoiceCostMapExportPanel(this);
        this.exportPanel.setVisible(false);
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.exportPanel), (String)"\u041e\u043f\u0446\u0438\u0438 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430");
        JPanel toolbarTablePanel = new JPanel(new GridBagLayout());
        toolbarTablePanel.add((Component)this.getCodeFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 3, 0), 0, 0));
        toolbarTablePanel.add((Component)new JScrollPane((Component)this.costMapItemTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolbarTablePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)((Object)this.itemEditor), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)((Object)this.exportPanel), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getRangePanel() {
        this.rangeTable = new BGUTable((TableModel)((Object)this.rangeModel));
        BGSwingUtilites.handleEdit((JTable)this.rangeTable, (BGUPanel)this, (String)("range." + BGDialogToolBar.ButtonData.EDIT_ITEM.getName()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getRangeFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.rangeTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getRangeFilterPanel() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> this.performAction(e.getActionCommand()), new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.DELETE_ALL_ITEM, BGDialogToolBar.ButtonData.SEPARATOR, BGDialogToolBar.ButtonData.IMPORT, BGDialogToolBar.ButtonData.EXPORT});
        toolBar.setFloatable(false);
        this.rangeDate = new BGControlPanelDateNoB(Calendar.getInstance());
        this.rangeDate.addPropertyChangeListener("date", e -> this.performAction("refresh"));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435, \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u043d\u0430 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 3), 0, 0));
        filterPanel.add((Component)this.rangeDate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.rangeDestinationFilter = new BGTextField(20);
        this.rangeDestinationFilter.setHorizontalAlignment(0);
        this.rangeDestinationFilter.setPromptText("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443", true, true);
        this.rangeDestinationFilter.addPropertyChangeListener((PropertyChangeListener)new RangeFilterCaretListener());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        panel.add((Component)this.rangeDestinationFilter, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        panel.add((Component)filterPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 3), 0, 0));
        panel.add((Component)this.rangeRecords, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        return panel;
    }

    private JPanel getCodeFilterPanel() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> this.performAction(e.getActionCommand()), new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.DELETE_ALL_ITEM, BGDialogToolBar.ButtonData.SEPARATOR, BGDialogToolBar.ButtonData.IMPORT, BGDialogToolBar.ButtonData.EXPORT});
        toolBar.setFloatable(false);
        this.codeDate = new BGControlPanelDateNoB(Calendar.getInstance());
        this.codeDate.addPropertyChangeListener("date", e -> this.performAction("refresh"));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e, \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0435 \u043d\u0430 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 3), 0, 0));
        filterPanel.add((Component)this.codeDate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.codeDestinationFilter = new BGTextField(20);
        this.codeDestinationFilter.setHorizontalAlignment(0);
        this.codeDestinationFilter.setPromptText("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043a\u043e\u0434\u0443", true, true);
        this.codeDestinationFilter.addPropertyChangeListener((PropertyChangeListener)new CodeFilterCaretListener());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        panel.add((Component)this.codeDestinationFilter, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        panel.add((Component)filterPanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.codeRecords, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        return panel;
    }

    private JPanel getTitleCommentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        panel.add((Component)this.costMapTitle, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 3), 0, 0));
        panel.add((Component)this.comment, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            VoiceCostMapService costMapService = (VoiceCostMapService)((ClientContext)this.getContext()).getPort(VoiceCostMapService.class);
            if (this.tabbedPane.getSelectedIndex() == 0) {
                Date date = this.codeDate.getDate();
                if (date == null) {
                    date = new Date();
                }
                this.root = (VoiceCostMapItem)VoiceCommonUtils.readFromHolder((byte[])Base64.getDecoder().decode(costMapService.voiceCostMapItemTree(this.currentCostMap.getId(), date)));
                if (this.root == null) {
                    return;
                }
                this.costMapItemModel.setData(this.root);
            } else {
                Date date = this.rangeDate.getDate();
                if (date == null) {
                    date = new Date();
                }
                VoiceService voiceService = (VoiceService)((ClientContext)this.getContext()).getWebService(VoiceService.class);
                List costMapRangeItems = costMapService.voiceCostMapRangeItems(this.currentCostMap.getId(), date);
                HashSet destinationIds = new HashSet();
                costMapRangeItems.forEach(a -> destinationIds.add(a.getDestinationId()));
                List rangeDestinationList = voiceService.voiceDestinationTitles(new ArrayList(destinationIds));
                ArrayList<CostMapRangeItem> newRangeList = new ArrayList<CostMapRangeItem>();
                for (VoiceCostMapRangeItem costMapRangeItem : costMapRangeItems) {
                    CostMapRangeItem item = new CostMapRangeItem(this);
                    item.rangeItem = costMapRangeItem;
                    item.destination = rangeDestinationList.stream().filter(a -> a.getId() == item.rangeItem.getDestinationId()).findFirst().orElse(null);
                    newRangeList.add(item);
                }
                this.rangeList = newRangeList;
                this.rangeModel.setData(this.rangeList);
            }
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.costMapTitle.setText(this.currentCostMap.getTitle());
            this.comment.setText(this.currentCostMap.getComment());
            this.performAction("refresh");
            this.enableTreeAndToolBar(true);
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.performAction(VoiceCostMapEditorForm.SAVE);
                VoiceCostMapEditorForm.this.hideEditorAndRefresh();
            }
        };
        new AbstractBGUPanel.DefaultAction(SAVE, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                String title = VoiceCostMapEditorForm.this.costMapTitle.getText();
                if (Utils.isBlankString((String)title)) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapEditorForm.this.costMapTitle, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d!");
                    return;
                }
                VoiceCostMapService costMapService = (VoiceCostMapService)((ClientContext)VoiceCostMapEditorForm.this.getContext()).getPort(VoiceCostMapService.class);
                if (VoiceCostMapEditorForm.this.currentCostMap == null) {
                    VoiceCostMapEditorForm.this.currentCostMap = new VoiceCostMap();
                }
                VoiceCostMapEditorForm.this.currentCostMap.setTitle(VoiceCostMapEditorForm.this.costMapTitle.getText());
                VoiceCostMapEditorForm.this.currentCostMap.setComment(VoiceCostMapEditorForm.this.comment.getText());
                VoiceCostMapEditorForm.this.currentCostMap.setOperatorId(VoiceCostMapEditorForm.this.parentPanel.getOperatorId());
                VoiceCostMapEditorForm.this.currentCostMap.setId(costMapService.voiceCostMapUpdate(VoiceCostMapEditorForm.this.currentCostMap));
                VoiceCostMapEditorForm.this.enableTreeAndToolBar(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("reset", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.performAction("edit");
            }
        };
        new AbstractBGUPanel.DefaultAction("cancel", "\u041e\u0442\u043c\u0435\u043d\u0430"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.hideEditorAndRefresh();
            }
        };
        new AbstractBGUPanel.DefaultAction(BGDialogToolBar.ButtonData.NEW_ITEM.getName(), "\u041d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (VoiceCostMapEditorForm.this.tabbedPane.getSelectedIndex() == 0) {
                    VoiceCostMapItem newItem = new VoiceCostMapItem();
                    newItem.setCostMapId(VoiceCostMapEditorForm.this.currentCostMap.getId());
                    VoiceCostMapEditorForm.this.setVisibleBottomPanels(true, false);
                    VoiceCostMapEditorForm.this.itemEditor.setCurrentItem(newItem);
                    VoiceCostMapEditorForm.this.itemEditor.performAction("new");
                } else {
                    new RangeEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0434\u043b\u044f \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u043e\u0432", new CostMapRangeItem(VoiceCostMapEditorForm.this)).open();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(BGDialogToolBar.ButtonData.EDIT_ITEM.getName(), "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapItem selectedItem = (VoiceCostMapItem)VoiceCostMapEditorForm.this.costMapItemModel.getSelectedRow();
                if (selectedItem == null) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapEditorForm.this.costMapItemTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d!");
                    return;
                }
                VoiceCostMapEditorForm.this.setVisibleBottomPanels(true, false);
                VoiceCostMapEditorForm.this.itemEditor.setCurrentItem(selectedItem);
                VoiceCostMapEditorForm.this.itemEditor.performAction("edit");
            }
        };
        new AbstractBGUPanel.DefaultAction(BGDialogToolBar.ButtonData.DELETE_ITEM.getName(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List selectedItems = VoiceCostMapEditorForm.this.costMapItemModel.getSelectedRows();
                if (selectedItems == null || selectedItems.size() < 1) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapEditorForm.this.costMapItemTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e \u043a\u0440\u0430\u0439\u043d\u0435\u0439 \u043c\u0435\u0440\u0435 \u043e\u0434\u0438\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d!");
                    return;
                }
                String confirmMessage = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + (selectedItems.size() > 1 ? "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b" : "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442?") + "?";
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), confirmMessage, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    VoiceCostMapService costMapService = (VoiceCostMapService)((ClientContext)VoiceCostMapEditorForm.this.getContext()).getPort(VoiceCostMapService.class);
                    List itemIdsForDelete = selectedItems.stream().map(code -> code.getId()).collect(Collectors.toList());
                    costMapService.voiceCostMapItemDelete(itemIdsForDelete);
                    VoiceCostMapEditorForm.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(BGDialogToolBar.ButtonData.DELETE_ALL_ITEM.getName(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                String confirmMessage = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u0437 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d?";
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), confirmMessage, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    VoiceCostMapService costMapService = (VoiceCostMapService)((ClientContext)VoiceCostMapEditorForm.this.getContext()).getPort(VoiceCostMapService.class);
                    costMapService.voiceCostMapItemDeleteAll(VoiceCostMapEditorForm.this.currentCostMap.getId());
                    VoiceCostMapEditorForm.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(BGDialogToolBar.ButtonData.EXPORT.getName(), "\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.setVisibleBottomPanels(false, true);
                VoiceCostMapEditorForm.this.exportPanel.performActionOpen();
            }
        };
        new AbstractBGUPanel.DefaultAction(BGDialogToolBar.ButtonData.IMPORT.getName(), "\u0418\u043c\u043f\u043e\u0440\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                new VoiceCostMapImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d", VoiceCostMapEditorForm.this.currentCostMap, VoiceCostMapEditorForm.this.parentPanel.getOperatorId(), (VoiceCostMapService)((ClientContext)VoiceCostMapEditorForm.this.getContext()).getPort(VoiceCostMapService.class), VoiceCostMapEditorForm.this).open();
            }
        };
        new AbstractBGUPanel.DefaultAction("range." + BGDialogToolBar.ButtonData.EDIT_ITEM.getName(), "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                CostMapRangeItem selectedItem = (CostMapRangeItem)VoiceCostMapEditorForm.this.rangeModel.getSelectedRow();
                if (selectedItem == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d!");
                    return;
                }
                new RangeEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0434\u043b\u044f \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u043e\u0432", selectedItem).open();
            }
        };
    }

    private void enableTreeAndToolBar(boolean enable) {
        this.costMapItemTable.setEnabled(enable);
    }

    BGButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setCostMap(VoiceCostMap costMap) {
        this.currentCostMap = costMap;
    }

    public BGTreeTableModel<VoiceCostMapItem> getCostMapItemTableModel() {
        return this.costMapItemModel;
    }

    public void setVisibleBottomPanels(boolean hideEditor, boolean hideExport) {
        this.itemEditor.setVisible(hideEditor);
        this.exportPanel.setVisible(hideExport);
    }

    public void hideEditorAndRefresh() {
        this.parentPanel.switchToTableMode();
        this.parentPanel.performAction("refresh");
    }

    public int getOperatorId() {
        return this.parentPanel.getOperatorId();
    }

    private VoiceCostMapItem buildFilterTree(VoiceCostMapItem item, Set<Integer> ids) {
        VoiceCostMapItem result = null;
        if (ids.contains(item.getId())) {
            result = item.copy();
            if (Utils.notEmptyCollection((Collection)item.getChildren())) {
                result.setChildren(new ArrayList());
                for (VoiceCostMapItem item2 : item.getChildren()) {
                    VoiceCostMapItem a = this.buildFilterTree(item2, ids);
                    if (a == null) continue;
                    result.getChildren().add(a);
                }
            }
        }
        return result;
    }

    private void filterTreeNodeIds(String code, VoiceCostMapItem parentItem, List<Integer> parentIds, Set<Integer> ids) {
        if (Utils.notEmptyCollection((Collection)parentItem.getChildren())) {
            ArrayList<Integer> newParentIds = new ArrayList<Integer>(parentIds);
            newParentIds.add(parentItem.getId());
            for (VoiceCostMapItem item : parentItem.getChildren()) {
                this.filterTreeNodeIds(code, item, newParentIds, ids);
            }
        } else if (parentItem.getCode() != null && parentItem.getCode().startsWith(code)) {
            ids.add(parentItem.getId());
            ids.addAll(parentIds);
        }
    }

    class VoiceRandeTableModel
    extends BGTableModel<CostMapRangeItem> {
        public VoiceRandeTableModel() {
            super(VoiceRandeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", 100, 150, 150, "rangeFrom", true, (TableCellRenderer)new LongFormatTableCellRenderer("(\\d)(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3 $4", 4));
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", 100, 150, 150, "rangeTo", true, (TableCellRenderer)new LongFormatTableCellRenderer("(\\d)(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3 $4", 4));
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", 200, 300, -1, "destinationId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440", 200, 300, 400, "mobileId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0441", -1, 130, 160, "dateFrom", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u043e", -1, 130, 160, "dateTo", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", -1, 160, 160, "itemCost", false, (TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("###,###,###,##0.00000")));
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 200, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }

        public Object getValue(CostMapRangeItem val, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "rangeFrom": {
                    return val.rangeItem.getRangeFrom();
                }
                case "rangeTo": {
                    return val.rangeItem.getRangeTo();
                }
                case "destinationId": {
                    return Optional.ofNullable(val.destination).map(a -> a.getTitle()).orElse("??? [#" + val.rangeItem.getDestinationId() + "]");
                }
                case "dateFrom": {
                    return val.rangeItem.getDateFrom();
                }
                case "dateTo": {
                    return val.rangeItem.getDateTo();
                }
                case "itemCost": {
                    return val.rangeItem.getCost();
                }
                case "comment": {
                    return val.rangeItem.getComment();
                }
                case "id": {
                    return val.rangeItem.getId();
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class VoiceCostMapItemTreeTableModel
    extends BGTreeTableModel<VoiceCostMapItem> {
        public VoiceCostMapItemTreeTableModel() {
            super(VoiceCostMapItemTreeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", VoiceGeographicCode.class, -1, 100, -1, "code", false);
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, 200, -1, "destinationTitle");
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0441", -1, 130, 160, "dateFrom", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u043e", -1, 130, 160, "dateTo", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", -1, 160, 160, "itemCost", false, (TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("###,###,###,##0.00000")));
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 200, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(VoiceCostMapItem val, int column) throws Exception {
            if (column == 0 && val == this.root) {
                return val.getTitle();
            }
            return super.getValue((Object)val, column);
        }
    }

    private class RangeFilterCaretListener
    implements PropertyChangeListener {
        private RangeFilterCaretListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("textChange".equals(evt.getPropertyName())) {
                List<Object> filterList = new ArrayList();
                String filterText = VoiceCostMapEditorForm.this.rangeDestinationFilter.getText();
                if (filterText.isEmpty()) {
                    filterList = VoiceCostMapEditorForm.this.rangeList;
                } else if (filterText.matches("^\\d{1,11}$")) {
                    long a1 = Utils.parseLong((String)(filterText + "0".repeat(11 - filterText.length())));
                    long a2 = Utils.parseLong((String)(filterText + "9".repeat(11 - filterText.length())));
                    filterList.addAll(VoiceCostMapEditorForm.this.rangeList.stream().filter(a -> a.rangeItem.getRangeFrom() <= a2 && a.rangeItem.getRangeTo() >= a1).toList());
                }
                VoiceCostMapEditorForm.this.rangeModel.setData(filterList);
                VoiceCostMapEditorForm.this.rangeRecords.setText("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)filterList.size()));
            }
        }
    }

    private class CodeFilterCaretListener
    implements PropertyChangeListener {
        private CodeFilterCaretListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("textChange".equals(evt.getPropertyName())) {
                VoiceCostMapItem filterRoot = VoiceCostMapEditorForm.this.root.copy();
                String filterText = VoiceCostMapEditorForm.this.codeDestinationFilter.getText();
                if (filterText.isEmpty()) {
                    filterRoot = VoiceCostMapEditorForm.this.root;
                } else if (filterText.matches("^\\d{1,11}$")) {
                    HashSet<Integer> ids = new HashSet<Integer>();
                    VoiceCostMapEditorForm.this.filterTreeNodeIds(filterText, VoiceCostMapEditorForm.this.root, new ArrayList<Integer>(), ids);
                    filterRoot = VoiceCostMapEditorForm.this.buildFilterTree(VoiceCostMapEditorForm.this.root, ids);
                }
                VoiceCostMapEditorForm.this.costMapItemModel.setData(filterRoot);
                VoiceCostMapEditorForm.this.codeRecords.setText("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)filterRoot.sizeLeaf()));
            }
        }
    }

    class CostMapRangeItem {
        VoiceCostMapRangeItem rangeItem;
        IdTitle destination;

        CostMapRangeItem(VoiceCostMapEditorForm this$0) {
        }
    }

    class VoiceRangeItem
    implements GuiTitlable {
        VoiceGeographicRange geographicRange;
        IdTitle destination;

        VoiceRangeItem(VoiceCostMapEditorForm this$0, VoiceGeographicRange geographicRange) {
            this.geographicRange = geographicRange;
        }

        public String getGuiTitle() {
            String from = String.valueOf(this.geographicRange.getRangeFrom()).replaceFirst("(\\d{1})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4");
            String to = String.valueOf(this.geographicRange.getRangeTo()).replaceFirst("(\\d{1})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4");
            return this.geographicRange == null ? "=== \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ===" : from + " - " + to + "         " + this.destination.getTitle();
        }
    }

    class SelectVoiceRangeDialog
    extends BGEditorDialog<VoiceRangeItem> {
        private BGTextField search;
        private BGUList<VoiceRangeItem> result;

        public SelectVoiceRangeDialog(String title, VoiceRangeItem data) {
            super(title, (Object)data);
            this.search = new BGTextField(50);
            this.result = new BGUList();
        }

        public void doDialogPanel() {
            this.search.setPromptText("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443", true, true);
            this.search.setHorizontalAlignment(0);
            this.search.addPropertyChangeListener(e -> {
                if ("textChange".equals(e.getPropertyName())) {
                    ArrayList<VoiceRangeItem> items = new ArrayList<VoiceRangeItem>();
                    String txt = this.search.getText();
                    if (txt.length() > 3) {
                        try {
                            VoiceService voiceService = (VoiceService)((ClientContext)VoiceCostMapEditorForm.this.getContext()).getWebService(VoiceService.class);
                            List geographicRanges = voiceService.voiceGeographicRangeSearch(((VoiceRangeItem)this.data).geographicRange.getOperatorId(), txt);
                            List destinations = voiceService.voiceDestinationTitles(geographicRanges.stream().map(a -> a.getDestinationId()).toList());
                            for (VoiceGeographicRange range : geographicRanges) {
                                VoiceRangeItem item = new VoiceRangeItem(VoiceCostMapEditorForm.this, range);
                                item.destination = destinations.stream().filter(a -> a.getId() == range.getDestinationId()).findFirst().orElse(new IdTitle(0, "??? [#" + range.getDestinationId() + "]"));
                                items.add(item);
                            }
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                    this.result.setData(items);
                }
            });
            this.result.setSelectionMode(0);
            this.result.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        ((JButton)SelectVoiceRangeDialog.this.optionPane.getOptions()[0]).doClick();
                    }
                }
            });
            this.panel.add((Component)this.search, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.result, (int)800, (int)200), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            VoiceRangeItem item = (VoiceRangeItem)this.result.getSelectedValue();
            if (item == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 ");
                return false;
            }
            ((VoiceRangeItem)this.data).destination = item.destination;
            ((VoiceRangeItem)this.data).geographicRange = item.geographicRange;
            return true;
        }

        public void doCancel() {
            this.data = null;
        }
    }

    class RangeEditorDialog
    extends BGEditorDialog<CostMapRangeItem> {
        private JTextField cost;
        private BGTextArea comment;
        private JButton range;
        private BGControlPanelPeriodNoB period;

        public RangeEditorDialog(String title, CostMapRangeItem data) {
            super(title, (Object)data);
            this.cost = new JTextField(10);
            this.comment = new BGTextArea(2, 50);
            this.range = new JButton();
            this.period = new BGControlPanelPeriodNoB();
        }

        public void doDialogPanel() {
            Dimension dimension = new Dimension(300, 100);
            this.range.setPreferredSize(dimension);
            this.range.setMinimumSize(dimension);
            this.range.setFocusPainted(false);
            this.range.setBackground(new JTextField().getBackground());
            if (((CostMapRangeItem)this.data).rangeItem.getId() == 0) {
                this.range.addActionListener(e -> {
                    VoiceRangeItem rangeItem = new VoiceRangeItem(VoiceCostMapEditorForm.this, new VoiceGeographicRange());
                    rangeItem.geographicRange.setOperatorId(VoiceCostMapEditorForm.this.currentCostMap.getOperatorId());
                    SelectVoiceRangeDialog dialog = new SelectVoiceRangeDialog("\u0412\u044b\u0431\u043e\u0440 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430", rangeItem);
                    dialog.open();
                    if (dialog.getData() != null) {
                        ((CostMapRangeItem)this.data).rangeItem.setRangeId(rangeItem.geographicRange.getId());
                        ((CostMapRangeItem)this.data).destination = rangeItem.destination;
                        this.setRangeButtonText();
                    }
                });
            }
            this.cost.setHorizontalAlignment(0);
            this.panel.add((Component)new JLabel("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.range, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getPeriodCostPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane((Component)this.comment), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.setRangeButtonText();
            this.period.setDateFrom(((CostMapRangeItem)this.data).rangeItem.getDateFrom());
            this.period.setDateTo(((CostMapRangeItem)this.data).rangeItem.getDateTo());
            this.cost.setText(((CostMapRangeItem)this.data).rangeItem.getCost() == null ? "0.00" : ((CostMapRangeItem)this.data).rangeItem.getCost().toPlainString());
            this.comment.setText(((CostMapRangeItem)this.data).rangeItem.getComment());
        }

        private void setRangeButtonText() {
            String dest = this.data != null && ((CostMapRangeItem)this.data).destination != null ? ((CostMapRangeItem)this.data).destination.getTitle() : "???";
            this.range.setText((String)(((CostMapRangeItem)this.data).rangeItem == null ? "\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d" : "<html><center><h1>" + ((CostMapRangeItem)this.data).rangeItem.getRangeFrom() + " - " + ((CostMapRangeItem)this.data).rangeItem.getRangeTo() + "</h1>" + dest + "</center></html>"));
        }

        private JPanel getPeriodCostPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:"), new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 0.5, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)this.cost, new GridBagConstraints(1, -1, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            if (((CostMapRangeItem)this.data).rangeItem == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d");
                return false;
            }
            if (!this.cost.getText().replace(',', '.').matches("\\d+(\\.\\d{1,2})?")) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 (X.XX)");
                return false;
            }
            VoiceCostMapRange voiceCostMapRange = VoiceCostMapRange.builder().setId(((CostMapRangeItem)this.data).rangeItem.getId()).setCostMapId(VoiceCostMapEditorForm.this.currentCostMap.getId()).setRangeId(((CostMapRangeItem)this.data).rangeItem.getRangeId()).setDateFrom(this.period.getLocalDateFrom()).setDateTo(this.period.getLocalDateTo()).setRangeCost(new BigDecimal(this.cost.getText().replace(',', '.'))).setComment(this.comment.getText()).build();
            ((VoiceCostMapService)((ClientContext)VoiceCostMapEditorForm.this.getContext()).getWebService(VoiceCostMapService.class)).voiceCostMapRangeUpdate(voiceCostMapRange);
            return true;
        }
    }
}

