/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.task;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class VoiceBalanceTask
extends TaskBase {
    private Set<Integer> contracts = new HashSet<Integer>();

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        LocalDate month = TimeUtils.convertDateToLocalDate((Date)this.getOperatingTime().getTime());
        month = month.minusDays(this.taskSetup.getInt("minus.days", 0));
        String sessionTable = ServerUtils.getModuleMonthTableName((String)"voice_session_account_log", (LocalDate)month, (int)this.moduleId);
        try (Connection con = this.setup.getDBConnectionFromPool();){
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("sessionTable = {}", (Object)sessionTable);
            }
            if (!ServerUtils.tableExists((Connection)con, (String)sessionTable)) {
                return;
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("contractIds = {}", (Object)Utils.toString(this.contracts));
            }
            ServiceCostCache costCache = new ServiceCostCache();
            String query = "SELECT contractId, serviceId, SUM(account) FROM " + sessionTable + (String)(Utils.notEmptyCollection(this.contracts) ? " WHERE contractId IN (" + Utils.toString(this.contracts) + ")" : "") + " GROUP BY contractId, serviceId";
            try (PreparedStatement ps = con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    CostSum costSum = new CostSum(rs.getInt(1), rs.getInt(2), rs.getBigDecimal(3));
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace("costSum = {}", (Object)costSum);
                    }
                    costCache.addAmount(costSum);
                }
            }
            String serviceIds = ModuleCache.getInstance().getModuleServicesString(Integer.valueOf(this.moduleId).intValue());
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("sserviceIds = {}", (Object)serviceIds);
            }
            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(TimeUtils.convertLocalDateToDate((LocalDate)month));
                balanceUtils.setAccount(con, this.getLogger(), (Calendar)cal, costCache, serviceIds, Utils.toString(this.contracts), null);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("error while executing \"" + this.getDescription() + "\"" + ex.getMessage(), (Throwable)ex);
        }
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c Voice. \u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b:" + String.valueOf(this.contracts);
    }

    protected void setContracts(Set<Integer> contracts) {
        this.contracts = contracts;
    }

    public List<TaskParameter> taskParameters() {
        ArrayList<TaskParameter> taskParameters = new ArrayList<TaskParameter>();
        taskParameters.add(new TaskParameter().setKey("minus.days").setTitle("minus.days").setDefaultValue("0"));
        return taskParameters;
    }
}

