/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostIntercomService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostIntercomRuntime;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseParamData;
import ru.bitel.common.Utils;

public class TableForpostIntercomUserEdit
extends BGTableInfoBase {
    private List<SmartHouseParamData> params;

    public TableForpostIntercomUserEdit() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", (String)"name").setWidth(400), BGUTableColumn.buildColumnTextLeft((String)"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", (String)"value").setWidth(-1)};
        this.params = Arrays.asList(new SmartHouseParamData("Login", "text", "\u041b\u043e\u0433\u0438\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", ""), new SmartHouseParamData("Password", "text", "\u041f\u0430\u0440\u043e\u043b\u044c", ""), new SmartHouseParamData("IsActive", "0/1", "\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442/\u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f: 1 - \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e) 0 - \u0412\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c", "1"), new SmartHouseParamData("IsReadOnly", "0/1", "\u0417\u0430\u043f\u0440\u0435\u0442\u0438\u0442\u044c \u043f\u043e\u043b\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043a\u0430\u043c\u0435\u0440\u0430\u043c: 1 \u0438\u043b\u0438 0 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e)", "1"), new SmartHouseParamData("IsAccountUserAdmin", "0/1", "\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c\u0438, \u0435\u0441\u043b\u0438 IsReadOnly=1: 1 \u0438\u043b\u0438 0 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e)", "1"), new SmartHouseParamData("IsAccessibleNewCameraByDefault", "0/1", "\u0420\u0430\u0437\u0440\u0435\u0448\u0430\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043d\u043e\u0432\u044b\u043c \u043a\u0430\u043c\u0435\u0440\u0430\u043c, \u0435\u0441\u043b\u0438 IsReadOnly=1: 1 \u0438\u043b\u0438 0 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e)", "1"), new SmartHouseParamData("IsPassAdmin", "0/1", "\u0420\u0430\u0437\u0440\u0435\u0448\u0430\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0440\u0430\u0437\u0434\u0435\u043b\u0443 \u0421\u041a\u0423\u0414, \u0435\u0441\u043b\u0438 IsReadOnly=1: 1 \u0438\u043b\u0438 0 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e)", "1"), new SmartHouseParamData("CanChangeOwnInfo", "0/1", "\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u0438 \u043c\u0435\u043d\u044f\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c: 1 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e) \u0438\u043b\u0438 0", "1"), new SmartHouseParamData("ChangePasswordAtNextLogin", "0/1", "\u0417\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u043f\u0440\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u043c \u0432\u0445\u043e\u0434\u0435: 1 \u0438\u043b\u0438 0 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e)", "0"), new SmartHouseParamData("ExternalID", "text", "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432\u043e \u0432\u043d\u0435\u0448\u043d\u0435\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u0414\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0442\u044c \u043f\u0443\u0441\u0442\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.", ""));
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        int userId = Utils.parseInt((String)tableParams.get("id"));
        int accountId = Utils.parseInt((String)tableParams.get("accountId"));
        ForpostUser forpostUser = null;
        if (userId > 0) {
            ForpostIntercomRuntime forpostIntercomRuntime = ForpostIntercomRuntime.getInstance(moduleId);
            forpostUser = forpostIntercomRuntime.getAccountUsers(accountId).stream().filter(a -> a.getId() == userId).findFirst().orElse(null);
        } else {
            forpostUser = ((ForpostIntercomService)this.getContext().getService(ForpostIntercomService.class, moduleId)).forpostIntercomUserDefault();
        }
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        for (SmartHouseParamData data : this.params) {
            String value = switch (data.getName()) {
                case "IsActive" -> String.valueOf(forpostUser.getIsActive());
                case "Login" -> forpostUser.getLogin();
                default -> forpostUser.getString(data.getName());
            };
            BGUTableRowData rowData = new BGUTableRowData().addValue("name", data.getName()).addValue("type", data.getType()).addValue("title", data.getTitle()).addValue("value", value);
            rowDatas.add(rowData);
        }
        return rowDatas;
    }
}

