/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius;

import bitel.billing.server.radius.AttributeParams;
import bitel.billing.server.radius.RadiusAttribute;
import bitel.billing.server.radius.RadiusAttributes;

public final class RadiusVendorAttribute
extends RadiusAttribute {
    private final int vendorCode;

    public RadiusVendorAttribute(int vendorCode, int attrCode) {
        super(attrCode);
        this.vendorCode = vendorCode;
    }

    public int getVendorCode() {
        return this.vendorCode;
    }

    @Override
    public String toString() {
        String result = "undef";
        AttributeParams attribute = RadiusAttributes.getVendorAttributeParams(this.vendorCode, this.getAttrCode());
        if (attribute != null) {
            result = this.valueToString(attribute);
        }
        return result;
    }

    @Override
    public void loadFromString(String value) {
        AttributeParams attribute = RadiusAttributes.getVendorAttributeParams(this.vendorCode, this.getAttrCode());
        if (attribute != null) {
            this.valueFromString(attribute, value);
        }
    }

    @Override
    public String getStringValue() {
        int pos;
        AttributeParams attribute = RadiusAttributes.getVendorAttributeParams(this.vendorCode, this.getAttrCode());
        String value = super.getStringValue();
        if (value != null && attribute != null && attribute.isFlag() && (pos = value.indexOf("=")) > 0) {
            value = value.substring(pos + 1);
        }
        return value;
    }

    @Override
    public void setStringValue(String value) {
        StringBuilder fullValue = new StringBuilder(40);
        AttributeParams at = RadiusAttributes.getVendorAttributeParams(this.vendorCode, this.getAttrCode());
        if (at != null && at.isFlag()) {
            fullValue.append(at.getName().toLowerCase());
            fullValue.append("=");
            fullValue.append(value);
        } else {
            fullValue.append(value);
        }
        super.setStringValue(fullValue.toString());
    }

    @Override
    public RadiusVendorAttribute clone() {
        RadiusVendorAttribute result = new RadiusVendorAttribute(this.vendorCode, this.code);
        result.byteValue = new byte[this.byteValue.length];
        result.length = this.length;
        System.arraycopy(this.byteValue, 0, result.byteValue, 0, this.byteValue.length);
        return result;
    }
}

