/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetServiceCost;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;

public final class CostTariffTreeNode
extends TariffTreeNode<InetTariffRequest, TariffContext, TreeContext, InetTariffWorkerContext> {
    private final int type;
    private final long col;
    private final BigDecimal divisor;
    private final BigDecimal cost;

    public CostTariffTreeNode(int id, ParameterMap params) {
        super(id, params);
        this.type = params.getInt("type", 0);
        this.col = params.getLong("col", 0L);
        if (this.col >= 0L) {
            this.cost = params.getBigDecimal("cost", BigDecimal.ZERO);
            long divisor = this.getServiceAmount(this.type, this.col);
            this.divisor = divisor != 0L && divisor != 1L ? BigDecimal.valueOf(divisor) : null;
        } else {
            this.cost = null;
            this.divisor = null;
        }
    }

    protected final int executeImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, TariffContext ctx, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        if (this.cost != null && req.serviceCost != null) {
            if (this.divisor != null) {
                ((InetServiceCost)req.serviceCost).setCost(this.cost.multiply(BigDecimal.valueOf(((InetServiceCost)req.serviceCost).getAmount()), ctx.mc).divide(this.divisor, ctx.mc));
            } else {
                ((InetServiceCost)req.serviceCost).setCost(this.cost.multiply(BigDecimal.valueOf(((InetServiceCost)req.serviceCost).getAmount()), ctx.mc));
            }
        }
        return 1;
    }

    protected final int postExecuteImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, TariffContext ctx, TreeContext treeContext, InetTariffWorkerContext workerContext, int executeResult) {
        return executeResult;
    }
}

