/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.modules.dialup.server;

import java.sql.Connection;
import java.util.Calendar;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.modules.dialup.server.action.ActionLoginSessions;
import ru.bitel.bgbilling.plugins.dispatch.server.interaction.ModuleResponse;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ModuleRequest
implements ru.bitel.bgbilling.plugins.dispatch.server.interaction.ModuleRequest {
    @Override
    public ModuleResponse ask(Connection con, int contractId, int moduleId, String action, Preferences prefs) throws BGException {
        ModuleResponse result = null;
        if ("session".equals(action)) {
            result = this.dispatchSessions(con, contractId, moduleId, prefs);
        }
        return result;
    }

    private ModuleResponse dispatchSessions(Connection con, int contractId, int moduleId, Preferences prefs) throws BGException {
        ModuleResponse response = null;
        ActionLoginSessions action = null;
        try {
            Document doc = XMLUtils.newDocument();
            Element rootNode = doc.createElement("data");
            doc.appendChild(rootNode);
            Calendar now = Calendar.getInstance();
            String classPath = "bitel.billing.server.dialup.action.ActionLoginSessions";
            action = (ActionLoginSessions)Utils.newInstance((String)classPath, ActionLoginSessions.class);
            action.init(Setup.getSetup(), rootNode, contractId, "voiceip", moduleId);
            int loginId = prefs.getInt(moduleId + ".dialup_login_id", -1);
            action.sessions(now, loginId);
            String xsltName = rootNode.getAttribute("xslt");
            if (xsltName.length() == 0) {
                System.err.println("dialup.ModuleRequest.dispatchSession: XSLT name not found!");
            } else {
                response = new ModuleResponse();
                response.setMessage("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u044f\u043c \u0432\u043e \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u0445.");
                response.setFile(XSLManager.getInstance().transform("dialup_login_sessions.xsl", (Source)new DOMSource(rootNode.getOwnerDocument()), null, "text/html", "dialup_sessions.html", false));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            if (action != null) {
                action.freeConnection();
            }
        }
        return response;
    }
}

