/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.Sovintel;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.SovintelReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class InvoiceReport2
extends SovintelReport {
    public InvoiceReport2(Sovintel operator, Date month, int id) {
        super(operator, month, id);
    }

    @Override
    public void getData(Connection con, OutputStream out) {
        try {
            String sessionTable;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "Cp1251"));
            CSVWriter printer = new CSVWriter((Writer)writer, ';');
            int mid = this.oper.getModuleId();
            Preferences operSetup = this.oper.getOperatorSetup();
            int billModuleId = operSetup.getInt("bill.module.id", 0);
            String contract = operSetup.get("contract", "UNDEF");
            int lastPayDay = operSetup.getInt("last.pay.day", 25);
            Map<Integer, Integer> serviceMpa = this.oper.getBillingToOperServiceMap();
            String locationCode = operSetup.get("location.code", "0");
            Calendar monthCalendar = TimeUtils.convertDateToCalendar((Date)this.month);
            Calendar lastPayDate = (Calendar)monthCalendar.clone();
            lastPayDate.add(2, 1);
            lastPayDate.set(5, lastPayDay);
            String lastPayDateString = TimeUtils.formatDate((Calendar)lastPayDate);
            Calendar lastMonthDay = TimeUtils.getEndMonth((Calendar)monthCalendar);
            String lastMonthDayString = TimeUtils.formatDate((Calendar)lastMonthDay);
            String invoiceTable = "bill_invoice_data_" + billModuleId;
            if (!ServerUtils.tableExists((Connection)con, (String)invoiceTable)) {
                writer.write("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + invoiceTable + "!\n");
                ((Writer)writer).flush();
            }
            if (!ServerUtils.tableExists((Connection)con, (String)(sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)this.month, (int)mid)))) {
                writer.write("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + sessionTable + "!\n");
                ((Writer)writer).flush();
            }
            int pos = 1;
            String query = "SELECT sub_contract.title, bill.format_number, bill.create_dt, session.cid, session.sid, SUM(session.cost), SUM(session.round_session_time)/60 FROM " + sessionTable + " AS session INNER JOIN contract AS sub_contract ON session.cid=sub_contract.id INNER JOIN contract ON sub_contract.scid=contract.id LEFT JOIN " + invoiceTable + " AS bill ON session.cid=bill.cid AND bill.yy=? AND bill.mm=? WHERE session.sid IN (" + Utils.toString(this.oper.getServiceList()) + ") GROUP BY session.cid, session.sid";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, monthCalendar.get(1));
            ps.setInt(2, monthCalendar.get(2));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int billingServiceId = rs.getInt(5);
                Integer operServiceId = serviceMpa.get(billingServiceId);
                if (operServiceId == null) {
                    operServiceId = billingServiceId;
                }
                printer.writeNext(new String[]{String.valueOf(pos++), contract, rs.getString(1), rs.getString(2), rs.getString(2), TimeUtils.formatDate((Date)rs.getDate(3)), lastPayDateString, "0", "2", String.valueOf(operServiceId), lastMonthDayString, rs.getString(6), rs.getString(7), locationCode, "1", ""}, false);
            }
            rs.close();
            ps.close();
            printer.close();
            ((Writer)writer).close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    @Override
    public String getFileName() {
        return this.getOperCode() + "_BIL_" + TimeUtils.format((Date)this.month, (String)"yyyy_MM") + ".csv";
    }

    @Override
    public String getTitle() {
        return "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u043c \u0441\u0447\u0435\u0442\u0430\u043c-\u0444\u0430\u043a\u0442\u0443\u0440\u0430\u043c, \u0430\u043a\u0442\u0430\u043c, \u0423\u041f\u0414";
    }

    @Override
    public int getType() {
        return 2;
    }
}

