/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.client;

import bitel.billing.module.common.BSHEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptLibrary;
import ru.bitel.bgbilling.kernel.script.common.service.ScriptService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.action.BGUAction;
import ru.bitel.common.client.table.BGTableModel;

public class ScriptLibraryTabPanel
extends BGTabPanel {
    public static final String TAB_ID = "LibScriptFunctions";
    private BGEditor bgEditor = new BGEditor("table");
    private ScriptLibraryPanel scriptLibraryPanel;
    private Editor editorPanel;
    private ScriptHistoryPanel shPanel;
    private ViewBackupPanel viewer;

    public ScriptLibraryTabPanel() {
        super(TAB_ID, "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432 (\u0443\u0441\u0442\u0430\u0440\u0435\u043b\u043e)");
        this.module = "script";
        this.setLayout(new BorderLayout());
        this.add((Component)this.bgEditor, "Center");
        this.bgEditor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this, "setData"));
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.scriptLibraryPanel = new ScriptLibraryPanel();
        this.bgEditor.addForm(this.scriptLibraryPanel);
        this.editorPanel = new Editor();
        this.bgEditor.addForm(this.editorPanel);
        this.shPanel = new ScriptHistoryPanel(2);
        this.bgEditor.addForm(this.shPanel);
        this.viewer = new ViewBackupPanel();
        this.bgEditor.addForm(this.viewer);
        this.bgEditor.show("table");
        this.setData();
    }

    @Override
    public void setData() {
        this.scriptLibraryPanel.performAction("refresh");
    }

    @Override
    public void editItem() {
        ((BGUPanel)this.bgEditor.getCurrentForm()).performAction("edit");
    }

    @Override
    public void newItem() {
        ((BGUPanel)this.bgEditor.getCurrentForm()).performAction("new");
    }

    @Override
    public void deleteItem() {
        ((BGUPanel)this.bgEditor.getCurrentForm()).performAction("delete");
    }

    class ScriptLibraryPanel
    extends BGUPanel {
        private BGUTable table;
        private BGTableModel<ScriptLibrary> model;

        public ScriptLibraryPanel() {
            super(new BorderLayout());
            this.model = new BGTableModel<ScriptLibrary>("script_lib"){

                @Override
                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u0418\u043c\u044f", 120, 120, 200, "name", true);
                    this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", 140, 140, -1, "title", true);
                }
            };
            this.setName("table");
        }

        @Override
        protected void jbInit() {
            this.table = new BGUTable(this.model);
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        ScriptLibraryTabPanel.this.editorPanel.performAction("edit");
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)BGSwingUtilites.wrapBorder(new JScrollPane(this.table), " \u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 (\u0443\u0441\u0442\u0430\u0440\u0435\u043b\u043e) "), "Center");
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh(e -> this.model.setData(((ClientContext)this.getContext()).getPort(ScriptService.class).pureList()));
            new AbstractBGUPanel.BGActionNew(e -> ScriptLibraryTabPanel.this.editorPanel.performAction("new"));
            new AbstractBGUPanel.BGActionEdit(e -> ScriptLibraryTabPanel.this.editorPanel.performAction("edit"));
            new AbstractBGUPanel.BGActionDelete(e -> {
                ScriptLibrary lib = ScriptLibraryTabPanel.this.scriptLibraryPanel.model.getSelectedRow();
                if (lib != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043c\u0435\u0441\u0442\u0435 \u0441 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u043e\u0439 \u0443\u0434\u0430\u043b\u044f\u0442\u0441\u044f \u0432\u0441\u0435 \u0435\u0451 \u0431\u044d\u043a\u0430\u043f\u044b. \u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    try {
                        ((ClientContext)this.getContext()).getPort(ScriptService.class).deleteLibrary(lib.getId());
                        this.performAction("refresh");
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            });
        }
    }

    class Editor
    extends BGUPanel {
        private BGTextField name;
        private BGTextField title;
        private BSHEditor script;
        private String currentId;

        public Editor() {
            super(new BorderLayout());
            this.setName("editor");
        }

        @Override
        protected void jbInit() {
            this.setLayout(new GridBagLayout());
            this.name = new BGTextField();
            this.title = new BGTextField();
            this.script = new BSHEditor();
            this.add((Component)BGSwingUtilites.wrapBorder(this.name, " \u0418\u043c\u044f "), new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)BGSwingUtilites.wrapBorder(this.title, " \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 "), new GridBagConstraints(1, 0, 1, 1, 0.7, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)BGSwingUtilites.wrapBorder(this.script, " \u041a\u043e\u0434 "), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
            DocumentListener dlistener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Editor.this.buttonChange(true);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    Editor.this.buttonChange(true);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    Editor.this.buttonChange(true);
                }
            };
            this.script.getTextPane().getDocument().addDocumentListener(dlistener);
            this.title.getDocument().addDocumentListener(dlistener);
            this.name.getDocument().addDocumentListener(dlistener);
            this.buttonChange(false);
        }

        @Override
        protected void initActions() {
            this.getActionMap().put("left.backup", new BGUAction("left.backup", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientUtils.showMessageDialog("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434");
                }
            });
            this.getActionMap().put("left.history", new BGUAction("left.history", "\u0418\u0441\u0442\u043e\u0440\u0438\u044f"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Integer scriptId = Integer.valueOf(Editor.this.currentId);
                    if (scriptId > 0) {
                        ScriptLibraryTabPanel.this.shPanel.currentId = scriptId;
                        ScriptLibraryTabPanel.this.shPanel.performAction("refresh");
                        ScriptLibraryTabPanel.this.bgEditor.show("history");
                    }
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ClientUtils.showMessageDialog("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434");
                }
            };
            new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (Editor.this.getActionMap().get("ok").isEnabled() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                        Editor.this.getActionMap().get("ok").actionPerformed(e);
                    }
                    this.getParentAction().actionPerformed(e);
                }
            };
            new AbstractBGUPanel.BGActionNew(e -> ClientUtils.showMessageDialog("\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434"));
            new AbstractBGUPanel.BGActionEdit(e -> {
                if (this.isShowing()) {
                    this.performAction("nothing");
                    return;
                }
                ScriptLibrary lib = ScriptLibraryTabPanel.this.scriptLibraryPanel.model.getSelectedRow();
                String string = this.currentId = lib != null ? String.valueOf(lib.getId()) : null;
                if (this.currentId != null && (lib = this.getLastLibrary()) != null) {
                    this.currentId = String.valueOf(lib.getId());
                    this.name.setText(lib.getName());
                    this.title.setText(lib.getTitle());
                    this.script.setText(lib.getScript());
                    this.scriptIsExist(true);
                    this.buttonChange(false);
                    this.performActionOpen();
                }
            });
        }

        private ScriptLibrary getLastLibrary() {
            Integer scriptId = Integer.valueOf(this.currentId);
            if (scriptId != null) {
                try {
                    return ((ClientContext)this.getContext()).getPort(ScriptService.class).getLibrary(scriptId);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            return null;
        }

        private void buttonChange(boolean enable) {
            Action okButton = this.getActionMap().get("ok");
            if (okButton.isEnabled() != enable) {
                okButton.setEnabled(enable);
            }
        }

        private void scriptIsExist(boolean exist) {
            this.name.setEditable(!exist);
            this.getActionMap().get("left.backup").setEnabled(exist);
            this.getActionMap().get("left.history").setEnabled(exist);
        }
    }

    class ScriptHistoryPanel
    extends BGUPanel {
        protected int currentId;
        private int scriptType;
        private BGUTable table;
        private BGTableModel<ScriptBackup> model;

        public ScriptHistoryPanel(int type) {
            super(new BorderLayout());
            this.model = new BGTableModel<ScriptBackup>("script_backup"){

                @Override
                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u0412\u0440\u0435\u043c\u044f", 150, 150, 220, "time", true);
                    this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 150, 150, 220, "userName", true);
                    this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", 300, 300, 400, "title", false);
                    this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 140, 140, -1, "comment", false);
                }

                @Override
                public Object getValue(ScriptBackup val, int column) throws Exception {
                    if (column == 1) {
                        return TimeUtils.format(val.getTimeRevision(), "dd.MM.yyyy HH:mm:ss");
                    }
                    return super.getValue(val, column);
                }
            };
            this.setName("history");
            this.scriptType = type;
        }

        @Override
        protected void jbInit() {
            this.table = new BGUTable(this.model);
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int selectedBackupId;
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (selectedBackupId = ScriptHistoryPanel.this.model.getSelectedRow().getId()) > 0) {
                        ScriptLibraryTabPanel.this.viewer.currentBackupId = selectedBackupId;
                        ScriptLibraryTabPanel.this.viewer.performAction("refresh");
                        ScriptLibraryTabPanel.this.bgEditor.show("view");
                    }
                }
            });
            this.add((Component)BGSwingUtilites.wrapBorder(new JScrollPane(this.table), " \u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 "), "Center");
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh(e -> this.model.setData(((ClientContext)this.getContext()).getPort(ScriptService.class).listBackup(this.currentId, this.scriptType)));
            new AbstractBGUPanel.DefaultAction("close", "\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ScriptLibraryTabPanel.this.bgEditor.show("editor");
                }
            };
            new AbstractBGUPanel.BGActionDelete(e -> {
                ScriptBackup backup = ScriptLibraryTabPanel.this.shPanel.model.getSelectedRow();
                if (backup != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0431\u044d\u043a\u0430\u043f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    this.tryCall(() -> {
                        ((ClientContext)this.getContext()).getPort(ScriptService.class).deleteBackup(backup.getId());
                        this.performAction("refresh");
                    });
                }
            });
        }
    }

    public class ViewBackupPanel
    extends BGUPanel {
        protected int currentBackupId;
        private BGTextField title;
        private BSHEditor script;

        public ViewBackupPanel() {
            super(new GridBagLayout());
            this.setName("view");
        }

        @Override
        protected void jbInit() {
            this.title = new BGTextField();
            this.script = new BSHEditor();
            this.add((Component)BGSwingUtilites.wrapBorder(this.title, " \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)BGSwingUtilites.wrapBorder(this.script, " \u041a\u043e\u0434 "), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh(e -> {
                ScriptBackup backup = ((ClientContext)this.getContext()).getPort(ScriptService.class).getBackup(this.currentBackupId);
                this.title.setText(backup.getTitle());
                this.script.setText(backup.getScript());
            });
            new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ScriptLibraryTabPanel.this.bgEditor.show("history");
                }
            };
        }
    }
}

