/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.rscm.common.service.RSCMService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class SPP_PatternServices
extends BGUPanel {
    private List<IdTitle> serviceitems = null;
    private RscmServiceTableModel rscmServiceTableModel = new RscmServiceTableModel();

    public SPP_PatternServices(ClientContext context) {
        super(context);
    }

    protected void jbInit() {
        JButton newButton = new JButton(ClientUtils.getIcon((String)"item_add"));
        newButton.setActionCommand("new");
        newButton.setPreferredSize(new Dimension(20, 20));
        newButton.setBorderPainted(false);
        JButton deleteButton = new JButton(ClientUtils.getIcon((String)"item_delete"));
        deleteButton.setActionCommand("delete");
        deleteButton.setPreferredSize(new Dimension(20, 20));
        deleteButton.setBorderPainted(false);
        ActionListener al = e -> {
            if ("new".equals(e.getActionCommand())) {
                this.performAction("new");
            } else if ("delete".equals(e.getActionCommand())) {
                this.performAction("delete");
            }
        };
        newButton.addActionListener(al);
        deleteButton.addActionListener(al);
        this.setLayout(new GridBagLayout());
        this.add(newButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getTablePanel(), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.rscmServiceTableModel));
        table.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.performAction("edit"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane((Component)table), "Center");
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.startEdit(null));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.rscmServiceTableModel.optSelectedRow().ifPresent(a -> this.startEdit((RscmServiceTableRow)a)));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            RscmServiceTableRow row = (RscmServiceTableRow)this.rscmServiceTableModel.getSelectedRow();
            if (row != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.rscmServiceTableModel.getRows().remove(row);
                this.rscmServiceTableModel.fireTableDataChanged();
            }
        });
    }

    public void serializeParams(Element currentServices) {
        for (RscmServiceTableRow row : this.rscmServiceTableModel.getRows()) {
            Element addCalculatedService = XMLUtils.createElement((Element)currentServices, (String)"addCalculatedService");
            addCalculatedService.setAttribute("id", row.getServiceId());
            addCalculatedService.setAttribute("amount", row.getAmount());
            addCalculatedService.setAttribute("comment", row.getComment());
        }
    }

    public void setData(Element element) {
        try {
            if (this.serviceitems == null) {
                this.serviceitems = ((RSCMService)((ClientContext)this.getContext()).getPort(RSCMService.class)).getRSCMContractServiceList(false).stream().map(IdTitle::toIdTitle).toList();
            }
            ArrayList<RscmServiceTableRow> rows = new ArrayList<RscmServiceTableRow>();
            Element currentServices = XMLUtils.selectElement((Node)element, (String)("data/modules/rscm[@mid=" + ((ClientContext)this.getContext()).getModuleId() + "]/currentServices"));
            if (currentServices != null) {
                NodeList nodes = currentServices.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node n = nodes.item(i);
                    if (!"addCalculatedService".equals(n.getNodeName())) continue;
                    Element addCalculatedService = (Element)n;
                    String serviceId = addCalculatedService.getAttribute("id");
                    RscmServiceTableRow row = new RscmServiceTableRow().setServiceId(serviceId).setServiceTitle(this.serviceitems.stream().filter(a -> String.valueOf(a.getId()).equals(serviceId)).findFirst().map(a -> a.getGuiTitle()).orElse("#" + serviceId)).setAmount(addCalculatedService.getAttribute("amount")).setComment(addCalculatedService.getAttribute("comment"));
                    for (int j = 0; j < this.serviceitems.size(); ++j) {
                        IdTitle item = this.serviceitems.get(j);
                        if (row.getServiceId().equals(String.valueOf(item.getId()))) break;
                    }
                    rows.add(row);
                }
            } else {
                currentServices = element.getOwnerDocument().createElement("currentServices");
                element.appendChild(currentServices);
            }
            this.rscmServiceTableModel.setData(rows);
            this.rscmServiceTableModel.fireTableDataChanged();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void startEdit(RscmServiceTableRow row) {
        new ServiceEditorDialog("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443", row).open();
    }

    class RscmServiceTableModel
    extends BGTableModel<RscmServiceTableRow> {
        public RscmServiceTableModel() {
            super(RscmServiceTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 250, 250, -1, "serviceTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 100, 100, 100, "amount", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public static class RscmServiceTableRow {
        private String serviceId;
        private String serviceTitle;
        private String amount;
        private String comment;

        public String getComment() {
            return this.comment;
        }

        public RscmServiceTableRow setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public String getAmount() {
            return this.amount;
        }

        public RscmServiceTableRow setAmount(String amount) {
            this.amount = amount;
            return this;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public RscmServiceTableRow setServiceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public String getServiceTitle() {
            return this.serviceTitle;
        }

        public RscmServiceTableRow setServiceTitle(String serviceTitle) {
            this.serviceTitle = serviceTitle;
            return this;
        }
    }

    class ServiceEditorDialog
    extends BGEditorDialog<RscmServiceTableRow> {
        private JTextArea comment;
        private BGIntTextField amount;
        private BGUComboBox<IdTitle> service;

        public ServiceEditorDialog(String title, RscmServiceTableRow data) {
            super(title, (Object)data);
            this.comment = new JTextArea();
            this.amount = new BGIntTextField();
            this.service = new BGUComboBox();
        }

        public void doDialogPanel() {
            this.amount.setColumns(10);
            this.amount.setMinimumSize(new Dimension(100, 24));
            this.amount.setPreferredSize(new Dimension(100, 24));
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.comment.setRows(5);
            this.panel.setLayout(new GridBagLayout());
            this.panel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
            this.panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
            this.panel.add((Component)this.service, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043b-\u0432\u043e"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
            this.panel.add((Component)this.amount, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 2, 6, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
            int id = 0;
            String amountText = "";
            String commentText = "";
            if (this.data != null) {
                id = Utils.parseInt((String)((RscmServiceTableRow)this.data).getServiceId());
                amountText = ((RscmServiceTableRow)this.data).getAmount();
                commentText = ((RscmServiceTableRow)this.data).getComment();
            }
            this.amount.setText(amountText);
            this.comment.setText(commentText);
            try {
                int serviceId = id;
                this.service.setData(((RSCMService)((ClientContext)SPP_PatternServices.this.getContext()).getPort(RSCMService.class)).getRSCMContractServiceList(false).stream().map(IdTitle::toIdTitle).toList());
                this.service.setSelectedItem(this.service.getData().stream().filter(a -> a.getId() == serviceId).findFirst().orElse(null));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public boolean doApply() throws Exception {
            if (Utils.isEmptyString((String)this.amount.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e!");
                return false;
            }
            IdTitle selected = (IdTitle)this.service.getSelectedItem();
            String id = String.valueOf(selected.getId());
            String name = selected.getGuiTitle();
            String curAmount = this.amount.getText();
            String curComment = this.comment.getText();
            if (this.data != null) {
                ((RscmServiceTableRow)this.data).setServiceId(id);
                ((RscmServiceTableRow)this.data).setServiceTitle(name);
                ((RscmServiceTableRow)this.data).setAmount(curAmount);
                ((RscmServiceTableRow)this.data).setComment(curComment);
            } else {
                SPP_PatternServices.this.rscmServiceTableModel.getRows().add(new RscmServiceTableRow().setServiceId(id).setServiceTitle(name).setAmount(curAmount).setComment(curComment));
            }
            SPP_PatternServices.this.rscmServiceTableModel.fireTableDataChanged();
            return super.doApply();
        }
    }
}

