/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.modules.dialup;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelHours;
import ru.bitel.bgbilling.client.common.BGControlPanelMonthAndDays;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.reports.client.ReportParams;
import ru.bitel.common.XMLUtils;

public class ReportParams_Traffic
extends ReportParams {
    private BGControlPanelMonthAndDays periodPanel = new BGControlPanelMonthAndDays();
    private BGControlPanelHours hoursPanel = new BGControlPanelHours();
    private BGControlPanelListSelect groupsPanel = new BGControlPanelListSelect();
    private BGControlPanelListSelect servicePanel = new BGControlPanelListSelect();
    private JRadioButton mbRB = new JRadioButton("MB");
    private JRadioButton hourRB = new JRadioButton("\u0447\u0430\u0441\u044b");

    public ReportParams_Traffic() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.periodPanel.setDate(LocalDate.now());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        this.mbRB.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mbRB);
        buttonGroup.add(this.hourRB);
        JPanel modePanel = new JPanel();
        modePanel.add(new JLabel("\u0412\u044b\u0432\u0435\u0441\u0442\u0438 \u0432: "));
        modePanel.add(this.mbRB);
        modePanel.add(this.hourRB);
        jTabbedPane1.add((Component)this.servicePanel, "\u0423\u0441\u043b\u0443\u0433\u0438");
        this.add(modePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.periodPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.hoursPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jTabbedPane1, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jTabbedPane1.add((Component)this.groupsPanel, "\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        this.servicePanel.setBorder((Border)new BGTitleBorder(" \u0423\u0441\u043b\u0443\u0433\u0438"));
        this.groupsPanel.setBorder((Border)new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b "));
        this.periodPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        this.servicePanel.setMinimumSize(new Dimension(100, 100));
        this.servicePanel.setPreferredSize(new Dimension(100, 150));
    }

    public void setData() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ListGroups");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList((JList)this.groupsPanel.getList(), (DefaultListModel)this.groupsPanel.getListModel(), (Node)XMLUtils.getNode((Document)doc, (String)"groups"));
        }
        request.setModule("service");
        request.setAction("GetServiceList");
        request.setAttribute("mid", this.reportMid);
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList((JList)this.servicePanel.getList(), (DefaultListModel)this.servicePanel.getListModel(), (Node)XMLUtils.getNode((Document)doc, (String)"services"));
        }
    }

    @Override
    protected void putReportParams(Map<String, Object> _reportParams) {
        _reportParams.put("gr", this.groupsPanel.getListValues());
        _reportParams.put("date1", this.periodPanel.getDateString1());
        _reportParams.put("date2", this.periodPanel.getDateString2());
        _reportParams.put("hour1", this.hoursPanel.getHour1());
        _reportParams.put("hour2", this.hoursPanel.getHour2());
        _reportParams.put("sids", this.servicePanel.getListValues());
        _reportParams.put("mode", this.mbRB.isSelected() ? "1" : "2");
    }
}

