/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.Ranger;

public class RangeSet2<R, C> {
    private final Comparator<Entry> entryComaprator;
    private final Ranger<R, C> ranger;
    private final Comparator<C> comparator;
    private final Class<R> rangeClazz;
    private final Class<C> clazz;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile Data data;
    private final ConcurrentMap<R, R> rangeSet;
    protected static final Comparator<byte[]> COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return IpAddress.compare(o1, o2);
        }
    };

    protected RangeSet2(Ranger<R, C> ranger, final Comparator<C> comparator, Class<R> rangeClazz, Class<C> clazz, Set<R> rangeSet) {
        this.ranger = ranger;
        this.comparator = comparator;
        this.rangeClazz = rangeClazz;
        this.clazz = clazz;
        this.entryComaprator = new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return comparator.compare(o1.c, o2.c);
            }
        };
        this.rangeSet = new ConcurrentHashMap<R, R>(Math.min(rangeSet.size(), 64));
        for (R range : rangeSet) {
            this.rangeSet.put(range, range);
        }
        this.data = this.createData(this.rangeSet);
    }

    public RangeSet2(Ranger<R, C> ranger, Comparator<C> comparator, Class<R> rangeClazz, Class<C> clazz) {
        this(ranger, comparator, rangeClazz, clazz, Collections.emptySet());
    }

    public int size() {
        return this.data.ranges.length;
    }

    private Data createData(Map<R, R> rangeSet) {
        Entry e;
        int size = rangeSet.size();
        ArrayList<Entry> minEntry = new ArrayList<Entry>(size);
        ArrayList<Entry> maxEntry = new ArrayList<Entry>(size);
        Object[] ranges = (Object[])Array.newInstance(this.rangeClazz, size);
        int i = 0;
        for (R r : rangeSet.keySet()) {
            ranges[i] = r;
            minEntry.add(new Entry(this, i, this.ranger.getMinValue(r)));
            maxEntry.add(new Entry(this, i, this.ranger.getMaxValue(r)));
            ++i;
        }
        Collections.sort(minEntry, this.entryComaprator);
        Collections.sort(maxEntry, this.entryComaprator);
        ArrayList min = new ArrayList(size);
        int[] minIndex = new int[size];
        ArrayList max = new ArrayList(size);
        int[] maxIndex = new int[size];
        for (i = 0; i < size; ++i) {
            e = (Entry)minEntry.get(i);
            min.add(e.c);
            minIndex[i] = e.index;
        }
        for (i = 0; i < size; ++i) {
            e = (Entry)maxEntry.get(i);
            max.add(e.c);
            maxIndex[i] = e.index;
        }
        Object[] maxArray = max.toArray((Object[])Array.newInstance(this.clazz, size));
        Object[] minArray = min.toArray((Object[])Array.newInstance(this.clazz, size));
        return new Data(this, this.ranger, this.comparator, this.rangeClazz, this.clazz, ranges, minArray, minIndex, maxArray, maxIndex);
    }

    private Data addToData(Data entity, R range) {
        int minPos = Arrays.binarySearch(entity.min, this.ranger.getMinValue(range), this.comparator);
        int maxPos = Arrays.binarySearch(entity.max, this.ranger.getMaxValue(range), this.comparator);
        if (minPos < 0) {
            minPos = -minPos - 1;
        }
        if (maxPos < 0) {
            maxPos = -maxPos - 1;
        }
        Object[] min = (Object[])Array.newInstance(this.clazz, entity.min.length + 1);
        System.arraycopy(entity.min, 0, min, 0, minPos);
        min[minPos] = this.ranger.getMinValue(range);
        System.arraycopy(entity.min, minPos, min, minPos + 1, entity.min.length - minPos);
        int[] minIndex = new int[entity.minIndex.length + 1];
        System.arraycopy(entity.minIndex, 0, minIndex, 0, minPos);
        minIndex[minPos] = entity.ranges.length;
        System.arraycopy(entity.minIndex, minPos, minIndex, minPos + 1, entity.minIndex.length - minPos);
        Object[] max = (Object[])Array.newInstance(this.clazz, entity.max.length + 1);
        System.arraycopy(entity.max, 0, max, 0, maxPos);
        max[maxPos] = this.ranger.getMaxValue(range);
        System.arraycopy(entity.max, maxPos, max, maxPos + 1, entity.max.length - maxPos);
        int[] maxIndex = new int[entity.maxIndex.length + 1];
        System.arraycopy(entity.maxIndex, 0, maxIndex, 0, maxPos);
        maxIndex[maxPos] = entity.ranges.length;
        System.arraycopy(entity.maxIndex, maxPos, maxIndex, maxPos + 1, entity.maxIndex.length - maxPos);
        R[] ranges = Arrays.copyOf(entity.ranges, entity.ranges.length + 1);
        ranges[entity.ranges.length] = range;
        return new Data(this, this.ranger, this.comparator, this.rangeClazz, this.clazz, ranges, min, minIndex, max, maxIndex);
    }

    private Data removeFromData(Data entity, R range) {
        int minPos = Arrays.binarySearch(entity.min, this.ranger.getMinValue(range), this.comparator);
        int maxPos = Arrays.binarySearch(entity.max, this.ranger.getMaxValue(range), this.comparator);
        if (minPos < 0) {
            minPos = -minPos - 1;
        }
        Object c = entity.min[minPos];
        int size = entity.min.length - 1;
        while (minPos < size && this.comparator.compare(entity.min[minPos + 1], c) == 0) {
            ++minPos;
        }
        if (maxPos < 0) {
            maxPos = -maxPos - 1;
        }
        c = entity.max[maxPos];
        while (maxPos > 0 && this.comparator.compare(entity.max[maxPos - 1], c) == 0) {
            --maxPos;
        }
        Object r = null;
        block2: for (int i = minPos; i >= 0 && this.comparator.compare(this.ranger.getMinValue(r = (Object)entity.ranges[entity.minIndex[i]]), this.ranger.getMinValue(range)) >= 0; --i) {
            int size2 = entity.maxIndex.length;
            for (int j = maxPos; j < size2; ++j) {
                Object r2 = entity.ranges[entity.maxIndex[j]];
                if (this.comparator.compare(this.ranger.getMaxValue(r), this.ranger.getMaxValue(range)) > 0) continue block2;
                if (r != r2 || r != range) continue;
                minPos = i;
                maxPos = j;
                Object[] min = (Object[])Array.newInstance(this.clazz, entity.min.length - 1);
                System.arraycopy(entity.min, 0, min, 0, minPos);
                System.arraycopy(entity.min, minPos + 1, min, minPos, entity.min.length - minPos - 1);
                int[] minIndex = new int[entity.minIndex.length - 1];
                System.arraycopy(entity.minIndex, 0, minIndex, 0, minPos);
                System.arraycopy(entity.minIndex, minPos + 1, minIndex, minPos, entity.minIndex.length - minPos - 1);
                int iiSize = minIndex.length;
                int pos = entity.minIndex[minPos];
                for (int ii = 0; ii < iiSize; ++ii) {
                    if (minIndex[ii] <= pos) continue;
                    int n = ii;
                    minIndex[n] = minIndex[n] - 1;
                }
                Object[] max = (Object[])Array.newInstance(this.clazz, entity.max.length - 1);
                System.arraycopy(entity.max, 0, max, 0, maxPos);
                System.arraycopy(entity.max, maxPos + 1, max, maxPos, entity.max.length - maxPos - 1);
                int[] maxIndex = new int[entity.maxIndex.length - 1];
                System.arraycopy(entity.maxIndex, 0, maxIndex, 0, maxPos);
                System.arraycopy(entity.maxIndex, maxPos + 1, maxIndex, maxPos, entity.maxIndex.length - maxPos - 1);
                int iiSize2 = maxIndex.length;
                int pos2 = entity.maxIndex[maxPos];
                for (int ii = 0; ii < iiSize2; ++ii) {
                    if (maxIndex[ii] <= pos2) continue;
                    int n = ii;
                    maxIndex[n] = maxIndex[n] - 1;
                }
                Object[] ranges = (Object[])Array.newInstance(this.rangeClazz, entity.ranges.length - 1);
                System.arraycopy(entity.ranges, 0, ranges, 0, entity.minIndex[minPos]);
                System.arraycopy(entity.ranges, entity.minIndex[minPos] + 1, ranges, entity.minIndex[minPos], entity.ranges.length - entity.minIndex[minPos] - 1);
                return new Data(this, this.ranger, this.comparator, this.rangeClazz, this.clazz, ranges, min, minIndex, max, maxIndex);
            }
        }
        return entity;
    }

    public void add(R range) {
        this.lock.lock();
        try {
            if (this.rangeSet.putIfAbsent(range, range) == null) {
                this.data = this.addToData(this.data, range);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Set<R> ranges) {
        this.lock.lock();
        try {
            boolean changed = false;
            for (R range : ranges) {
                if (this.rangeSet.put(range, range) != null) continue;
                changed = true;
            }
            if (changed) {
                this.data = this.createData(this.rangeSet);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Set<R> ranges) {
        this.lock.lock();
        try {
            this.rangeSet.clear();
            for (R range : ranges) {
                this.rangeSet.put(range, range);
            }
            this.data = this.createData(this.rangeSet);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(R range) {
        this.lock.lock();
        try {
            if (this.rangeSet.remove(range) != null) {
                this.data = this.removeFromData(this.data, range);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Set<R> ranges) {
        this.lock.lock();
        try {
            ranges = new HashSet<R>(ranges);
            ranges.retainAll(this.rangeSet.keySet());
            if (this.rangeSet.keySet().removeAll(ranges)) {
                if (ranges.size() >= 50) {
                    this.data = this.createData(this.rangeSet);
                } else {
                    Data data = this.data;
                    for (R range : ranges) {
                        data = this.removeFromData(data, range);
                    }
                    this.data = data;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<R> listContains(C key) {
        return this.data.listContains(key);
    }

    public R get(C key, Matcher<R> matcher) {
        return this.data.get(key, matcher);
    }

    public R get(C key) {
        return this.data.get(key);
    }

    public R search(C key) {
        return this.data.get(key);
    }

    public Iterator<R> iterator() {
        return new Iter(this, this.data);
    }

    public static void main2(String[] args) {
        Comparator<Long> comparator = new Comparator<Long>(){

            @Override
            public final int compare(Long o1, Long o2) {
                return o1.compareTo(o2);
            }
        };
        HashSet<RangeLong> list = new HashSet<RangeLong>();
        HashSet<Long> set = new HashSet<Long>();
        Random rand = new Random();
        for (int i = 0; i < 100000; ++i) {
            long l = rand.nextInt(99999);
            int k = rand.nextInt(3);
            set.add(l);
            for (int j = 0; j <= k; ++j) {
                set.add(l + (long)j);
            }
            RangeLong r = new RangeLong(l, l + (long)k);
            list.add(r);
        }
        RangeSet2<RangeLong, Long> rangeList = new RangeSet2<RangeLong, Long>(new Ranger<RangeLong, Long>(){

            @Override
            public Long getMaxValue(RangeLong r) {
                return r.maxValue;
            }

            @Override
            public Long getMinValue(RangeLong r) {
                return r.minValue;
            }
        }, comparator, RangeLong.class, Long.class, list);
        System.out.println(123);
        System.out.println(123);
        int found = 0;
        for (int i = 0; i < 5000000; ++i) {
            long l = rand.nextInt(99999);
            RangeLong r = rangeList.search(l);
            if (r != null) {
                if (r.minValue <= l && r.maxValue >= l) {
                    ++found;
                } else {
                    System.out.println(r);
                    System.out.println(l);
                    throw new IllegalArgumentException();
                }
                if (set.contains(l)) continue;
                System.out.println(r);
                System.out.println(l);
                throw new IllegalArgumentException();
            }
            if (!set.contains(l)) continue;
            System.out.println(r);
            System.out.println(l);
            throw new IllegalArgumentException();
        }
        System.out.println(found);
    }

    public static void main3(String[] args) {
        Ranger<RangeLong, Long> ranger = new Ranger<RangeLong, Long>(){

            @Override
            public Long getMaxValue(RangeLong r) {
                return r.maxValue;
            }

            @Override
            public Long getMinValue(RangeLong r) {
                return r.minValue;
            }
        };
        Comparator<Long> comparator = new Comparator<Long>(){

            @Override
            public final int compare(Long o1, Long o2) {
                return o1.compareTo(o2);
            }
        };
        RangeSet2<RangeLong, Long> rangeSet = new RangeSet2<RangeLong, Long>(ranger, comparator, RangeLong.class, Long.class);
        rangeSet.add(new RangeLong(1L, 10L));
        rangeSet.add(new RangeLong(5L, 10L));
        rangeSet.add(new RangeLong(100L, 120L));
        rangeSet.add(new RangeLong(1000L, 1001L));
        rangeSet.add(new RangeLong(7L, 8L));
        rangeSet.add(new RangeLong(1L, 8L));
        rangeSet.add(new RangeLong(6L, 100L));
        rangeSet.add(new RangeLong(1000L, 1001L));
        System.out.println(rangeSet.listContains(8L));
    }

    public static void main(String[] args) throws UnknownHostException {
        Ranger<IpRange, byte[]> ranger = new Ranger<IpRange, byte[]>(){

            @Override
            public byte[] getMaxValue(IpRange r) {
                return r.getAddressFrom();
            }

            @Override
            public byte[] getMinValue(IpRange r) {
                return r.getAddressTo();
            }
        };
        RangeSet2<IpRange, byte[]> rangeSet = new RangeSet2<IpRange, byte[]>(ranger, COMPARATOR, IpRange.class, byte[].class);
        byte[] address = InetAddress.getByName("192.168.2.138").getAddress();
        rangeSet.add(new IpRange(address, address));
        address = InetAddress.getByName("192.168.2.148").getAddress();
        rangeSet.add(new IpRange(address, address));
        address = InetAddress.getByName("192.168.2.167").getAddress();
        rangeSet.add(new IpRange(address, address));
        address = InetAddress.getByName("192.168.2.169").getAddress();
        rangeSet.add(new IpRange(address, address));
        address = InetAddress.getByName("192.168.2.144").getAddress();
        rangeSet.add(new IpRange(address, address));
        address = InetAddress.getByName("192.168.2.144").getAddress();
        rangeSet.add(new IpRange(address, address));
        address = InetAddress.getByName("192.168.2.111").getAddress();
        rangeSet.add(new IpRange(address, address));
        address = InetAddress.getByName("192.168.2.100").getAddress();
        rangeSet.add(new IpRange(address, address));
        address = InetAddress.getByName("192.168.2.123").getAddress();
        rangeSet.add(new IpRange(address, address));
        System.out.println(rangeSet.listContains(InetAddress.getByName("192.168.2.144").getAddress()));
    }

    class Data {
        final Ranger<R, C> ranger;
        final Comparator<C> comparator;
        final Class<R> rangeClazz;
        final Class<C> clazz;
        final R[] ranges;
        final C[] min;
        final int[] minIndex;
        final C[] max;
        final int[] maxIndex;

        Data(RangeSet2 this$0, Ranger<R, C> ranger, Comparator<C> comparator, Class<R> rangeClazz, Class<C> clazz, R[] ranges, C[] min, int[] minIndex, C[] max, int[] maxIndex) {
            this.ranger = ranger;
            this.comparator = comparator;
            this.rangeClazz = rangeClazz;
            this.clazz = clazz;
            this.ranges = ranges;
            this.min = min;
            this.minIndex = minIndex;
            this.max = max;
            this.maxIndex = maxIndex;
        }

        public R get(C key, Matcher<R> matcher) {
            int i;
            int min = Arrays.binarySearch(this.min, key, this.comparator);
            if (min < 0) {
                if (min == -1) {
                    return null;
                }
                min = -min - 2;
            } else {
                int i2 = min + 1;
                int size = this.max.length;
                while (i2 < size && this.comparator.compare(key, this.min[i2]) == 0) {
                    min = i2++;
                }
            }
            int max = Arrays.binarySearch(this.max, key, this.comparator);
            if (max < 0) {
                if ((max = -max - 1) == this.max.length) {
                    return null;
                }
            } else {
                i = max - 1;
                while (i >= 0 && this.comparator.compare(key, this.max[i]) == 0) {
                    max = i--;
                }
            }
            if (min < this.max.length - max) {
                for (i = min; i >= 0; --i) {
                    Object r = this.ranges[this.minIndex[i]];
                    if (this.comparator.compare(this.ranger.getMaxValue(r), key) < 0 || matcher != null && !matcher.matched(r)) continue;
                    assert (this.comparator.compare(this.ranger.getMinValue(r), key) <= 0);
                    return r;
                }
            } else {
                int size = this.max.length;
                for (i = max; i < size; ++i) {
                    Object r = this.ranges[this.maxIndex[i]];
                    if (this.comparator.compare(this.ranger.getMinValue(r), key) > 0 || matcher != null && !matcher.matched(r)) continue;
                    assert (this.comparator.compare(this.ranger.getMaxValue(r), key) >= 0);
                    return r;
                }
            }
            return null;
        }

        public R get(C key) {
            return this.get(key, null);
        }

        public List<R> listContains(C key) {
            int i;
            ArrayList result = new ArrayList();
            int min = Arrays.binarySearch(this.min, key, this.comparator);
            if (min < 0) {
                if (min == -1) {
                    return result;
                }
                min = -min - 2;
            } else {
                int i2 = min + 1;
                int size = this.max.length;
                while (i2 < size && this.comparator.compare(key, this.min[i2]) == 0) {
                    min = i2++;
                }
            }
            int max = Arrays.binarySearch(this.max, key, this.comparator);
            if (max < 0) {
                if ((max = -max - 1) == this.max.length) {
                    return result;
                }
            } else {
                i = max - 1;
                while (i >= 0 && this.comparator.compare(key, this.max[i]) == 0) {
                    max = i--;
                }
            }
            if (min < this.max.length - max) {
                for (i = min; i >= 0; --i) {
                    Object r = this.ranges[this.minIndex[i]];
                    if (this.comparator.compare(this.ranger.getMaxValue(r), key) < 0) continue;
                    result.add(r);
                }
            } else {
                int size = this.max.length;
                for (i = max; i < size; ++i) {
                    Object r = this.ranges[this.maxIndex[i]];
                    if (this.comparator.compare(this.ranger.getMinValue(r), key) > 0) continue;
                    result.add(r);
                }
            }
            return result;
        }
    }

    class Entry {
        final int index;
        final C c;

        public Entry(RangeSet2 this$0, int index, C c) {
            this.index = index;
            this.c = c;
        }
    }

    class Iter
    implements Iterator<R> {
        final Data data;
        int index = 0;

        Iter(RangeSet2 this$0, Data data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.data.minIndex.length;
        }

        @Override
        public R next() {
            return this.data.ranges[this.data.minIndex[this.index++]];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class RangeLong {
        private final Long minValue;
        private final Long maxValue;

        public RangeLong(long minValue, long maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public String toString() {
            return "[" + this.minValue + "-" + this.maxValue + "]";
        }
    }
}

