/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBoxKeySelectionManager;
import ru.bitel.common.client.LookAndFeelUtils;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.Idable;
import ru.bitel.common.util.Matcher;

public class BGUComboBox<I extends GuiTitlable>
extends JComboBox<I> {
    private static final JSeparator separatorUI = new JSeparator(0);
    private BGUComboBoxKeySelectionManager ksm = new BGUComboBoxKeySelectionManager();
    private Popup popup = null;
    private int columnWidth = 0;
    private int columns = 0;
    private boolean prefferedPopupWidthCalculated = false;
    private int prefferedPopupWidth = 0;
    private Matcher<I> currentCondition = null;
    private List<I> unfilteredData = null;
    public static final GuiTitlable SEPARATOR = new GuiTitlable(){

        @Override
        public String getGuiTitle() {
            return "-----";
        }
    };
    public static final KeyValue SEPARATOR2 = new KeyValue(){

        @Override
        public String getGuiTitle() {
            return "-----";
        }
    };
    private final GuiTitlable notFoundItem = new GuiTitlable(this){

        @Override
        public String getGuiTitle() {
            return "=== \u0421\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e ===";
        }
    };
    private I assignedEmptyValue = null;
    private final boolean asyncFix;
    private AtomicInteger eventsWorking = new AtomicInteger(0);

    public BGUComboBox() {
        this(true);
    }

    public BGUComboBox(boolean asyncFix) {
        super(new DefaultComboBoxModel());
        this.init();
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                BGUComboBox.this.showPatternPopup();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                BGUComboBox.this.hidePatternPopup();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                BGUComboBox.this.hidePatternPopup();
            }
        });
        this.asyncFix = asyncFix;
    }

    public <K extends Comparable<K>, V> BGUComboBox(Class<? extends KeyValue> clazz, Class<? extends K> keyClass, Class<? extends V> valueClass) {
        super(new DefaultComboBoxModel());
        this.init();
        this.asyncFix = true;
    }

    private void init() {
        this.setKeySelectionManager(this.ksm);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BGUComboBox.this.showPatternPopup();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BGUComboBox.this.hidePatternPopup();
            }
        });
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                BasicComboPopup popup = (BasicComboPopup)BGUComboBox.this.getUI().getAccessibleChild(BGUComboBox.this, 0);
                Component comp = popup.getComponent(0);
                if (comp instanceof JScrollPane) {
                    JScrollPane scrollpane = (JScrollPane)comp;
                    if (!BGUComboBox.this.prefferedPopupWidthCalculated) {
                        BGUComboBox.this.calcComboPopupWidth();
                    }
                    Dimension dim = scrollpane.getPreferredSize();
                    if (dim.width < BGUComboBox.this.prefferedPopupWidth) {
                        dim.width = BGUComboBox.this.prefferedPopupWidth;
                        scrollpane.setMaximumSize(dim);
                        scrollpane.setPreferredSize(dim);
                        scrollpane.setMinimumSize(dim);
                    }
                }
            }
        });
    }

    private void calcComboPopupWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        BasicComboPopup popup = (BasicComboPopup)this.getUI().getAccessibleChild(this, 0);
        if (popup == null) {
            return;
        }
        int size = (int)this.getPreferredSize().getWidth();
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object str = this.getItemAt(i);
            if (str == null || str.toString() == null || size >= fm.stringWidth(str.toString())) continue;
            size = fm.stringWidth(str.toString());
        }
        this.prefferedPopupWidth = size;
        this.prefferedPopupWidthCalculated = true;
    }

    private void showPatternPopup() {
        String s;
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        if ((s = this.ksm.getPattern()) != null) {
            Point p = this.getLocationOnScreen();
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(s);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.popup = popupFactory.getPopup(this, toolTip, p.x, p.y - toolTip.getPreferredSize().height);
            this.popup.show();
        }
    }

    private void hidePatternPopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public boolean selectWithKeyChar(char keyChar) {
        boolean result = true;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        this.ksm.selectionForKey(keyChar, this.getModel());
        this.showPatternPopup();
        Vector<GuiTitlable> data = new Vector<GuiTitlable>();
        String pattern = this.ksm.getPattern();
        if (pattern == null) {
            data = new Vector(this.unfilteredData == null ? new ArrayList() : this.unfilteredData);
            result = true;
        } else {
            if (this.unfilteredData != null) {
                for (GuiTitlable item : this.unfilteredData) {
                    if (!item.getGuiTitle().toLowerCase().contains(pattern.toLowerCase())) continue;
                    data.add(item);
                }
            }
            this.prefferedPopupWidthCalculated = false;
            if (data.isEmpty()) {
                data.add(this.notFoundItem);
            }
            result = true;
        }
        DefaultComboBoxModel<I> defaultComboBoxModel = new DefaultComboBoxModel<I>(data);
        this.setModel(defaultComboBoxModel);
        if (this.assignedEmptyValue != null) {
            defaultComboBoxModel.insertElementAt(this.assignedEmptyValue, 0);
        }
        if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
            this.showPopup();
        }
        return result;
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                this.hidePatternPopup();
                super.processKeyEvent(e);
                break;
            }
            case 27: {
                if (e.getID() == 401) {
                    this.ksm.selectionForKey('\u001b', this.dataModel);
                    this.selectWithKeyChar('\u001b');
                }
                super.processKeyEvent(e);
                break;
            }
            case 40: {
                if (this.ksm.getPattern() != null && e.getID() == 401) {
                    int index = this.ksm.findNext(this.dataModel, true);
                    if (index < 0) break;
                    this.setSelectedIndex(index);
                    break;
                }
                super.processKeyEvent(e);
                break;
            }
            case 38: {
                if (this.ksm.getPattern() != null && e.getID() == 401) {
                    int index = this.ksm.findNext(this.dataModel, false);
                    if (index < 0) break;
                    this.setSelectedIndex(index);
                    break;
                }
                super.processKeyEvent(e);
                break;
            }
            default: {
                super.processKeyEvent(e);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        separatorUI.updateUI();
        final ListCellRenderer oldRenderer = this.getRenderer();
        this.setRenderer(new ListCellRenderer<I>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends I> list, I value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = oldRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (BGUComboBox.this.assignedEmptyValue != null && value == null) {
                    ((JLabel)c).setText(BGUComboBox.this.assignedEmptyValue.getGuiTitle());
                }
                if (value == SEPARATOR || value == SEPARATOR2 || value != null && "-----".equals(value.toString())) {
                    return separatorUI;
                }
                if (value instanceof GuiTitlable && c instanceof JLabel) {
                    ((JLabel)c).setText(value.getGuiTitle());
                }
                return c;
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.columns != 0) {
            Insets insets = this.getInsets();
            size.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
        return size;
    }

    private int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    @Override
    public I getSelectedItem() {
        Object si = super.getSelectedItem();
        if (this.assignedEmptyValue == si) {
            return null;
        }
        if (this.notFoundItem == si) {
            return null;
        }
        return (I)((GuiTitlable)this.getItemAt(this.getSelectedIndex()));
    }

    public Optional<I> optSelectedItem() {
        return Optional.ofNullable(this.getSelectedItem());
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject == null) {
            super.setSelectedItem(anObject);
            return;
        }
        if (anObject == SEPARATOR || anObject == SEPARATOR2 || "-----".equals(anObject.toString()) || anObject instanceof Separator) {
            return;
        }
        if (anObject instanceof Idable) {
            int id = ((Idable)anObject).getId();
            int size = this.getItemCount();
            for (int i = 0; i < size; ++i) {
                Idable o = (Idable)this.getItemAt(i);
                if (o.getId() != id) continue;
                super.setSelectedItem(o);
                return;
            }
        } else if (anObject instanceof Integer) {
            int size = this.getItemCount();
            for (int i = 0; i < size; ++i) {
                Object o = this.getItemAt(i);
                if (o instanceof Idable) {
                    if (!anObject.equals(((Idable)o).getId())) continue;
                    super.setSelectedItem(o);
                    return;
                }
                if (o instanceof Integer) {
                    if (!o.equals(anObject)) continue;
                    super.setSelectedItem(o);
                    return;
                }
                if (o instanceof String) {
                    if (!o.equals(anObject.toString())) continue;
                    super.setSelectedItem(o);
                    return;
                }
                if (!(o instanceof KeyValue) || !((KeyValue)o).getKey().equals(anObject)) continue;
                super.setSelectedItem(o);
                return;
            }
        } else if (anObject instanceof KeyValue) {
            KeyValue keyValue = (KeyValue)anObject;
            int size = this.getItemCount();
            for (int i = 0; i < size; ++i) {
                Object o = this.getItemAt(i);
                if (keyValue.getKey() == null || !keyValue.getKey().equals(((KeyValue)o).getKey())) continue;
                super.setSelectedItem(o);
                return;
            }
        } else if (anObject instanceof String) {
            int size = this.getItemCount();
            for (int i = 0; i < size; ++i) {
                Object o = this.getItemAt(i);
                if (o instanceof Idable) {
                    if (Utils.parseInt((String)anObject) != ((Idable)o).getId()) continue;
                    super.setSelectedItem(o);
                    return;
                }
                if (o instanceof Integer) {
                    if (!anObject.equals(String.valueOf(o))) continue;
                    super.setSelectedItem(o);
                    return;
                }
                if (o instanceof String) {
                    if (!o.equals(anObject)) continue;
                    super.setSelectedItem(o);
                    return;
                }
                if (!(o instanceof KeyValue) || !((KeyValue)o).getKey().equals(anObject)) continue;
                super.setSelectedItem(o);
                return;
            }
        }
        super.setSelectedItem(anObject);
    }

    public void setData(List<I> items) {
        this.unfilteredData = items;
        this.ksm.resetPattern();
        Vector<Object> data = null;
        if (this.currentCondition != null) {
            data = new Vector();
            for (GuiTitlable item : items) {
                if (!this.currentCondition.matched(item)) continue;
                data.add(item);
            }
        } else {
            data = new Vector<I>(items);
        }
        DefaultComboBoxModel<I> defaultComboBoxModel = new DefaultComboBoxModel<I>(data);
        this.setModel(defaultComboBoxModel);
        if (this.assignedEmptyValue != null) {
            defaultComboBoxModel.insertElementAt(this.assignedEmptyValue, 0);
        }
        if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
        this.prefferedPopupWidthCalculated = false;
    }

    public List<I> getData() {
        return this.unfilteredData;
    }

    public void setContentFilter(Matcher<I> currentCondition) {
        this.currentCondition = currentCondition;
        this.refreshFilter();
    }

    public void refreshFilter() {
        if (this.unfilteredData != null) {
            this.setData(this.unfilteredData);
        }
    }

    @Override
    protected void fireActionEvent() {
        if (!this.asyncFix) {
            super.fireActionEvent();
            return;
        }
        if (this.eventsWorking.intValue() == 0) {
            Object[] listeners = this.listenerList.getListenerList();
            long mostRecentEventTime = EventQueue.getMostRecentEventTime();
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiers();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            final ActionEvent e = new ActionEvent(this, 1001, this.getActionCommand(), mostRecentEventTime, modifiers);
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                final ActionListener al = (ActionListener)listeners[i + 1];
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BGUComboBox.this.eventsWorking.incrementAndGet();
                        al.actionPerformed(e);
                        BGUComboBox.this.eventsWorking.decrementAndGet();
                    }
                });
            }
        }
    }

    public void assignEmptyValue(I titleEmptyValue) {
        if (this.assignedEmptyValue == null) {
            this.assignedEmptyValue = titleEmptyValue;
            ((DefaultComboBoxModel)this.getModel()).insertElementAt(this.assignedEmptyValue, 0);
        }
    }

    public static class Separator
    extends KeyValue {
        public Separator(String title) {
            this.setValue(title);
        }
    }
}

