/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLink;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLinkRule;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;
import ru.bitel.common.inet.IpAddress;

public class TrafficTypeLinkDao
extends AbstractDirectoryIdDao<TrafficTypeLink> {
    private final String linkTableName;
    private PreparedStatement getLinksPS;

    public TrafficTypeLinkDao(Connection con, int mid) {
        super(con, mid, "inet_traffic_type_link");
        this.linkTableName = "inet_traffic_type_link_rule_" + mid;
    }

    protected TrafficTypeLink getFromRS(ResultSet rs) throws SQLException, BGException {
        TrafficTypeLink result = new TrafficTypeLink();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        if (this.getLinksPS == null) {
            this.getLinksPS = this.con.prepareStatement("SELECT rule.* FROM " + this.linkTableName + " as rule WHERE rule.linkId=? ORDER BY position");
        }
        this.getLinksPS.setInt(1, result.getId());
        ArrayList<TrafficTypeLinkRule> links = new ArrayList<TrafficTypeLinkRule>();
        ResultSet getLinksRS = this.getLinksPS.executeQuery();
        while (getLinksRS.next()) {
            TrafficTypeLinkRule link;
            java.sql.Date dateFrom = getLinksRS.getDate("dateFrom");
            java.sql.Date dateTo = getLinksRS.getDate("dateTo");
            int type = getLinksRS.getInt("type");
            int trafficTypeId = getLinksRS.getInt("trafficTypeId");
            String comment = getLinksRS.getString("comment");
            if (type == 2) {
                int sourceId = getLinksRS.getInt("sourceId");
                int interfaceId = getLinksRS.getInt("interfaceId");
                int direction = getLinksRS.getInt("direction");
                byte[] addressFromBytes = getLinksRS.getBytes("addressFrom");
                byte[] addressToBytes = getLinksRS.getBytes("addressTo");
                int portFrom = getLinksRS.getInt("portFrom");
                int portTo = getLinksRS.getInt("portTo");
                String diffServ = getLinksRS.getString("diffServ");
                IpAddress addressFrom = addressFromBytes == null || addressFromBytes.length == 0 ? null : new IpAddress(addressFromBytes);
                IpAddress addressTo = addressToBytes == null || addressToBytes.length == 0 ? null : new IpAddress(addressToBytes);
                link = new TrafficTypeLinkRule((Date)dateFrom, (Date)dateTo, sourceId, interfaceId, direction, addressFrom, addressTo, portFrom, portTo, diffServ, trafficTypeId, comment);
            } else {
                String counterRealm = getLinksRS.getString("counterRealm");
                String counterService = getLinksRS.getString("counterService");
                int counterVendor = getLinksRS.getInt("counterVendor");
                int counterType = getLinksRS.getInt("counterType");
                String counterPrefix = getLinksRS.getString("counterPrefix");
                link = new TrafficTypeLinkRule((Date)dateFrom, (Date)dateTo, counterRealm, counterService, counterVendor, counterType, counterPrefix, trafficTypeId, comment);
            }
            link.setId(getLinksRS.getInt("id"));
            links.add(link);
        }
        getLinksRS.close();
        result.setTrafficTypeLinkRuleList(links);
        return result;
    }

    protected void updateImpl(TrafficTypeLink b) throws BGException, SQLException {
        PreparedStatement ps;
        if (Utils.isBlankString((String)b.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title) VALUES (?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=? WHERE id=?");
            ps.setInt(2, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        } else {
            PreparedStatement deleteLinkPS = this.con.prepareStatement("DELETE FROM " + this.linkTableName + " WHERE linkId=?");
            deleteLinkPS.setInt(1, b.getId());
            deleteLinkPS.executeUpdate();
            deleteLinkPS.close();
        }
        ps.close();
        ps = this.con.prepareStatement("INSERT INTO " + this.linkTableName + " (linkId, position, dateFrom, dateTo, type,  sourceId, interfaceId, direction, addressFrom, addressTo, portFrom, portTo, diffServ, counterRealm, counterService, counterVendor, counterType, counterPrefix, trafficTypeId, comment) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        ps.setInt(1, b.getId());
        int position = 1;
        if (b.getTrafficTypeLinkRuleList() != null) {
            for (TrafficTypeLinkRule link : b.getTrafficTypeLinkRuleList()) {
                ps.setInt(2, position++);
                ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)link.dateFrom));
                ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)link.dateTo));
                ps.setInt(5, link.type);
                ps.setInt(6, link.sourceId);
                ps.setInt(7, link.interfaceId);
                ps.setInt(8, link.direction);
                ps.setBytes(9, link.addressFrom != null ? link.addressFrom.address : null);
                ps.setBytes(10, link.addressTo != null ? link.addressTo.address : null);
                ps.setInt(11, link.portFrom);
                ps.setInt(12, link.portTo);
                ps.setString(13, link.diffServString);
                ps.setString(14, Utils.maskNull((String)link.counterRealm));
                ps.setString(15, Utils.maskNull((String)link.counterService));
                ps.setInt(16, link.counterVendor);
                ps.setInt(17, link.counterType);
                ps.setString(18, link.counterPrefix);
                ps.setInt(19, link.trafficTypeId);
                ps.setString(20, link.getComment());
                ps.executeUpdate();
            }
        }
        ps.close();
    }

    public List<TrafficTypeLink> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    protected int deleteImpl(int id) throws SQLException {
        String query = "DELETE FROM e, elink USING " + this.tableName + " as e LEFT JOIN " + this.linkTableName + " as elink ON elink.linkId=e.id WHERE e.id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            int n = ps.executeUpdate();
            return n;
        }
    }

    public TrafficTypeLink get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }
}

