/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess;

import java.util.Date;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgent;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceSelector;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.AbstractNetflowLogParser;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntimeMap;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.inet.IpAddress;

class NetflowLogParser
extends AbstractNetflowLogParser {
    private static final Logger logger = LogManager.getLogger();
    private FlowAgent flowAgent;
    protected final InetDeviceRuntimeMap deviceMap;

    public NetflowLogParser(Setup setup, int deviceId, int moduleId, Accounting accounting) throws BGException {
        super(setup, deviceId, moduleId);
        this.deviceMap = accounting.deviceMap;
        HashSet<Integer> devices = new HashSet<Integer>();
        devices.add(this.deviceId);
        FlowAgentInterfaceSelector ifaceSelector = new FlowAgentInterfaceSelector(accounting, devices, 1, 2, 5, 3, 4);
        this.flowAgent = ifaceSelector.getAgentIdMap().get(this.deviceId);
    }

    @Override
    protected void processFlow(Data record, IpAddress srcAddress, IpAddress dstAddress, int direction, int port, int inputIface, int outputIface, int zoneDelta, Date hour) throws BGException {
        if (record.milliseconds == 0L) {
            return;
        }
        long millis = record.milliseconds + (long)zoneDelta;
        FlowAgentInterface iface = this.flowAgent.getInterface(hour.getTime(), millis, inputIface);
        if (iface == null || !iface.processFlow(record, hour.getTime(), millis, srcAddress, direction, outputIface, dstAddress, port, record.diffServ, record.octets, false)) {
            if (logger.isTraceEnabled()) {
                if (iface == null) {
                    logger.trace("Not found iface = " + inputIface);
                } else {
                    logger.trace("Session not found on iface = " + inputIface);
                }
            }
            if (this.flowAgent.defaultIface != null) {
                if (!this.flowAgent.defaultIface.processFlow(record, hour.getTime(), millis, srcAddress, direction, outputIface, dstAddress, port, record.diffServ, record.octets, false)) {
                    logger.trace("Session not found on default iface");
                }
            } else {
                logger.trace("Default iface not found");
            }
        }
    }
}

