/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamAddressValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamDateValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamFlagValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamTextValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParameterHistoryEntry;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ParamValueManager {
    private static volatile HashMap<Integer, Boolean> PARAMETERS_HISTORY = new HashMap();
    private Connection con;
    private static final String PARAM_PREF = "object_param";
    private static final String TEXT_VALUE_TABLE = "object_param_value_text";
    private static final String DATE_VALUE_TABLE = "object_param_value_date";
    private static final String LIST_VALUE_TABLE = "object_param_value_list";
    private static final String ADDRESS_VALUE_TABLE = "object_param_value_address";
    private static final String FLAG_VALUE_TABLE = "object_param_value_flag";

    public ParamValueManager(Connection con) {
        this.con = con;
    }

    public void deleteActivityParamValues(int objectId) throws Exception {
        this.deleteValuesFromTable(objectId, TEXT_VALUE_TABLE);
        this.deleteValuesFromTable(objectId, DATE_VALUE_TABLE);
        this.deleteValuesFromTable(objectId, LIST_VALUE_TABLE);
        this.deleteValuesFromTable(objectId, ADDRESS_VALUE_TABLE);
        this.deleteValuesFromTable(objectId, FLAG_VALUE_TABLE);
    }

    public void copyObjectParams(int fromObject, int toObject) throws Exception {
        this.copyParams(TEXT_VALUE_TABLE, "param_id, value", fromObject, toObject);
        this.copyParams(DATE_VALUE_TABLE, "param_id, value", fromObject, toObject);
        this.copyParams(LIST_VALUE_TABLE, "param_id, value", fromObject, toObject);
        this.copyParams(ADDRESS_VALUE_TABLE, "param_id, hid, flat, room, pod, floor, address, comment", fromObject, toObject);
        this.copyParams(FLAG_VALUE_TABLE, "param_id, value", fromObject, toObject);
    }

    private void copyParams(String tableName, String columns, int fromObject, int toObject) throws Exception {
        String query = "INSERT INTO " + tableName + " (object_id, " + columns + ") SELECT ?, " + columns + " FROM " + tableName + " WHERE object_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, toObject);
            ps.setInt(2, fromObject);
            ps.executeUpdate();
        }
    }

    private void deleteValuesFromTable(int objectId, String tableName) throws SQLException {
        String query = "DELETE FROM " + tableName + " WHERE object_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, objectId);
            ps.executeUpdate();
        }
    }

    public ParamAddressValue getAddressParamValue(int objectId, int paramId) throws Exception {
        ParamAddressValue result = null;
        String query = "SELECT * FROM object_param_value_address WHERE object_id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getAddressParam(rs);
                }
            }
        }
        return result;
    }

    public void searchCustomAddressParams(SearchResult<String[]> searchResult, int paramId) throws Exception {
        Page page = searchResult.getPage();
        List<String[]> result = searchResult.getList();
        String query = "SELECT SQL_CALC_FOUND_ROWS address, a.comment, object_id, param_id, object.title FROM " + ADDRESS_VALUE_TABLE + " AS a LEFT JOIN object ON object.id=a.object_id WHERE param_id=" + paramId + " AND hid=0" + page.sqlLimit();
        try (Statement st = this.con.createStatement();){
            try (ResultSet rs = st.executeQuery(query);){
                while (rs.next()) {
                    int index = 0;
                    String[] value = new String[5];
                    value[index++] = rs.getString("object_id");
                    value[index++] = rs.getString("address");
                    value[index++] = rs.getString("a.comment");
                    value[index++] = rs.getString("param_id");
                    value[index++] = rs.getString("object.title");
                    result.add(value);
                }
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
    }

    public ParamListValue getListParamValue(int objectId, int paramId) throws Exception {
        ParamListValue result = null;
        String query = "SELECT * FROM object_param_value_list WHERE object_id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getListParam(rs);
                }
            }
        }
        return result;
    }

    public void updateParamValue(Object value, int userId) throws Exception {
        if (value instanceof EntityAttrText) {
            EntityAttrText attrText = (EntityAttrText)value;
            this.updateTextParam(attrText, userId);
        } else if (value instanceof EntityAttrAddress) {
            EntityAttrAddress attrAddress = (EntityAttrAddress)value;
            if (attrAddress.getHouseId() > -1) {
                this.updateAddressParam(attrAddress, userId);
            } else if (this.deleteParamValue((EntityAttr)attrAddress, ADDRESS_VALUE_TABLE) > 0) {
                this.updateAddressParamLog(attrAddress, userId);
            }
        } else if (value instanceof EntityAttrDate) {
            EntityAttrDate attrDate = (EntityAttrDate)value;
            this.updateDateParam(attrDate, userId);
        } else if (value instanceof EntityAttrList) {
            EntityAttrList attrList = (EntityAttrList)value;
            if (attrList.getValue() != 0) {
                this.updateListParam(attrList, userId);
            } else if (this.deleteParamValue((EntityAttr)attrList, LIST_VALUE_TABLE) > 0) {
                this.updateListParamLog(attrList, userId);
            }
        } else if (value instanceof EntityAttrBoolean) {
            EntityAttrBoolean attrBoolean = (EntityAttrBoolean)value;
            this.updateFlagParam(attrBoolean, userId);
        }
        try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.con, userId);){
            contractObjectDao.saveTitleByMacros((ContractObject)((Object)contractObjectDao.get(value instanceof ParamValue ? ((ParamValue)value).getObjectId() : ((EntityAttr)value).getEntityId())));
        }
    }

    private void updateTextParam(EntityAttrText value, int userId) throws Exception {
        int changeRows;
        int parameterId;
        block43: {
            Objects.requireNonNull(value);
            int objectId = value.getEntityId();
            parameterId = value.getEntitySpecAttrId();
            boolean update = false;
            String query = "SELECT count(*) FROM object_param_value_text WHERE object_id=? AND param_id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, objectId);
                ps.setInt(index++, parameterId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        update = rs.getInt(1) > 0;
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
            changeRows = 0;
            if (update) {
                if (Utils.notEmptyString(value.getValue())) {
                    query = "UPDATE object_param_value_text SET value=? WHERE object_id=? AND param_id=? AND NOT(value<=>?)";
                    try (PreparedStatement ps = this.con.prepareStatement(query);){
                        int index = 1;
                        ps.setString(index++, value.getValue());
                        ps.setInt(index++, objectId);
                        ps.setInt(index++, parameterId);
                        ps.setString(index++, value.getValue());
                        changeRows = ps.executeUpdate();
                        break block43;
                    }
                    catch (Exception ex) {
                        throw new BGException(ex);
                    }
                }
                query = "DELETE FROM object_param_value_text WHERE object_id=? AND param_id=?";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    int index = 1;
                    ps.setInt(index++, objectId);
                    ps.setInt(index++, parameterId);
                    changeRows = ps.executeUpdate();
                    break block43;
                }
                catch (Exception ex) {
                    throw new BGException(ex);
                }
            }
            query = "INSERT INTO object_param_value_text SET object_id=?, param_id=?, value=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, objectId);
                ps.setInt(index++, parameterId);
                ps.setString(index++, value.getValue());
                changeRows = ps.executeUpdate();
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
        }
        if (changeRows > 0 && this.checkParameterHistoryLogging(parameterId)) {
            this.updateTextParamLog(value, userId);
        }
    }

    private void updateFlagParam(EntityAttrBoolean value, int userId) throws BGException {
        Objects.requireNonNull(value);
        int objectId = value.getEntityId();
        int parameterId = value.getEntitySpecAttrId();
        try {
            boolean update = true;
            String query = "SELECT count(*) FROM object_param_value_flag WHERE object_id=? AND param_id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, objectId);
                ps.setInt(index++, parameterId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        update = rs.getInt(1) > 0;
                    }
                }
            }
            int changeRows = 0;
            if (update) {
                query = "UPDATE object_param_value_flag SET value=? WHERE object_id=? AND param_id=? AND NOT(value<=>?)";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    int index = 1;
                    ps.setBoolean(index++, value.getValue());
                    ps.setInt(index++, objectId);
                    ps.setInt(index++, parameterId);
                    ps.setBoolean(index++, value.getValue());
                    changeRows = ps.executeUpdate();
                }
            }
            query = "INSERT INTO object_param_value_flag SET object_id=?, param_id=?, value=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, objectId);
                ps.setInt(index++, parameterId);
                ps.setBoolean(index++, value.getValue());
                changeRows = ps.executeUpdate();
            }
            if (changeRows > 0 && this.checkParameterHistoryLogging(parameterId)) {
                this.updateFlagParamLog(value, userId);
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private void updateListParam(EntityAttrList value, int userId) throws Exception {
        int changeRows;
        block34: {
            Objects.requireNonNull(value);
            int objectId = value.getEntityId();
            int parameterId = value.getEntitySpecAttrId();
            boolean update = false;
            String query = "SELECT count(*) FROM object_param_value_list WHERE object_id=? AND param_id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, objectId);
                ps.setInt(index++, parameterId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        update = rs.getInt(1) > 0;
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
            changeRows = 0;
            if (update) {
                query = "UPDATE object_param_value_list SET value=? WHERE object_id=? AND param_id=? AND NOT(value<=>?)";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    int index = 1;
                    ps.setInt(index++, value.getValue());
                    ps.setInt(index++, objectId);
                    ps.setInt(index++, parameterId);
                    ps.setInt(index++, value.getValue());
                    changeRows = ps.executeUpdate();
                    break block34;
                }
                catch (Exception ex) {
                    throw new BGException(ex);
                }
            }
            query = "INSERT INTO object_param_value_list SET object_id=?, param_id=?, value=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, objectId);
                ps.setInt(index++, parameterId);
                ps.setInt(index++, value.getValue());
                changeRows = ps.executeUpdate();
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
        }
        if (changeRows > 0 && this.checkParameterHistoryLogging(value.getEntitySpecAttrId())) {
            this.updateListParamLog(value, userId);
        }
    }

    private void updateAddressParam(EntityAttrAddress value, int userId) throws BGException {
        Objects.requireNonNull(value);
        int objectId = value.getEntityId();
        int parameterId = value.getEntitySpecAttrId();
        try {
            PreparedStatement ps;
            boolean update = true;
            String query = "SELECT count(*) FROM object_param_value_address WHERE object_id=? AND param_id=?";
            try (PreparedStatement ps2 = this.con.prepareStatement(query);){
                ps2.setInt(1, objectId);
                ps2.setInt(2, parameterId);
                try (ResultSet rs = ps2.executeQuery();){
                    if (rs.next()) {
                        update = rs.getInt(1) > 0;
                    }
                }
            }
            int changeRows = 0;
            if (update) {
                query = "UPDATE object_param_value_address SET hid=?, flat=?, room=?, pod=?, floor=?, address=?, comment=?, format_key=? WHERE object_id=? AND param_id=? AND (hid!=? OR flat!=? OR room!=? OR pod!=? OR floor!=? OR address!=? OR comment!=? OR format_key!=?)";
                ps = this.con.prepareStatement(query);
                try {
                    int index = 1;
                    ps.setInt(1, value.getHouseId());
                    index = this.setAddressPs(value, ps, index);
                    ps.setInt(index++, objectId);
                    ps.setInt(index++, parameterId);
                    this.setAddressPs(value, ps, index);
                    changeRows = ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            query = "INSERT INTO object_param_value_address SET object_id=?, param_id=?, hid=?, flat=?, room=?, pod=?, floor=?, address=?, comment=?, format_key=?";
            ps = this.con.prepareStatement(query);
            try {
                int index = 1;
                ps.setInt(index++, objectId);
                ps.setInt(index++, parameterId);
                this.setAddressPs(value, ps, index);
                changeRows = ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            if (changeRows > 0 && this.checkParameterHistoryLogging(parameterId)) {
                this.updateAddressParamLog(value, userId);
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private int setAddressPs(EntityAttrAddress value, PreparedStatement ps, int index) throws SQLException {
        ps.setInt(index++, value.getHouseId());
        ps.setString(index++, value.getFlat());
        ps.setString(index++, value.getRoom());
        ps.setInt(index++, value.getPod());
        ps.setInt(index++, value.getFloor());
        ps.setString(index++, value.getTitle());
        ps.setString(index++, value.getComment());
        ps.setString(index++, value.getFormatKey());
        return index;
    }

    private void updateDateParam(EntityAttrDate value, int userId) throws Exception {
        Objects.requireNonNull(value);
        int objectId = value.getEntityId();
        int parameterId = value.getEntitySpecAttrId();
        boolean update = false;
        Object query = "SELECT count(*) FROM object_param_value_date WHERE object_id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            int index = 1;
            ps.setInt(index++, objectId);
            ps.setInt(index++, parameterId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    update = rs.getInt(1) > 0;
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        int changeRows = 0;
        query = (update ? "UPDATE " : "INSERT INTO ") + "object_param_value_date SET value=?" + (update ? " WHERE object_id=? AND param_id=? AND NOT(value<=>?)" : ", object_id=?, param_id=? ");
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(value.getValue()));
            ps.setInt(index++, objectId);
            ps.setInt(index++, parameterId);
            if (update) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(value.getValue()));
            }
            changeRows = ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        if (changeRows > 0 && this.checkParameterHistoryLogging(parameterId)) {
            this.updateDateParamLog(value, userId);
        }
    }

    private int deleteParamValue(EntityAttr value, String tableName) throws BGException {
        int res = 0;
        String query = "DELETE FROM " + tableName + " WHERE object_id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, value.getEntityId());
            ps.setInt(2, value.getEntitySpecAttrId());
            res = ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return res;
    }

    public Map<Integer, ParamValue> getObjectParamMap(int objectId) throws Exception {
        HashMap<Integer, ParamValue> result = new HashMap<Integer, ParamValue>();
        this.loadParams(result, objectId, TEXT_VALUE_TABLE);
        this.loadParams(result, objectId, ADDRESS_VALUE_TABLE);
        this.loadParams(result, objectId, DATE_VALUE_TABLE);
        this.loadParams(result, objectId, LIST_VALUE_TABLE);
        this.loadParams(result, objectId, FLAG_VALUE_TABLE);
        return result;
    }

    private void loadParams(Map<Integer, ParamValue> params, int objectId, String tableName) throws Exception {
        String query = "SELECT * FROM " + tableName + " WHERE object_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, objectId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ParamValue value = null;
                    if (tableName.equals(TEXT_VALUE_TABLE)) {
                        value = this.getTextParam(rs);
                    } else if (tableName.equals(ADDRESS_VALUE_TABLE)) {
                        value = this.getAddressParam(rs);
                    } else if (tableName.equals(DATE_VALUE_TABLE)) {
                        value = this.getDateParam(rs);
                    } else if (tableName.equals(LIST_VALUE_TABLE)) {
                        value = this.getListParam(rs);
                    } else if (tableName.equals(FLAG_VALUE_TABLE)) {
                        value = this.getFlagParam(rs);
                    }
                    params.put(value.getParamId(), value);
                }
            }
        }
    }

    private ParamTextValue getTextParam(ResultSet rs) throws SQLException {
        return (ParamTextValue)ParamTextValue.builder().setValue(rs.getString("value")).setObjectId(rs.getInt("object_id")).setParamId(rs.getInt("param_id")).build();
    }

    private ParamFlagValue getFlagParam(ResultSet rs) throws SQLException {
        return (ParamFlagValue)ParamFlagValue.builder().setValue(rs.getBoolean("value")).setObjectId(rs.getInt("object_id")).setParamId(rs.getInt("param_id")).build();
    }

    private ParamDateValue getDateParam(ResultSet rs) throws SQLException {
        return (ParamDateValue)ParamDateValue.builder().setValue(TimeUtils.convertDateToCalendar(rs.getDate("value"))).setObjectId(rs.getInt("object_id")).setParamId(rs.getInt("param_id")).build();
    }

    private ParamAddressValue getAddressParam(ResultSet rs) throws SQLException {
        ParamAddressValue value = new ParamAddressValue();
        value.setObjectId(rs.getInt("object_id"));
        value.setParamId(rs.getInt("param_id"));
        value.setHouseId(rs.getInt("hid"));
        value.setFlat(rs.getString("flat"));
        value.setRoom(rs.getString("room"));
        value.setPod(rs.getInt("pod"));
        value.setFloor(rs.getInt("floor"));
        value.setAddress(rs.getString("address"));
        value.setComment(rs.getString("comment"));
        value.setFormatKey(rs.getString("format_key"));
        return value;
    }

    private ParamListValue getListParam(ResultSet rs) throws SQLException {
        ParamListValue value = new ParamListValue();
        value.setObjectId(rs.getInt("object_id"));
        value.setParamId(rs.getInt("param_id"));
        value.setValue(rs.getInt("value"));
        return value;
    }

    public static void resetParametersHistoryMap() {
        PARAMETERS_HISTORY = new HashMap();
    }

    private boolean checkParameterHistoryLogging(int pid) throws Exception {
        boolean result = false;
        if (PARAMETERS_HISTORY.containsKey(pid)) {
            result = PARAMETERS_HISTORY.get(pid);
        } else {
            try (Statement st = this.con.createStatement();){
                HashMap<Integer, Boolean> historyMap = new HashMap<Integer, Boolean>();
                try (ResultSet rs = st.executeQuery("SELECT id, flags FROM object_param");){
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        boolean has = rs.getBoolean(2);
                        if (id == pid) {
                            result = has;
                        }
                        historyMap.put(id, has);
                    }
                }
                PARAMETERS_HISTORY.putAll(historyMap);
            }
        }
        return result;
    }

    private void updateTextParamLog(EntityAttrText value, int userId) throws BGException {
        String query = "INSERT INTO object_param_value_text_log SET object_id=?, param_id=?, value=?, dt_change=now(), user_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, value.getEntityId());
            ps.setInt(index++, value.getEntitySpecAttrId());
            ps.setString(index++, Utils.notEmptyString(value.getValue()) ? value.getValue() : "[\u0423\u0414\u0410\u041b\u0415\u041d\u041e]");
            ps.setInt(index++, userId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException();
        }
    }

    private void updateFlagParamLog(EntityAttrBoolean value, int userId) throws BGException {
        Objects.requireNonNull(value);
        String query = "INSERT INTO object_param_value_flag_log SET object_id=?, param_id=?, value=?, dt_change=now(), user_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, value.getEntityId());
            ps.setInt(index++, value.getEntitySpecAttrId());
            ps.setBoolean(index++, value.getValue());
            ps.setInt(index++, userId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private void updateListParamLog(EntityAttrList value, int userId) throws BGException {
        Objects.requireNonNull(value);
        String query = "SELECT title FROM object_list_value WHERE id=?";
        try {
            String title = "";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, value.getValue());
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        title = rs.getString(1);
                    }
                }
            }
            query = "INSERT INTO object_param_value_list_log SET object_id=?, param_id=?, value=?, title=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            try {
                int index = 1;
                ps.setInt(index++, value.getEntityId());
                ps.setInt(index++, value.getEntitySpecAttrId());
                ps.setInt(index++, value.getValue());
                ps.setString(index++, title);
                ps.setInt(index++, userId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private void updateDateParamLog(EntityAttrDate value, int userId) throws BGException {
        Objects.requireNonNull(value);
        String query = "INSERT INTO object_param_value_date_log SET object_id=?, param_id=?, value=?, dt_change=now(), user_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, value.getEntityId());
            ps.setInt(index++, value.getEntitySpecAttrId());
            ps.setDate(index++, value.getValue() != null ? TimeUtils.convertDateToSqlDate(value.getValue()) : null);
            ps.setInt(index++, userId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private void updateAddressParamLog(EntityAttrAddress value, int userId) throws BGException {
        Objects.requireNonNull(value);
        String query = "INSERT INTO object_param_value_address_log SET object_id=?, param_id=? , value=?, dt_change=now(), user_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, value.getEntityId());
            ps.setInt(index++, value.getEntitySpecAttrId());
            ps.setString(index++, value.getHouseId() > -1 ? value.getTitle() : "[\u0423\u0414\u0410\u041b\u0415\u041d\u041e]");
            ps.setInt(index++, userId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private String getValueSelect(int parameterType) {
        String title = "value";
        if (parameterType == EntitySpecAttrType.LIST.getCode()) {
            title = "concat( '[id=', CAST(log.value AS CHAR), '] ', IF(ISNULL(log.title), '', log.title) ) as value";
        }
        return title;
    }

    private String getTableName(int parameterTypeId) {
        switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)parameterTypeId).get()) {
            case LIST: {
                return LIST_VALUE_TABLE;
            }
            case DATE: {
                return DATE_VALUE_TABLE;
            }
            case ADDRESS: {
                return ADDRESS_VALUE_TABLE;
            }
            case BOOLEAN: {
                return FLAG_VALUE_TABLE;
            }
            case TEXT: {
                return TEXT_VALUE_TABLE;
            }
        }
        return TEXT_VALUE_TABLE;
    }

    public List<ParameterHistoryEntry> getParameterHistory(int objectId, int paramId, int parameterTypeId) throws Exception {
        ArrayList<ParameterHistoryEntry> result = new ArrayList<ParameterHistoryEntry>();
        String query = "SELECT " + this.getValueSelect(parameterTypeId) + ", log.dt_change, log.user_id  FROM " + this.getTableName(parameterTypeId) + "_log AS log  WHERE log.object_id=? AND log.param_id=?  ORDER BY log.dt_change";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new ParameterHistoryEntry().setValue(rs.getString(1)).setDate(TimeUtils.convertTimestampToDate(rs.getTimestamp(2))).setUser(rs.getString(3)));
                }
            }
        }
        return result;
    }

    public void clearParameterHistory(int objectId, int paramId, int paramTypeId) throws Exception {
        String query = "DELETE FROM " + this.getTableName(paramTypeId) + "_log WHERE object_id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            ps.executeUpdate();
        }
    }
}

