/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client.directory;

import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterSubject;
import ru.bitel.bgbilling.plugins.crm.common.service.CRMService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;

public class RegisterSubjectsEditor
extends BGPanel {
    private static final String MODULE_ADMIN_REGISTER = "ru.bitel.bgbilling.plugins.crm";
    private BGTable table = new BGTable();
    private BGPluginClient plugin = null;

    public RegisterSubjectsEditor() {
        try {
            this.jbInit();
            this.plugin = BGPluginManagerClient.getManager().getPlugin(MODULE_ADMIN_REGISTER);
            this.table.setHeader(this.plugin.getResourceBundle(), this.plugin.getTable("register_subject"), "register_subject");
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        RegisterSubjectsEditor.this.editItem();
                    }
                }
            });
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() throws Exception {
        Request req = new Request().setModule(MODULE_ADMIN_REGISTER).setAction("RegisterSubjectInfo");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.selectNode((Node)doc, (String)"//table"));
        }
    }

    public void deleteItem() {
        try {
            int id = ClientUtils.getRowId((BGTable)this.table);
            if (id != 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                ((CRMService)this.getContext().getWebService(CRMService.class)).registerSubjectDelete(id);
                this.setData();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void editItem() {
        int editID = ClientUtils.getRowId((BGTable)this.table);
        if (editID != 0) {
            RegSub regSub = this.getRequested(editID);
            new Editor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u043e\u0432 \u0437\u0432\u043e\u043d\u043a\u043e\u0432", regSub).open();
        }
    }

    public void newItem() {
        new Editor("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u043e\u0432 \u0437\u0432\u043e\u043d\u043a\u043e\u0432", this.getRequested(0)).open();
    }

    private RegSub getRequested(int id) {
        try {
            RegisterSubject registerSubject;
            Async items = Async.of(() -> ((CRMService)this.getContext().getWebService(CRMService.class)).registerGroupList(0).stream().map(IdTitle::toIdTitle).toList());
            RegSub regSub = new RegSub();
            if (id > 0 && (registerSubject = ((CRMService)this.getContext().getWebService(CRMService.class)).registerSubjectGet(id)) != null) {
                regSub.id = id;
                regSub.subjectGroupId = registerSubject.getGroupId();
                regSub.subject = registerSubject.getTitle();
                regSub.autoClose = registerSubject.isAutoClose();
            }
            regSub.items = (List)items.get();
            return regSub;
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return null;
        }
    }

    public static class RegSub {
        int id = 0;
        int subjectGroupId;
        String subject;
        boolean autoClose;
        List<IdTitle> items;
    }

    class Editor
    extends BGEditorDialog<RegSub> {
        private JTextField subject_TF;
        private JCheckBox autoClose_ChB;
        private BGUComboBox<IdTitle> subjectGroup_CB;

        public Editor(String title, RegSub data) {
            super(title, (Object)data);
            this.subject_TF = new JTextField(40);
            this.autoClose_ChB = new JCheckBox("\u0410\u0432\u0442\u043e\u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435");
            this.subjectGroup_CB = new BGUComboBox();
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.subject_TF, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.subjectGroup_CB, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.autoClose_ChB, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.subject_TF.setText(((RegSub)this.data).subject);
            this.autoClose_ChB.setSelected(((RegSub)this.data).autoClose);
            this.subjectGroup_CB.setData(((RegSub)this.data).items);
            this.subjectGroup_CB.setSelectedItem(((RegSub)this.data).items.stream().filter(a -> a.getId() == ((RegSub)this.data).subjectGroupId).findFirst().orElse(null));
        }

        public boolean doApply() throws Exception {
            if (this.subject_TF.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            IdTitle groupItem = (IdTitle)this.subjectGroup_CB.getSelectedItem();
            if (groupItem == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443");
                return false;
            }
            String subjectTitle = this.subject_TF.getText();
            if (subjectTitle.length() > 0) {
                RegisterSubject subject = RegisterSubject.builder().setId(((RegSub)this.data).id).setTitle(subjectTitle).setGroupId(groupItem.getId()).setAutoClose(this.autoClose_ChB.isSelected()).build();
                ((CRMService)RegisterSubjectsEditor.this.getContext().getWebService(CRMService.class, 0)).registerSubjectUpdate(subject);
                RegisterSubjectsEditor.this.setData();
            }
            return true;
        }
    }
}

