/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.SessionFlushingManager;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.util.FrequencyCounter;

public class SessionFlushingWorker
extends AccountingWorkerTask {
    private static final Logger logger = LogManager.getLogger();
    private final Accounting accounting;
    private final Setup setup;
    private final int moduleId;
    private long minDeltaAmount;
    private BigDecimal minDeltaAccount;
    private final SessionFlushingManager sessionFlushingManager;
    private final Iterable<? extends InetConnectionRuntime> sessions;
    private Iterator<? extends InetConnectionRuntime> iterator;
    private final FrequencyCounter flushedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private final long lockTimeout;
    private final Boolean disableServs;

    public SessionFlushingWorker(Accounting accounting, int batchSize, long minDeltaAmount, BigDecimal minDeltaAccount, Iterable<? extends InetConnectionRuntime> sessions) {
        super(batchSize);
        this.accounting = accounting;
        this.setup = accounting.setup;
        this.moduleId = accounting.moduleId;
        this.minDeltaAmount = minDeltaAmount != 0L ? minDeltaAmount : Long.MIN_VALUE;
        this.minDeltaAccount = minDeltaAccount != null && BigDecimal.ZERO.compareTo(minDeltaAccount) != 0 ? minDeltaAccount : BigDecimal.valueOf(Long.MIN_VALUE);
        this.sessionFlushingManager = new SessionFlushingManager(accounting, false);
        this.disableServs = null;
        this.sessions = sessions;
        this.lockTimeout = 15000L;
    }

    public SessionFlushingWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, String name, ParameterMap params, ParameterMap defaultParams, Iterable<? extends InetConnectionRuntime> sessions) {
        super(scheduledExecutorService, name, params, defaultParams);
        this.accounting = accounting;
        this.setup = accounting.setup;
        this.moduleId = accounting.moduleId;
        this.minDeltaAmount = this.minDeltaAmount != 0L ? this.minDeltaAmount : Long.MIN_VALUE;
        this.minDeltaAccount = this.minDeltaAccount != null && BigDecimal.ZERO.compareTo(this.minDeltaAccount) != 0 ? this.minDeltaAccount : BigDecimal.valueOf(Long.MIN_VALUE);
        this.lockTimeout = params.getLong("lockTimeout", defaultParams.getLong("lockTimeout", 15000L));
        logger.info("Add flushing worker: minDeltaAmount={}, minDeltaAccount={}, delay={}, batchSize={}, lockTimeout={}", (Object)this.minDeltaAmount, (Object)this.minDeltaAccount, (Object)this.getDelay(), (Object)this.batchSize, (Object)this.lockTimeout);
        this.sessionFlushingManager = new SessionFlushingManager(accounting, false);
        String disableServs = params.get("disableServs", defaultParams.get("disableServs", null));
        this.disableServs = Utils.isBlankString((String)disableServs) ? null : Boolean.valueOf(Utils.parseBoolean((String)disableServs));
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() throws Exception {
        ZonedDateTime now;
        logger.trace("Run flushing to database...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.sessions.iterator();
        }
        int batchSize = this.batchSize;
        int checkCount = Math.max(10000, batchSize * 20);
        if (batchSize != Integer.MAX_VALUE && (now = ZonedDateTime.now()).getHour() == 0 && now.getMinute() < 5) {
            batchSize = 50;
            checkCount = 1000;
        }
        long time = System.currentTimeMillis();
        int count = 0;
        long flushTime = 0L;
        Connection con = this.setup.getDBConnectionFromPool();
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        String profileQuery = moduleSetup != null ? moduleSetup.get("session.flushing.profile.query", null) : null;
        this.startProfiling(con, profileQuery);
        try (BalanceDao balanceDao = new BalanceDao(con);){
            con.setAutoCommit(false);
            for (int i = 0; i < checkCount && count < batchSize && this.iterator.hasNext(); ++i) {
                InetConnectionRuntime connectionRuntime = this.iterator.next();
                BigDecimal sessionCostDelta = connectionRuntime.sessionCostDelta;
                long trafficDeltaAmount = connectionRuntime.trafficDeltaFlushAmount;
                int balanceRoundingScale = 2;
                RoundingMode balanceRoundingMode = RoundingMode.FLOOR;
                if (this.disableServs != null && this.disableServs.booleanValue() != this.accounting.getDisableServIds().contains(connectionRuntime.inetServId) || (this.minDeltaAmount > trafficDeltaAmount || trafficDeltaAmount == 0L) && (this.minDeltaAccount.compareTo(sessionCostDelta) > 0 || BigDecimal.ZERO.compareTo(sessionCostDelta.setScale(balanceRoundingScale, balanceRoundingMode)) == 0)) continue;
                if (this.disableServs == null && this.accounting.getDisableServIds().contains(connectionRuntime.inetServId)) {
                    if (!connectionRuntime.inetServRuntime.tryLock()) {
                        continue;
                    }
                } else if (this.lockTimeout > 0L) {
                    if (!connectionRuntime.inetServRuntime.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
                        continue;
                    }
                } else {
                    connectionRuntime.inetServRuntime.lock();
                }
                try {
                    long now2 = System.currentTimeMillis();
                    if (this.sessionFlushingManager.flush(con, balanceDao, connectionRuntime, false, false, false, false, now2, false)) {
                        con.commit();
                        ++count;
                        connectionRuntime.trafficDeltaFlushAmount = 0L;
                    } else if (!con.getAutoCommit()) {
                        con.rollback();
                    }
                    flushTime += System.currentTimeMillis() - now2;
                    continue;
                }
                finally {
                    connectionRuntime.inetServRuntime.unlock();
                }
            }
            if (count > 0) {
                this.printProfiling(con, profileQuery);
            }
        }
        catch (Throwable e) {
            logger.error("error run session flushing worker", e);
        }
        finally {
            this.stopProfiling(con, profileQuery);
            this.sessionFlushingManager.close();
            ServerUtils.closeConnection((Connection)con);
        }
        long time2 = System.currentTimeMillis();
        long duration = time2 - time;
        this.flushedPerMinute.add(time2, (long)count);
        this.processTimePerMinute.add(time2, flushTime);
        this.processTimePerTenMinutes.add(time2, duration);
        this.invokePerMinute.add(time2, 1L);
        this.invokePerTenMinutes.add(time2, 1L);
        if (logger.isInfoEnabled() && count > 0) {
            logger.info("Flushed " + count + " sessions for " + duration + "(" + flushTime + ") ms.");
        }
    }

    private void startProfiling(Connection con, String profileQuery) throws SQLException {
        if (logger.isDebugEnabled() && Utils.notBlankString((String)profileQuery)) {
            Statement stmt = con.createStatement();
            try {
                stmt.executeUpdate("SET profiling=1");
            }
            catch (SQLException ex) {
                logger.error("error set profiling", (Throwable)ex);
            }
            stmt.close();
        }
    }

    private void stopProfiling(Connection con, String profileQuery) throws SQLException {
        if (logger.isDebugEnabled() && Utils.notBlankString((String)profileQuery)) {
            Statement stmt = con.createStatement();
            try {
                stmt.executeUpdate("SET profiling=0");
            }
            catch (SQLException ex) {
                logger.error("error stop profiling", (Throwable)ex);
            }
            stmt.close();
        }
    }

    private void printProfiling(Connection con, String profileQuery) throws SQLException {
        if (Utils.notBlankString((String)profileQuery)) {
            for (String query : profileQuery.split("\\s*;\\s*")) {
                if (!Utils.notBlankString((String)query)) continue;
                this.printProfiling0(con, query);
            }
        }
    }

    private void printProfiling0(Connection con, String profileQuery) throws SQLException {
        if (logger.isDebugEnabled() && Utils.notBlankString((String)profileQuery)) {
            Statement stmt = con.createStatement();
            try {
                int i;
                ResultSet rs = stmt.executeQuery(profileQuery);
                StringBuilder sb = new StringBuilder(100).append("\n");
                ResultSetMetaData meta = rs.getMetaData();
                int columnCount = meta.getColumnCount();
                for (i = 1; i <= columnCount; ++i) {
                    sb.append(meta.getColumnName(i)).append('\t');
                }
                sb.append("\n");
                while (rs.next()) {
                    for (i = 1; i <= columnCount; ++i) {
                        sb.append(rs.getString(i)).append('\t');
                    }
                    sb.append("\n");
                }
                logger.info(sb.toString());
            }
            catch (SQLException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            stmt.close();
        }
    }

    @MBeanAttribute
    public long getFlushedPerMinute() {
        return this.flushedPerMinute.get(System.currentTimeMillis());
    }
}

