/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.common.dao;

import jakarta.annotation.Nonnull;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.Id;

public abstract class AbstractIdDao<B extends Id>
extends AbstractDao<B> {
    public AbstractIdDao(Connection con, int moduleId, String tableName, Date date) {
        super(con, tableName, moduleId, date);
    }

    public AbstractIdDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public B get(int id) throws SQLException {
        return (B)((Id)this.getImpl(id));
    }

    public Optional<B> opt(int id) {
        try {
            return Optional.ofNullable(this.get(id));
        }
        catch (Exception ex) {
            throw new BGRuntimeException(ex);
        }
    }

    public int delete(int id) throws SQLException {
        return this.deleteImpl(id);
    }

    public B getAndUpdate(B b) throws SQLException {
        B old = ((Id)b).getId() > 0 ? (B)this.get(((Id)b).getId()) : null;
        this.update(b);
        return old;
    }

    public B getAndDelete(int id) throws SQLException {
        B old = this.get(id);
        this.delete(id);
        return old;
    }

    protected int executeUpdate(Id id, int index, PreparedStatement ps) throws SQLException {
        boolean update;
        boolean bl = update = id.getId() > 0;
        if (update) {
            ps.setInt(index++, id.getId());
        }
        ps.executeUpdate();
        if (!update) {
            id.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        return index;
    }

    protected String sqlCommandAndTable(boolean update) {
        return this.sqlCommand(update) + this.tableName;
    }

    protected String sqlCommand(boolean update) {
        return update ? "UPDATE " : "INSERT INTO ";
    }

    protected String sqlWhereId(boolean update) {
        return update ? " WHERE id=?" : "";
    }

    protected PreparedStatement prepareStatement(Id id, String querySet) throws SQLException {
        return this.con.prepareStatement(this.sqlQuery(id, querySet), 1);
    }

    protected String sqlQuery(@Nonnull Id id, String querySet) {
        Objects.requireNonNull(id, "id must not be null");
        boolean update = id.getId() > 0;
        return this.sqlCommandAndTable(update) + " SET " + querySet + this.sqlWhereId(update);
    }
}

