/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionData;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class BGSActionUtils {
    public static Element fillXml(Element rootNode, String name, String moduleId, String title) throws BGException {
        File file = new File("actions/" + name + ".xml");
        if (file.exists() && file.canRead()) {
            try {
                Element rootElement;
                Document document;
                InputStreamReader reader;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    reader = new InputStreamReader(fileInputStream);
                    try {
                        document = XMLUtils.parseDocument((InputSource)new InputSource(reader));
                        rootElement = XMLUtils.selectElement((Node)document, (String)"//actions");
                        rootElement.setAttribute("id", moduleId);
                        rootElement.setAttribute("title", title);
                    }
                    finally {
                        ((Reader)reader).close();
                    }
                }
                file = new File("actions/" + name + ".custom.xml");
                if (file.exists() && file.canRead()) {
                    fileInputStream = new FileInputStream(file);
                    try {
                        reader = new InputStreamReader(fileInputStream);
                        try {
                            document = XMLUtils.parseDocument((InputSource)new InputSource(reader));
                            Element element = XMLUtils.selectElement((Node)document, (String)"//actions");
                            BGSActionUtils.importCustom(element, rootElement);
                        }
                        finally {
                            ((Reader)reader).close();
                        }
                    }
                    finally {
                        fileInputStream.close();
                    }
                }
                rootNode.appendChild(rootNode.getOwnerDocument().importNode(rootElement, true));
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return rootNode;
    }

    public static ActionData getActionDataRoot(String componentName) throws Exception {
        ActionData actionData = new ActionData();
        Document doc = XMLUtils.newDocument();
        Element rootNode = XMLUtils.createElement((Document)doc, (String)"data");
        BGSActionUtils.fillXml(rootNode, componentName, "0", componentName.toUpperCase());
        BGSActionUtils.buildActionTree(actionData, rootNode);
        return actionData.getChildren() != null ? actionData.getChildren().get(0) : actionData;
    }

    private static void buildActionTree(ActionData parentActionData, Element parentNode) {
        NodeList list = parentNode.getChildNodes();
        int len = list.getLength();
        for (int index = 0; index < len; ++index) {
            Node node = list.item(index);
            if (node.getNodeType() != 1 || !"actions".equals(node.getNodeName()) && !"group".equals(node.getNodeName()) && !"service".equals(node.getNodeName())) continue;
            ActionData actionData = new ActionData();
            actionData.setTitle(((Element)node).getAttribute("title"));
            actionData.setServiceId(Utils.parseInt((String)((Element)node).getAttribute("id")));
            actionData.setServiceName(((Element)node).getAttribute("name"));
            actionData.setServiceOperation(((Element)node).getAttribute("operation"));
            List<ActionData> childrens = parentActionData.getChildren();
            if (childrens == null) {
                childrens = new ArrayList<ActionData>();
                parentActionData.setChildren(childrens);
            }
            childrens.add(actionData);
            BGSActionUtils.buildActionTree(actionData, (Element)node);
        }
    }

    private static void importCustom(Element fromElement, Element toElement) throws Exception {
        Element el;
        String id;
        Element customGroupElement = XMLUtils.selectElement((Node)toElement, (String)"group[@title=\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435]");
        if (customGroupElement == null) {
            customGroupElement = toElement.getOwnerDocument().createElement("group");
            customGroupElement.setAttribute("title", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435");
            toElement.appendChild(customGroupElement);
        }
        for (Element element : XMLUtils.selectElements((Node)fromElement, (String)"//service")) {
            id = element.getAttribute("id");
            if (!Utils.notBlankString((String)id)) continue;
            el = XMLUtils.selectElement((Node)toElement, (String)("//service[@id=" + id + "]"));
            if (el == null) {
                el = toElement.getOwnerDocument().createElement("service");
                el.setAttribute("id", id);
                customGroupElement.appendChild(el);
            }
            el.setAttribute("name", element.getAttribute("name"));
            el.setAttribute("operation", element.getAttribute("operation"));
            el.setAttribute("title", element.getAttribute("title"));
        }
        for (Element element : XMLUtils.selectElements((Node)fromElement, (String)"//action")) {
            id = element.getAttribute("id");
            if (!Utils.notBlankString((String)id)) continue;
            el = XMLUtils.selectElement((Node)toElement, (String)("//action[@id=" + id + "]"));
            if (el == null) {
                el = toElement.getOwnerDocument().createElement("action");
                el.setAttribute("id", id);
                customGroupElement.appendChild(el);
            }
            el.setAttribute("mask", element.getAttribute("mask"));
            el.setAttribute("title", element.getAttribute("title"));
        }
    }
}

