/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetConnectionCommandEvent;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Result;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.common.worker.WorkerThreadFactory;

public class AuthUtils {
    private static final Logger logger = LogManager.getLogger();
    private static final ThreadContextFactory<ServerContext> CONTEXT_FACTORY = new ThreadContextFactory<ServerContext>(){

        public ServerContext newThreadContext() {
            return new ServerContext(Setup.getSetup(), 0, 0);
        }
    };
    private static final WorkerThreadFactory<ServerContext> THREAD_FACTORY = new WorkerThreadFactory("con-rebind-check", "script", CONTEXT_FACTORY);
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, THREAD_FACTORY);

    public static Object[] connectionFindByLogin(Connection con, int moduleId, Set<Integer> servIds, String login) throws SQLException, BGException, UnknownHostException {
        if (logger.isInfoEnabled()) {
            logger.info("Login: " + login);
        }
        return AuthUtils.connectionFind(con, moduleId, servIds, null, null, login, null);
    }

    public static Object[] connectionFindByAddress(Connection con, int moduleId, Set<Integer> servIds, String address) throws SQLException, BGException, UnknownHostException {
        return AuthUtils.connectionFind(con, moduleId, servIds, null, address, null, null);
    }

    public static Object[] connectionFind(Connection con, int moduleId, Set<Integer> servIds, String acctSessionId, String address, String login, String callingStationId) throws SQLException, BGException, UnknownHostException {
        Pair<InetServ, InetConnection> result = InetConnectionDao.find(con, moduleId, servIds, acctSessionId, address, login, callingStationId);
        if (result == null) {
            return null;
        }
        return new Object[]{result.getFirst(), result.getSecond()};
    }

    public static void connectionRebind(Setup setup, Connection con, int moduleId, long connectionId, int newContractId, int newServId, short newState, Set<Integer> newOptionIds) throws Exception {
        InetConnectionDao inetConnectionDao = new InetConnectionDao(con, moduleId);
        InetConnection inetConnection = inetConnectionDao.get(connectionId);
        int accountingRootDeviceId = InetUtils.getAccountingRootDeviceId(setup, moduleId, inetConnection.getDeviceId());
        EventProcessor.getInstance().publishAfterCommit((Event)new InetConnectionCommandEvent(moduleId, 0, accountingRootDeviceId, inetConnection.getDeviceId(), newServId, inetConnection.getId(), "rebind:" + newState + ":" + Utils.toString(newOptionIds)));
        RebindChecker2 checker = new RebindChecker2(moduleId, inetConnection.getServId(), newContractId, newServId, inetConnection.getAcctSessionId(), newState, newOptionIds);
        ScheduledFuture<?> future = executorService.scheduleAtFixedRate(checker, 2L, 2L, TimeUnit.SECONDS);
        checker.future = future;
    }

    public static int inetServCreate(ServerContext context, int moduleId, int contractId, int servTypeId, int parentId, Date dateFrom, int deviceId, int vlan, int interfaceId, String login, String mac, String comment) throws Exception {
        if (dateFrom == null) {
            dateFrom = new Date();
        }
        if (parentId < 0) {
            parentId = 0;
        }
        if (Utils.isBlankString((String)login)) {
            login = "";
        }
        InetServService inetServService = (InetServService)context.getService(InetServService.class, moduleId);
        InetServ inetServ = new InetServ();
        inetServ.setParentId(parentId);
        inetServ.setContractId(contractId);
        inetServ.setTypeId(servTypeId);
        inetServ.setDeviceId(deviceId);
        inetServ.setDateFrom(dateFrom);
        inetServ.setLogin(login);
        inetServ.setVlan(vlan);
        inetServ.setInterfaceId(interfaceId);
        if (Utils.notEmptyString((String)mac)) {
            String[] macAddresses = mac.split("\\s*,\\s*");
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>();
            for (String macAddress : macAddresses) {
                if (macAddress.length() <= 0) continue;
                macAddressList.add(MACParser.parseMacAddress((String)macAddress));
            }
            inetServ.setMacAddressList(macAddressList);
        }
        inetServ.setComment(Utils.maskNull((String)comment));
        List inetOptionList = Collections.emptyList();
        inetServService.inetServUpdate(inetServ, inetOptionList, Utils.isBlankString((String)login), true, 0L);
        return inetServ.getId();
    }

    public static void schedule(Runnable command, long delay, TimeUnit unit) {
        executorService.schedule(command, delay, unit);
    }

    public static InetServ inetServRegister(ServerContext context, int moduleId, int contractId, int servTypeId, int deviceId, int port, int vlan, String login, String mac, String address) throws Exception {
        InetServ inetServ;
        logger.info("inetServRegister, contractId: " + contractId);
        InetServService inetServService = (InetServService)context.getService(InetServService.class, moduleId);
        InetSessionService inetSessionService = (InetSessionService)context.getService(InetSessionService.class, moduleId);
        Object oldServ = null;
        if (servTypeId <= 0) {
            throw new BGIllegalArgumentException("servTypeId");
        }
        List oldServList = inetServService.inetServList(contractId, null);
        for (Object serv : oldServList) {
            if (serv.getTypeId() != servTypeId || !TimeUtils.dateInRange((Date)new Date(), (Date)serv.getDateFrom(), (Date)serv.getDateTo())) continue;
            logger.info("Found existing inetServ:" + serv.getId());
            oldServ = serv;
            break;
        }
        if (oldServ != null) {
            Result sessionList = inetSessionService.inetSessionAliveContractList(contractId, Collections.singleton(oldServ.getId()), null, null, null, null, null);
            for (InetSessionLog session : sessionList.getList()) {
                logger.info("Finish " + session.getConnectionId());
                inetSessionService.connectionFinish(session.getConnectionId());
            }
        }
        List inetOptionList = Collections.emptyList();
        if (oldServ != null) {
            inetServ = oldServ;
            inetOptionList = inetServService.inetServOptionList(inetServ.getId());
        } else {
            logger.info("Creating new InetServ");
            inetServ = new InetServ();
            inetServ.setContractId(contractId);
            inetServ.setTypeId(servTypeId);
            inetServ.setDateFrom(new Date());
            inetServ.setComment("");
            inetOptionList = Collections.emptyList();
        }
        inetServ.setDeviceId(deviceId);
        inetServ.setInterfaceId(port);
        inetServ.setVlan(vlan);
        if (address != null) {
            try {
                inetAddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                throw new BGException(e.getMessage(), (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("inetAddress: " + IpAddress.toString((byte[])inetAddress.getAddress()));
            }
            inetServ.setAddressFrom(inetAddress.getAddress());
        } else {
            inetAddress = null;
        }
        inetServ.setLogin(Utils.maskNull((String)login));
        if (Utils.notBlankString((String)mac)) {
            String[] macAddresses = mac.split("\\s*,\\s*");
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>();
            for (String macAddress : macAddresses) {
                if (macAddress.length() <= 0) continue;
                macAddressList.add(MACParser.parseMacAddress((String)macAddress));
            }
            inetServ.setMacAddressList(macAddressList);
        }
        inetServService.inetServUpdate(inetServ, inetOptionList, false, false, 0L);
        logger.info("inetServId:" + inetServ.getId());
        return inetServ;
    }

    static class RebindChecker2
    extends WorkerTask<ServerContext>
    implements Runnable {
        private final int moduleId;
        private final int contractId;
        private final int inetServId;
        private final String acctSessionId;
        private int count;
        private volatile ScheduledFuture<?> future;

        RebindChecker2(int moduleId, int oldInetServId, int contractId, int inetServId, String acctSessionId, short newState, Set<Integer> newOptionIds) {
            this.moduleId = moduleId;
            this.contractId = contractId;
            this.inetServId = inetServId;
            this.acctSessionId = acctSessionId;
        }

        protected void runImpl() throws Exception {
            if (this.count++ > 9) {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.notify(20L);
            }
            HashSet<Integer> servIds = new HashSet<Integer>(Arrays.asList(this.inetServId));
            Object[] connectionData = AuthUtils.connectionFind(((ServerContext)this.context).getConnection(), this.moduleId, servIds, this.acctSessionId, null, null, null);
            if (connectionData == null) {
                logger.info("Connection not found.");
                return;
            }
            this.notify(1L);
            this.notify(10L);
            this.notify(120L);
            if (this.future != null) {
                this.future.cancel(false);
            }
        }

        private void notify(long timeout) {
            executorService.schedule((Runnable)new WorkerTask<ServerContext>(){

                protected void runImpl() throws Exception {
                    EventProcessor.getInstance().publish((Event)new ContractModifiedEvent(0, contractId));
                }
            }, timeout, TimeUnit.SECONDS);
        }
    }

    static class RebindChecker
    extends WorkerTask<ServerContext>
    implements Runnable {
        private final int moduleId;
        private final int oldInetServId;
        private final int contractId;
        private final int inetServId;
        private final String acctSessionId;
        private final boolean checkRebind;
        private final short newState;
        private final Set<Integer> newOptionIds;

        RebindChecker(int moduleId, int oldInetServId, int contractId, int inetServId, String acctSessionId, boolean checkRebind, short newState, Set<Integer> newOptionIds) {
            this.moduleId = moduleId;
            this.oldInetServId = oldInetServId;
            this.contractId = contractId;
            this.inetServId = inetServId;
            this.acctSessionId = acctSessionId;
            this.checkRebind = checkRebind;
            this.newState = newState;
            this.newOptionIds = newOptionIds;
        }

        protected void runImpl() throws Exception {
            Object[] connectionData = AuthUtils.connectionFind(((ServerContext)this.context).getConnection(), this.moduleId, Collections.singleton(this.checkRebind ? this.oldInetServId : this.inetServId), this.acctSessionId, null, null, null);
            if (connectionData == null) {
                if (!this.checkRebind) {
                    logger.info("Connection not found.");
                } else {
                    executorService.schedule(new RebindChecker(this.moduleId, this.oldInetServId, this.contractId, this.inetServId, this.acctSessionId, false, this.newState, this.newOptionIds), 3L, TimeUnit.SECONDS);
                }
                return;
            }
            InetServ inetServ = (InetServ)connectionData[0];
            InetConnection inetConnection = (InetConnection)connectionData[1];
            if (this.checkRebind) {
                int accountingRootDeviceId = InetUtils.getAccountingRootDeviceId(((ServerContext)this.context).getSetup(), this.moduleId, inetConnection.getDeviceId());
                EventProcessor.getInstance().publishAfterCommit((Event)new InetConnectionCommandEvent(this.moduleId, 0, accountingRootDeviceId, inetConnection.getDeviceId(), inetServ.getId(), inetConnection.getId(), "rebind:" + this.newState + ":" + Utils.toString(this.newOptionIds)));
                executorService.schedule(new RebindChecker(this.moduleId, this.oldInetServId, this.contractId, this.inetServId, this.acctSessionId, false, this.newState, this.newOptionIds), 3L, TimeUnit.SECONDS);
                return;
            }
            executorService.schedule((Runnable)new WorkerTask<ServerContext>(){

                protected void runImpl() throws Exception {
                    EventProcessor.getInstance().publish((Event)new ContractModifiedEvent(0, contractId));
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }
}

