/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceSelector;
import ru.bitel.bgbilling.apps.inet.accounting.event.FlowAgentInterfaceMapReloadedEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceInterfaceIndexDao;

public final class FlowAgentInterfaceMap
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    final Accounting accounting;
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, FlowAgentInterface>> agentMap = new ConcurrentHashMap<Integer, ConcurrentMap<Integer, FlowAgentInterface>>();
    private volatile Map<Integer, FlowAgentInterface[]> deviceIfaceMap;

    public FlowAgentInterfaceMap(Accounting accounting) throws BGException {
        this.accounting = accounting;
        if (accounting.realtime) {
            EventProcessor.getInstance().addListener((EventListener)this, InetReloadLocalEvent.class, accounting.moduleId, null);
        }
    }

    public void notify(Event e, EventListenerContext ctx) throws BGException {
        this.load(ctx.getConnectionSet(), this.accounting.deviceMap.getMap());
    }

    ConcurrentMap<Integer, ConcurrentMap<Integer, FlowAgentInterface>> getAgentMap() {
        return this.agentMap;
    }

    public FlowAgentInterface[] getFlowAgentInterfaces(Integer deviceId) {
        return this.deviceIfaceMap.get(deviceId);
    }

    private static Map<Integer, Map<Integer, List<Integer>>> getFlowAgentIfaceMap(Accounting accounting, Map<Integer, InetDeviceRuntime> deviceMap) {
        logger.info("getFlowAgentIfaceMap");
        HashMap<Integer, Map<Integer, List<Integer>>> flowAgentIfaceMap = new HashMap<Integer, Map<Integer, List<Integer>>>();
        for (Map.Entry<Integer, InetDeviceRuntime> e : deviceMap.entrySet()) {
            Integer deviceId = e.getKey();
            InetDeviceRuntime device = e.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("deviceId = " + deviceId + "; device = " + String.valueOf(device));
            }
            if (device.inetDevice.getDateTo() != null && TimeUtils.dateBefore((Date)device.inetDevice.getDateTo(), (Date)accounting.initialDate)) {
                logger.info("Skip load flow interfaces for device:" + deviceId + " due to close period");
                continue;
            }
            for (Map.Entry<Integer, List<Integer>> agent : device.flowAgentIfaceMap.entrySet()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("agent = " + String.valueOf(agent) + "; agent.getKey() = " + String.valueOf(agent.getKey()));
                }
                HashMap<Integer, ArrayList<Integer>> ifaceMap = (HashMap<Integer, ArrayList<Integer>>)flowAgentIfaceMap.get(agent.getKey());
                if (logger.isDebugEnabled()) {
                    logger.debug("ifaceMap = " + String.valueOf(ifaceMap));
                }
                if (ifaceMap == null) {
                    ifaceMap = new HashMap<Integer, ArrayList<Integer>>();
                    flowAgentIfaceMap.put(agent.getKey(), ifaceMap);
                }
                for (Integer iface : agent.getValue()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("iface = " + iface);
                    }
                    ArrayList<Integer> devices = (ArrayList<Integer>)ifaceMap.get(iface);
                    if (logger.isDebugEnabled()) {
                        logger.debug("devices = " + String.valueOf(devices));
                    }
                    if (devices == null) {
                        devices = new ArrayList<Integer>();
                        ifaceMap.put(iface, devices);
                    }
                    devices.add(deviceId);
                }
            }
        }
        return flowAgentIfaceMap;
    }

    public synchronized void load(ConnectionSet connectionSet, Map<Integer, InetDeviceRuntime> deviceMap) {
        try {
            logger.info("Reload FlowAgentInterfaceMap");
            long start = System.currentTimeMillis();
            DeviceInterfaceIndexDao deviceInterfaceDao = new DeviceInterfaceIndexDao(connectionSet.getConnection(), this.accounting.moduleId);
            Map<Integer, Map<Integer, List<Integer>>> flowAgentIfaceMap = FlowAgentInterfaceMap.getFlowAgentIfaceMap(this.accounting, deviceMap);
            HashMap<Integer, ArrayList<FlowAgentInterface>> deviceIfaceMap = new HashMap<Integer, ArrayList<FlowAgentInterface>>();
            HashMap deviceifaceIndexMap = new HashMap();
            for (Map.Entry<Integer, Map<Integer, List<Integer>>> agent : flowAgentIfaceMap.entrySet()) {
                InetDeviceRuntime device;
                ConcurrentHashMap<Integer, FlowAgentInterface> newIfaceMap;
                Integer agentDeviceId = agent.getKey();
                Map<Integer, List<Integer>> ifaceDeviceMap = agent.getValue();
                ConcurrentHashMap<Integer, FlowAgentInterface> ifaceMap = (ConcurrentHashMap<Integer, FlowAgentInterface>)this.agentMap.get(agentDeviceId);
                if (ifaceMap == null && (ifaceMap = (ConcurrentMap)this.agentMap.putIfAbsent(agentDeviceId, newIfaceMap = new ConcurrentHashMap<Integer, FlowAgentInterface>())) == null) {
                    ifaceMap = newIfaceMap;
                }
                if ((device = deviceMap.get(agentDeviceId)) == null) {
                    logger.error("Agent device with id=" + agentDeviceId + " not found!");
                } else if (logger.isDebugEnabled()) {
                    logger.debug("FlowAgent id=" + agentDeviceId + ", " + String.valueOf(device.inetDevice) + ", ifaces=" + String.valueOf(ifaceDeviceMap.keySet()));
                }
                Map ifaceIndexMap = DeviceInterfaceIndexDao.getIfaceIndexMap((DeviceInterfaceIndexDao)deviceInterfaceDao, deviceifaceIndexMap, (int)(device != null ? device.inetDevice.getInvDeviceId() : agentDeviceId.intValue()));
                try {
                    for (Map.Entry<Integer, List<Integer>> iface : ifaceDeviceMap.entrySet()) {
                        Integer interfaceId = iface.getKey();
                        FlowAgentInterface flowAgentInterface = (FlowAgentInterface)((Object)ifaceMap.get(interfaceId));
                        if (flowAgentInterface == null) {
                            flowAgentInterface = new FlowAgentInterface(this.accounting, agentDeviceId, device, interfaceId, iface.getValue());
                            ifaceMap.put(iface.getKey(), flowAgentInterface);
                        } else {
                            flowAgentInterface.load(iface.getValue());
                        }
                        flowAgentInterface.ifaceIndexList = (List)ifaceIndexMap.get(interfaceId);
                        for (Integer deviceId : iface.getValue()) {
                            ArrayList<FlowAgentInterface> deviceIfaceList = (ArrayList<FlowAgentInterface>)deviceIfaceMap.get(deviceId);
                            if (deviceIfaceList == null) {
                                deviceIfaceList = new ArrayList<FlowAgentInterface>();
                                deviceIfaceMap.put(deviceId, deviceIfaceList);
                            }
                            deviceIfaceList.add(flowAgentInterface);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            HashMap<Integer, FlowAgentInterface[]> deviceIfaceArrayMap = new HashMap<Integer, FlowAgentInterface[]>();
            for (Map.Entry e : deviceIfaceMap.entrySet()) {
                List accountingInterfaces = (List)e.getValue();
                if (accountingInterfaces.size() <= 0) continue;
                deviceIfaceArrayMap.put((Integer)e.getKey(), accountingInterfaces.toArray(new FlowAgentInterface[accountingInterfaces.size()]));
            }
            this.deviceIfaceMap = deviceIfaceArrayMap;
            if (this.accounting.realtime) {
                EventProcessor.getInstance().request((QueueEvent)new FlowAgentInterfaceMapReloadedEvent(this.accounting.moduleId, deviceMap));
            }
            logger.info("FlowAgentInterfaceMap reload completed for " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public FlowAgentInterfaceSelector newSelector(Set<Integer> agentDeviceIds, int agentType) throws BGException {
        return new FlowAgentInterfaceSelector(this.accounting, agentDeviceIds, agentType);
    }
}

