/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.action.base;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.hd.server.AgentAction;
import ru.bitel.bgbilling.modules.hd.server.AgentDriver;
import ru.bitel.bgbilling.modules.hd.server.HostingAgentDriver;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHosting;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHostingManager;
import ru.bitel.bgbilling.modules.hd.server.bean.ContractPackage;
import ru.bitel.bgbilling.modules.hd.server.bean.HdPackage;
import ru.bitel.bgbilling.modules.hd.server.bean.HostingServer;
import ru.bitel.bgbilling.modules.hd.server.bean.HostingServerManager;
import ru.bitel.bgbilling.modules.hd.server.bean.HostingType;
import ru.bitel.bgbilling.modules.hd.server.bean.HostingTypeManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public abstract class ActionBase
extends bitel.billing.server.ActionBase {
    private static final Pattern domainPattern = Pattern.compile("^[a-zA-Z0-9\\-]+$");

    protected boolean checkHostExist(String host) throws BGException {
        boolean result = false;
        try {
            InetAddress.getByName(host);
            result = true;
        }
        catch (UnknownHostException e) {
            throw new BGMessageException("\u0425\u043e\u0441\u0442 " + host + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d DNS!");
        }
        return result;
    }

    protected boolean checkName(String name) {
        boolean result = false;
        try {
            result = domainPattern.matcher(name).find();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected List<AgentAction> getActions(HdPackage hdPackage, ContractPackage cp) throws Exception {
        HostingTypeManager hostingTypeManager = new HostingTypeManager(this.con, this.mid);
        HostingServerManager hostingServerManager = new HostingServerManager(this.con, this.mid);
        CPHostingManager hostingManager = new CPHostingManager(this.con, this.mid);
        ArrayList<AgentAction> actions = new ArrayList<AgentAction>();
        if (hdPackage.isNsEnable()) {
            // empty if block
        }
        if (hdPackage.isHostEnable()) {
            // empty if block
        }
        if (hdPackage.isHostingEnable()) {
            HostingType hostingType = hostingTypeManager.getType(hdPackage.getHostingType());
            if (hostingType == null) {
                throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u0445\u043e\u0441\u0442\u0438\u043d\u0433\u0430. \u041a\u043e\u0434 " + hdPackage.getHostingType());
            }
            HostingServer hostingServer = hostingServerManager.getServer(hostingType.getServerId());
            if (hostingServer == null) {
                throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0441\u0435\u0440\u0432\u0435\u0440 \u0445\u043e\u0441\u0442\u0438\u043d\u0433\u0430. \u041a\u043e\u0434 " + hostingType.getServerId());
            }
            CPHosting hosting = hostingManager.getHosting(cp.getId());
            if (hosting == null) {
                throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0445\u043e\u0441\u0442\u0438\u043d\u0433");
            }
            String name = null;
            Preferences typeSetup = new Preferences(hostingType.getConfig(), "\r\n");
            name = typeSetup.get("name", null);
            if (Utils.isBlankString((String)name)) {
                throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'name' \u0432 \u0442\u0438\u043f\u0435 \u0445\u043e\u0441\u0442\u0438\u043d\u0433\u0430");
            }
            HostingAgentDriver hostingAgent = new HostingAgentDriver((Preferences)this.moduleSetup, hostingServer);
            AgentAction item = new AgentAction();
            actions.add(item);
            item.type = 4;
            item.hostingAgent = hostingAgent;
            item.hostingHosts = hosting.getHostList();
            item.hostingUser = String.valueOf(cp.getId());
            item.hostingType = name;
        }
        return actions;
    }

    protected Set<AgentDriver> checkAgents(List<AgentAction> actions) throws BGException {
        HashSet<AgentDriver> driverSet = new HashSet<AgentDriver>();
        for (AgentAction item : actions) {
            AgentDriver driver = null;
            driver = item.type == 4 ? item.hostingAgent : item.nsAgent;
            driverSet.add(driver);
        }
        for (AgentDriver driver : driverSet) {
            try {
                driver.connect();
                driver.disconnect();
            }
            catch (Exception e) {
                throw new BGException("\u0421\u0435\u0442\u0435\u0432\u043e\u0439 \u0430\u0433\u0435\u043d\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d: " + driver.getName());
            }
        }
        return driverSet;
    }

    protected void tryDo(List<AgentAction> actions) throws Exception {
        int size = actions.size();
        int pos = 0;
        block34: for (pos = 0; pos < size; ++pos) {
            AgentAction action = actions.get(pos);
            try {
                switch (action.type) {
                    case 5: {
                        try {
                            action.nsAgent.connect();
                            action.nsAgent.deleteHost(action);
                            continue block34;
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
                        finally {
                            action.nsAgent.disconnect();
                        }
                    }
                    case 3: {
                        try {
                            action.nsAgent.connect();
                            action.nsAgent.addHost(action);
                            continue block34;
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
                        finally {
                            action.nsAgent.disconnect();
                        }
                    }
                    case 1: {
                        try {
                            action.nsAgent.connect();
                            action.nsAgent.addMasterSupport(action);
                            continue block34;
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
                        finally {
                            action.nsAgent.disconnect();
                        }
                    }
                    case 2: {
                        try {
                            action.nsAgent.connect();
                            action.nsAgent.addSlaveSupport(action);
                            continue block34;
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
                        finally {
                            action.nsAgent.disconnect();
                        }
                    }
                    case 4: {
                        try {
                            action.hostingAgent.connect();
                            action.hostingAgent.registerHosting(action);
                            continue block34;
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
                        finally {
                            action.hostingAgent.disconnect();
                        }
                    }
                }
                continue;
            }
            catch (Exception e) {
                this.rollback(actions, pos);
                throw e;
            }
        }
    }

    protected void rollback(List<AgentAction> actions, int pos) {
        while (pos >= 0) {
            AgentAction action = actions.get(pos);
            try {
                switch (action.type) {
                    case 3: {
                        action.nsAgent.connect();
                        action.nsAgent.deleteHost(action);
                        action.nsAgent.disconnect();
                        break;
                    }
                    case 1: 
                    case 2: {
                        action.nsAgent.connect();
                        action.nsAgent.deleteDomainSupport(action);
                        action.nsAgent.disconnect();
                        break;
                    }
                    case 4: {
                        action.hostingAgent.connect();
                        action.hostingAgent.unregisterHosting(action);
                        action.hostingAgent.disconnect();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            --pos;
        }
    }
}

