/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.CommandSubscriptionsList;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.EnigoCasCon;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.enigo.EnigoCasException;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class EnigoCasServiceActivator
extends DigitalTVServiceActivator {
    private EnigoCasCon con = null;

    private EnigoCasCon getConnection(int serverId, UserCard userCard) throws BGException {
        if (this.con == null) {
            ParameterMap moduleSetup = this.getModuleSetup(userCard);
            ParameterMap connectionSetup = moduleSetup.sub("server." + serverId + ".");
            this.con = new EnigoCasCon(connectionSetup, serverId);
        }
        return this.con;
    }

    public EnigoCasServiceActivator(ParameterMap moduleSetup, Connection conMaster, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, conMaster, conSlave, mid, time);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        EnigoCasCon con = null;
        try {
            con = this.getConnection(0, card);
            List<DigitalTVServiceActivator.CardPacketCodePair> cpcl = this.getCardPacketCodePairList(cardPacketList, false, true);
            this.smartSynchronize(con, card.getNumber(), cpcl);
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    private void smartSynchronize(EnigoCasCon con, long cardNumber, List<DigitalTVServiceActivator.CardPacketCodePair> billingSubscription) throws Exception {
        List<CommandSubscriptionsList.SubscriptionInfo> casAllSubscription = con.getSubscriptionsList(cardNumber);
        ArrayList<CommandSubscriptionsList.SubscriptionInfo> casSubscription = new ArrayList<CommandSubscriptionsList.SubscriptionInfo>();
        Date now = new Date();
        for (CommandSubscriptionsList.SubscriptionInfo casItem : casAllSubscription) {
            if (casItem.time_stop.before(now)) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("synchronize: cas.time_stop (" + String.valueOf(casItem.time_stop) + ") < now (" + String.valueOf(now) + "), ignore");
                continue;
            }
            casSubscription.add(casItem);
        }
        ArrayList<DigitalTVServiceActivator.CardPacketCodePair> toAdd = new ArrayList<DigitalTVServiceActivator.CardPacketCodePair>();
        ArrayList toCancel = new ArrayList();
        EnigoCasServiceActivator.subscribeEqualizer(billingSubscription, casSubscription, toAdd, toCancel, new CommandSubscriptionsList.SubscriptionInfoComparator());
        if (!toCancel.isEmpty()) {
            if (toCancel.equals(casSubscription)) {
                con.removeAllSubscription(cardNumber);
            } else {
                for (CommandSubscriptionsList.SubscriptionInfo c : toCancel) {
                    con.removeSubscription(cardNumber, null, c.subscription_id);
                }
            }
        }
        for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : toAdd) {
            CardPacket cardPacket = pairCardPacketPacketCode.cardpacket;
            String packetCode = pairCardPacketPacketCode.packetCode;
            Date date1 = cardPacket.getDateFrom();
            Date date2 = null;
            if (cardPacket.getDateTo() != null) {
                date2 = cardPacket.getDateTo();
            } else {
                date2 = this.graduallySubscriptionManager.getDate(cardPacket.getId());
                if (date2 == null) {
                    date2 = TimeUtils.nowPlusPeriod((int)5, (int)this.periodGraduallySubscription);
                }
            }
            date1 = TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)date1);
            date2 = TimeUtils.getEndDay((Date)date2);
            con.addSubscription(cardNumber, packetCode, date1, date2);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        this.getLogger().info("Closing card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        EnigoCasCon con = null;
        try {
            con = this.getConnection(0, card);
            this.smartSynchronize(con, card.getNumber(), Collections.emptyList());
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardNumber) throws BGException {
        this.getLogger().info("Closing card " + cardNumber);
        EnigoCasCon con = null;
        try {
            con = this.getConnection(0, null);
            this.smartSynchronize(con, cardNumber, Collections.emptyList());
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) throws BGException {
        EnigoCasCon con = null;
        try {
            if (cardNumbers == null) {
                cardNumbers = this.cardManager.getAllCardNumbers();
            }
            int sendOk = 0;
            int sendNotFound = 0;
            int sendNoActive = 0;
            int sendUnsupport = 0;
            block9: for (Long cardNumber : cardNumbers) {
                UserCard userCard = this.userCardManager.getUserCard((long)cardNumber, new Date());
                con = this.getConnection(0, userCard);
                try {
                    if (ismail) {
                        con.sendMessageMail(cardNumber, message);
                    } else {
                        con.sendMessageOsd(cardNumber, message);
                    }
                    ++sendOk;
                }
                catch (EnigoCasException e) {
                    switch (e.getErrorcode()) {
                        case 5: {
                            ++sendNotFound;
                            continue block9;
                        }
                        case 6: {
                            ++sendNoActive;
                            continue block9;
                        }
                        case 7: {
                            ++sendUnsupport;
                            continue block9;
                        }
                    }
                    throw e;
                }
            }
            String res = "\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e: " + sendOk;
            if (sendNotFound > 0) {
                res = res + ", \u043a\u0430\u0440\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + sendNotFound;
            }
            if (sendNoActive > 0) {
                res = res + ", \u043a\u0430\u0440\u0442 \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u043e: " + sendNoActive;
            }
            if (sendUnsupport > 0) {
                res = res + ", \u043a\u0430\u0440\u0442\u044b \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442: " + sendUnsupport;
            }
            return new DigitalTVServiceActivator.ServiceActivationResult(true, res, null, null);
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in sendMessagesImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    private String getContractParameter(Contract contract, UserCard userCard, String pid) throws Exception {
        if (pid == null) {
            return "";
        }
        if ("contract_title".equals(pid)) {
            return contract.getTitle();
        }
        if ("contract_comment".equals(pid)) {
            return contract.getComment();
        }
        if ("usercard_comment".equals(pid)) {
            return userCard.getComment();
        }
        if ("object_title".equals(pid)) {
            ContractObject object;
            if (userCard.getObjectId() > 0 && (object = (ContractObject)this.contractObjectDao.get(userCard.getObjectId())) != null) {
                return object.getTitle();
            }
            return "";
        }
        if (pid.startsWith("object:")) {
            int ipid = Utils.parseInt((String)(pid = pid.substring(7)), (int)-1);
            if (ipid <= 0) {
                return "";
            }
            return this.contractObjectDao.getObjectParamTitle(userCard.getObjectId(), ipid);
        }
        int ipid = Utils.parseInt((String)pid, (int)-1);
        if (ipid <= 0) {
            return "";
        }
        try (ContractParameterManager contractParameterManager = new ContractParameterManager(this.conSlave);){
            HashMap map = contractParameterManager.getValuesForPids(new HashSet<Integer>(Arrays.asList(ipid)), contract.getId());
            String string = map.containsKey(ipid) ? (String)map.get(ipid) : "";
            return string;
        }
    }

    private void smartStatus(EnigoCasCon con, long cardNumber, boolean active) throws Exception {
        String card_name = "";
        String card_cn = "";
        String card_address = "";
        String card_info = "";
        UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
        if (userCard != null) {
            Contract contract = (Contract)this.contractDao.get(userCard.getContractId());
            if (contract != null) {
                ParameterMap moduleSetup = this.getModuleSetup(userCard);
                String pidName = moduleSetup.get("parameter.name", null);
                String pidCn = moduleSetup.get("parameter.cn", null);
                String pidAddress = moduleSetup.get("parameter.address", null);
                String pidInfo = moduleSetup.get("parameter.info", null);
                card_name = this.getContractParameter(contract, userCard, pidName);
                card_cn = this.getContractParameter(contract, userCard, pidCn);
                card_address = this.getContractParameter(contract, userCard, pidAddress);
                card_info = this.getContractParameter(contract, userCard, pidInfo);
            } else {
                this.getLogger().error("contract id=" + userCard.getContractId() + " not found");
            }
        }
        con.activeStatusSmartcard(cardNumber, active, card_name, card_cn, card_address, card_info);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult activateImpl(long cardNumber, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        EnigoCasCon con = null;
        try {
            con = this.getConnection(0, card);
            this.smartStatus(con, cardNumber, true);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in activateImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult deactivateImpl(long cardNumber) throws BGException {
        EnigoCasCon con = null;
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            con = this.getConnection(0, userCard);
            this.smartStatus(con, cardNumber, false);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in deactivateImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getSubscribeInfoImpl(long cardNumber) throws BGException {
        StringBuilder infotext = new StringBuilder(64);
        String logline1 = "get subscribe card: " + cardNumber;
        this.getLogger().info(logline1);
        infotext.append(logline1).append("\n");
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            EnigoCasCon con = this.getConnection(0, userCard);
            List<CommandSubscriptionsList.SubscriptionInfo> packages = con.getSubscriptionsList(cardNumber);
            if (packages.size() == 0) {
                infotext.append("none\n");
            } else {
                infotext.append(CommandSubscriptionsList.SubscriptionInfo.getHeader()).append("\n");
                for (CommandSubscriptionsList.SubscriptionInfo info : packages) {
                    infotext.append(info.toString()).append("\n");
                }
            }
        }
        catch (EnigoCasException ex) {
            infotext.append("error: " + ex.getMessage());
        }
        catch (Exception ex) {
            this.getLogger().error("Exception getSubscribeInfoImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, infotext.toString(), null, null);
    }
}

