/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGTextDialog;

public class BGMemoryPanel
extends JPanel {
    private Thread th;
    private static final Color COLOR_MAX = new Color(192, 192, 192);
    private static final Color COLOR_TOT = new Color(160, 160, 160);
    private static final Color COLOR_USE = new Color(245, 245, 181);
    private static final int TIMEOUT = 1000;
    private boolean s = false;
    private volatile DrawMode mode = DrawMode.MEMORY;

    public BGMemoryPanel() {
        this.th = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        Thread.sleep(1000L);
                        BGMemoryPanel.this.paintImmediately(new Rectangle(0, 0, BGMemoryPanel.this.getWidth(), BGMemoryPanel.this.getHeight()));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }, "BGMemoryPanel");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && BGMemoryPanel.this.mode == DrawMode.MEMORY) {
                    System.gc();
                    System.gc();
                    System.gc();
                } else if (e.getButton() == 1 && BGMemoryPanel.this.mode == DrawMode.THREADS) {
                    BGTextDialog dialog = new BGTextDialog();
                    dialog.setPreferredSize(new Dimension(1024, 768));
                    dialog.pack();
                    dialog.setLocationRelativeTo(null);
                    dialog.getTextArea().setContentType("text/html");
                    dialog.getTextArea().setText(BGMemoryPanel.getThreadsInfo());
                    dialog.setModal(true);
                    dialog.setVisible(true);
                } else if (e.getButton() == 2) {
                    BGMemoryPanel.this.mode = BGMemoryPanel.this.mode == DrawMode.MEMORY ? DrawMode.THREADS : DrawMode.MEMORY;
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.mode == DrawMode.MEMORY) {
            this.render_memory(g);
        } else {
            this.render_threads(g);
        }
    }

    private void render_memory(Graphics g) {
        String str = Utils.memoryStatusShort();
        long useMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = totalMemory;
        }
        this.setToolTipText("use / total / max");
        int maxMemoryW = this.getWidth();
        int totalMemoryW = (int)((double)maxMemoryW * ((double)totalMemory / (double)maxMemory));
        int useMemoryW = (int)((double)maxMemoryW * ((double)useMemory / (double)maxMemory));
        g.setColor(COLOR_MAX);
        g.fillRect(0, 0, maxMemoryW, this.getHeight());
        g.setColor(COLOR_TOT);
        g.fillRect(0, 0, totalMemoryW, this.getHeight());
        g.setColor(COLOR_USE);
        g.fillRect(0, 0, useMemoryW, this.getHeight());
        g.setColor(Color.BLACK);
        int strW = g.getFontMetrics().stringWidth(str);
        int strH = g.getFontMetrics().charWidth('0');
        g.drawString(str, (this.getWidth() - strW) / 2, (this.getHeight() + strH) / 2);
        this.s = !this.s;
        if (this.s) {
            g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, 0);
        }
    }

    private void render_threads(Graphics g) {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        int NEW_count = 0;
        int RUNNABLE_count = 0;
        int BLOCKED_count = 0;
        int WAITING_count = 0;
        int TIMED_WAITING_count = 0;
        int TERMINATED_count = 0;
        for (Thread thread : threads.keySet()) {
            switch (thread.getState()) {
                case NEW: {
                    ++NEW_count;
                    break;
                }
                case RUNNABLE: {
                    ++RUNNABLE_count;
                    break;
                }
                case BLOCKED: {
                    ++BLOCKED_count;
                    break;
                }
                case WAITING: {
                    ++WAITING_count;
                    break;
                }
                case TIMED_WAITING: {
                    ++TIMED_WAITING_count;
                    break;
                }
                case TERMINATED: {
                    ++TERMINATED_count;
                }
            }
        }
        this.setToolTipText("NEW / RUNNABLE / BLOCKED / WAITING / TIMED_WAITING / TERMINATED");
        String str = NEW_count + "/" + RUNNABLE_count + "/" + BLOCKED_count + "/" + WAITING_count + "/" + TIMED_WAITING_count + "/" + TERMINATED_count;
        int maxCountW = this.getWidth();
        g.setColor(COLOR_MAX);
        g.fillRect(0, 0, maxCountW, this.getHeight());
        g.setColor(Color.BLACK);
        int strW = g.getFontMetrics().stringWidth(str);
        int strH = g.getFontMetrics().charWidth('0');
        g.drawString(str, (this.getWidth() - strW) / 2, (this.getHeight() + strH) / 2);
        this.s = !this.s;
        if (this.s) {
            g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, 0);
        }
    }

    private static String getThreadsInfo() {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html><table>");
        for (Map.Entry<Thread, StackTraceElement[]> entry : threads.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] stes = entry.getValue();
            tooltip.append("<tr><td><b>").append(thread.getName());
            if (thread.isDaemon()) {
                tooltip.append(" (daemon)");
            }
            tooltip.append("</b></td><td><b>").append(thread.getPriority()).append("</b></td><td><b>").append((Object)thread.getState()).append("</b></td></tr>");
            tooltip.append("<tr><td colspan='3'>");
            for (StackTraceElement ste : stes) {
                tooltip.append(ste).append("<br>");
            }
            tooltip.append("</td></tr>");
        }
        tooltip.append("</table></html>");
        return tooltip.toString();
    }

    public void start() {
        this.th.start();
    }

    static enum DrawMode {
        MEMORY,
        THREADS;

    }
}

