/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.dhcp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.dhcp.DHCPChecker;
import ru.bitel.bgbilling.kernel.wifi.dhcp.RelayThread;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class DHCPListener
extends Thread {
    private static Logger log = LogManager.getLogger();
    private DatagramSocket socket = null;
    private ThreadPoolExecutor pool;
    private String agentHost = null;
    private DHCPChecker checker = null;
    private List<Pair<String, Integer>> hostPorts = new ArrayList<Pair<String, Integer>>();

    public void init(int agentPort, DHCPChecker checker) {
        Setup setup = GlobalConfig.getGlobalConfig().getSetup();
        try {
            this.socket = new DatagramSocket(agentPort);
            int minCount = setup.getInt("dhcp.minThreadCount", 10);
            int maxCount = setup.getInt("dhcp.maxThreadCount", 10);
            this.pool = new ThreadPoolExecutor(minCount, maxCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.agentHost = setup.get("dhcp.agent.host", null);
            ParameterMap values = setup.sub("dhcp.servers.");
            for (Map.Entry<String, String> entry : values.entrySet()) {
                String longKey = entry.getKey();
                String key = longKey.substring(0, longKey.indexOf("."));
                Integer idx = Integer.valueOf(key);
                if (this.hostPorts.size() < idx) {
                    for (int i = this.hostPorts.size(); i < idx; ++i) {
                        Pair pair = new Pair();
                        this.hostPorts.add(pair);
                    }
                }
                Pair<String, Integer> pair = this.hostPorts.get(idx - 1);
                String suffix = longKey.substring(longKey.indexOf(".") + 1);
                if (suffix.equals("host")) {
                    pair.setFirst(entry.getValue());
                    continue;
                }
                if (!suffix.equals("port")) continue;
                pair.setSecond(Utils.parseInt(entry.getValue(), 67));
            }
            if (this.hostPorts.size() == 0) {
                Pair<String, Integer> pair = new Pair<String, Integer>(setup.get("dhcp.server.host", null), setup.getInt("dhcp.server.port", 67));
                this.hostPorts.add(pair);
            }
            this.checker = checker;
        }
        catch (SocketException e) {
            log.error("error init DHCPListener", (Throwable)e);
        }
    }

    @Override
    public void run() {
        if (this.socket == null) {
            return;
        }
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[4096];
                    DatagramPacket inPacket = new DatagramPacket(buf, buf.length);
                    this.socket.receive(inPacket);
                    log.info(" packet recieved");
                    RelayThread thread = new RelayThread();
                    thread.init(buf, this.socket, this.agentHost, this.checker, this.hostPorts);
                    while (this.pool.getMaximumPoolSize() == this.pool.getActiveCount()) {
                        Thread.sleep(200L);
                        log.warn("Relay agent : Wating for free Thread..");
                    }
                    this.pool.execute(thread);
                }
            }
            catch (Exception e) {
                log.error("error DHCPListener", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

