/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.WarehouseOperationEntry;
import ru.bitel.bgbilling.plugins.shop.common.bean.WarehouseOperationType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class WarehouseOperationEntryDao
extends AbstractIdDao<WarehouseOperationEntry> {
    public WarehouseOperationEntryDao(Connection con, int moduleId) {
        super(con, moduleId, "warehouse_operation");
    }

    protected WarehouseOperationEntry getFromRS(ResultSet rs) throws SQLException, BGException {
        WarehouseOperationEntry entry = new WarehouseOperationEntry(WarehouseOperationType.define((int)rs.getInt("operation_type")));
        entry.setId(rs.getInt("id"));
        entry.setTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("operation_time")));
        entry.setUserId(rs.getInt("user_id"));
        entry.setContractId(rs.getInt("contract_id"));
        entry.setWarehouseFromId(rs.getInt("warehouse_from_id"));
        entry.setWarehouseToId(rs.getInt("warehouse_to_id"));
        entry.setStockItemId(rs.getInt("stock_item_id"));
        entry.setStockItemTypeTitle(rs.getString("stock_item_type_title"));
        return entry;
    }

    protected void updateImpl(WarehouseOperationEntry entry) throws BGException, SQLException {
        String prefix = entry.getId() > 0 ? "UPDATE " : "INSERT INTO ";
        String query = prefix + this.tableName + " SET operation_time=NOW(), user_id=?, contract_id=?, warehouse_from_id=?, warehouse_to_id=?, stock_item_id=?, stock_item_type_title=?, operation_type=?" + (entry.getId() > 0 ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, entry.getUserId());
            ps.setInt(index++, entry.getContractId());
            ps.setInt(index++, entry.getWarehouseFromId());
            ps.setInt(index++, entry.getWarehouseToId());
            ps.setInt(index++, entry.getStockItemId());
            ps.setString(index++, entry.getStockItemTypeTitle());
            ps.setInt(index++, entry.getOperationType().ordinal());
            if (entry.getId() > 0) {
                ps.setInt(index, entry.getId());
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchOperations(SearchResult<WarehouseOperationEntry> searchResult) throws BGException {
        ArrayList<WarehouseOperationEntry> result = new ArrayList<WarehouseOperationEntry>();
        searchResult.setList(result);
        WarehouseOperationType operationType = WarehouseOperationType.define((int)Utils.parseInt((String)searchResult.getAttribute("operationType"), (int)-1));
        int contractId = Utils.parseInt((String)searchResult.getAttribute("contractId"), (int)0);
        int warehouseId = Utils.parseInt((String)searchResult.getAttribute("warehouseId"), (int)0);
        int userId = Utils.parseInt((String)searchResult.getAttribute("userId"), (int)0);
        Period period = searchResult.getPeriod();
        Page page = searchResult.getPage();
        StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS * FROM ").append(this.tableName).append(" WHERE 1=1");
        if (operationType != null) {
            query.append(" AND operation_type=?");
        }
        if (contractId > 0) {
            query.append(" AND contract_id=?");
        }
        if (warehouseId > 0) {
            query.append(" AND (warehouse_from_id=? OR warehouse_to_id=?)");
        }
        if (userId > 0) {
            query.append(" AND user_id=?");
        }
        if (period != null) {
            if (period.getDateFrom() != null) {
                query.append(" AND operation_time>=?");
            }
            if (period.getDateTo() != null) {
                query.append(" AND operation_time<=?");
            }
        }
        query.append(this.sqlLimit(page));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            if (operationType != null) {
                ps.setInt(index++, operationType.ordinal());
            }
            if (contractId > 0) {
                ps.setInt(index++, contractId);
            }
            if (warehouseId > 0) {
                ps.setInt(index++, warehouseId);
                ps.setInt(index++, warehouseId);
            }
            if (userId > 0) {
                ps.setInt(index++, userId);
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

