/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.collector;

import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgent;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Array;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.modules.inet.server.collector.FlowListenerWorker;
import ru.bitel.bgbilling.modules.inet.server.collector.FlowListenerWorkerContext;

public class FlowListenerWorkerNetFlow9
extends FlowListenerWorker<NetFlow9Array> {
    private ConcurrentMap<Integer, NetFlow9Template> templates;

    public FlowListenerWorkerNetFlow9(long millis, List<FlowPacket> packetList, int overloadLevel, ConcurrentMap<Integer, NetFlow9Template> templates) {
        super(millis, packetList, overloadLevel);
        this.templates = templates;
    }

    @Override
    public void processPacket(Accounting accounting, InetAddress agentAddress, FlowAgent flowAgent, FlowPacket packet, long now) {
        NetFlow9Array netFlowArray = (NetFlow9Array)((FlowListenerWorkerContext)this.context).flowArray;
        if (netFlowArray.parsePacket(packet.data, now, this.templates)) {
            Long hour = now / 3600000L * 3600000L;
            this.processPacketImpl(accounting, agentAddress, flowAgent, packet, (FlowArray<Data>)netFlowArray, now, now, hour);
        }
    }
}

