/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.apps;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsAbstractAction;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsContext;
import ru.bitel.bgbilling.kernel.base.server.wrapper.MultipartWrapper;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceFactory;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;

public abstract class ActionAbstract
extends AppsAbstractAction {
    protected BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
    protected HelpdeskService helpdeskService = null;

    public void setContext(AppsContext appsContext) {
        super.setContext(appsContext);
        try {
            this.helpdeskService = (HelpdeskService)ServiceFactory.newService(HelpdeskService.class, (int)0);
        }
        catch (BGException ex) {
            this.logError(ex);
        }
    }

    protected List<BGServerFile> fileUploadRequest(Message message) throws BGException {
        ArrayList<BGServerFile> fileList = new ArrayList<BGServerFile>();
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
        if (!(this.request instanceof MultipartWrapper)) {
            return fileList;
        }
        MultipartWrapper multi = (MultipartWrapper)this.request;
        Set files = multi.getFileNames();
        for (String name : files) {
            String filename = multi.getFilesystemName(name);
            File f = multi.getFile(name);
            if (f == null) continue;
            BGServerFile documentFile = new BGServerFile();
            documentFile.setOwnerId(message.getId());
            documentFile.setTitle(filename);
            documentFile.setSize(f.length());
            documentFile.setComment("message #" + message.getId());
            documentFile.setDate(new Date());
            documentFile.setUserId(0);
            fileStorage.updateFile(documentFile);
            if (documentFile.getId() > 0) {
                try {
                    fileStorage.saveStream(documentFile.getId(), new FileInputStream(f));
                }
                catch (Exception e) {
                    fileStorage.deleteFile(documentFile.getId());
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n" + e.getLocalizedMessage());
                }
                fileList.add(documentFile);
                continue;
            }
            this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0411\u0414");
        }
        return fileList;
    }
}

