/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.edo.common.bean.Document;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class DocumentDao
extends AbstractIdDao<Document> {
    public DocumentDao(Connection con) {
        super(con, 0, "edo_document");
    }

    public List<Document> getListAll() throws SQLException {
        return this.list(null, "id", new Object[0]);
    }

    protected Document getFromRS(ResultSet rs) throws SQLException {
        Document document = new Document();
        document.setId(rs.getInt(this.tableName + ".id"));
        document.setTitle(rs.getString(this.tableName + ".title"));
        document.setClazz(rs.getString(this.tableName + ".class"));
        document.setConfig(rs.getString(this.tableName + ".config"));
        String signatory_ids = rs.getString(this.tableName + ".signatory_ids");
        document.setSignatoryIds(Utils.notBlankString((String)signatory_ids) ? Utils.toIntegerList((String)signatory_ids) : null);
        return document;
    }

    protected void updateImpl(Document document) throws SQLException {
        String querySet = "title=?, class=?, config=?, signatory_ids=?";
        try (PreparedStatement ps = this.prepareStatement((Id)document, querySet);){
            int index = 1;
            ps.setString(index++, document.getTitle());
            ps.setString(index++, document.getClazz());
            ps.setString(index++, document.getConfig());
            if (Utils.notEmptyCollection((Collection)document.getSignatoryIds())) {
                ps.setString(index++, Utils.toString((Iterable)document.getSignatoryIds()));
            } else {
                ps.setNull(index++, 12);
            }
            this.executeUpdate((Id)document, index, ps);
        }
    }
}

