/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.utils;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.server.bean.DebetStatusManageConfig;
import ru.bitel.bgbilling.modules.npay.server.bean.object.ServiceObjectManager;
import ru.bitel.bgbilling.modules.npay.server.task.Calculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class NpayUtils {
    private static final Logger logger = LogManager.getLogger();

    public static BigDecimal getAmountForUnlock(Connection con, int moduleId, int contractId) throws Exception {
        DebetStatusManageConfig config = DebetStatusManageConfig.getConfig(moduleId, new ContractLabelManager(con).getContractLabelIds(contractId));
        if (config.isEnable()) {
            return NpayUtils.getAmountForUnlock(con, moduleId, contractId, config, new ContractManager(con), new ContractLabelManager(con));
        }
        return null;
    }

    public static BigDecimal getAmountForUnlock(Connection con, int moduleId, int contractId, DebetStatusManageConfig config, ContractManager contractManager, ContractLabelManager contractLabelManager) throws Exception {
        if (config.isEnable()) {
            Contract contract = contractManager.getContractById(contractId);
            if (config.isEnableForContractLabelIds(contractLabelManager.getContractLabelIds(contractId)) && (!config.isCheckServiceObjectList() || new ServiceObjectManager(con, moduleId).getServiceObjectList(contractId, null).size() > 0)) {
                try {
                    return config.getSummaForUnlock(con, moduleId, contract);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public static ServiceCostCache precalculateServiceCost(int moduleId, int serviceSet, int contractId, Date dateFrom, Date dateTo, int status) throws BGException {
        Calculator calculator = new Calculator();
        calculator.setPreCalc(status);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + moduleId + "\nservice.set=" + serviceSet);
        calculator.setContractIds(Arrays.asList(contractId));
        calculator.setActiveFromDate(TimeUtils.convertDateToCalendar((Date)dateFrom));
        calculator.setExecutingTime(TimeUtils.convertDateToCalendar((Date)dateTo));
        calculator.runLocal();
        return calculator.getCostCache();
    }

    public static BigDecimal precalculateAccount(int moduleId, int serviceSet, int contractId, Date dateFrom, Date dateTo, int status) throws BGException {
        ServiceCostCache serviceCostCache = NpayUtils.precalculateServiceCost(moduleId, serviceSet, contractId, dateFrom, dateTo, status);
        return (BigDecimal)serviceCostCache.getContractAccounts().get(contractId);
    }

    public static BigDecimal getServiceCost(int moduleId, int contractId, int serviceId, Date dateFrom, Date dateTo, int status) throws BGException {
        Calculator calculator = new Calculator();
        calculator.setPreCalc(status);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + moduleId + "\nservice.set=0");
        calculator.setContractIds(Arrays.asList(contractId));
        calculator.setActiveFromDate(TimeUtils.convertDateToCalendar((Date)dateFrom));
        calculator.setExecutingTime(TimeUtils.convertDateToCalendar((Date)dateTo));
        calculator.setServiceObjectList(Arrays.asList(ServiceObject.builder().setContractId(contractId).setServiceId(serviceId).setCol(BigDecimal.ONE).setDate1(dateFrom).setDate2(dateTo).build()));
        calculator.runLocal();
        return (BigDecimal)calculator.getCostCache().getContractAccounts().get(contractId);
    }
}

