/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.action;

import bitel.billing.server.tariff.voice.action.base.ActionBase;
import bitel.billing.server.tariff.voice.bean.Zone;
import bitel.billing.server.tariff.voice.bean.ZoneManager;
import bitel.billing.server.tariff.voice.bean.ZoneMapItem;
import bitel.billing.server.tariff.voice.bean.ZoneMapItemManager;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.Utils;

public class ActionZoneMapItemUpdate
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        String _codes = this.getParameter("codes");
        int mapId = this.getIntParameter("map_id", 0);
        if (this.mid <= 0 || mapId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (Utils.isEmptyString((String)_codes)) {
            return;
        }
        int zoneId = this.getIntParameter("zone_id", -1);
        int levelStart = this.getIntParameter("level_start", -1);
        int levelEnd = this.getIntParameter("level_end", -1);
        String[] codes = _codes.split("\\s*,\\s*");
        ZoneMapItemManager man = new ZoneMapItemManager(this.con, this.mid);
        Element zoneEl = this.createElement(this.rootNode, "zone");
        ZoneMapItem item = new ZoneMapItem();
        item.setMapId(mapId);
        if (zoneId >= 0) {
            item.setZoneId(zoneId);
            for (String code : codes) {
                item.setGCode(code);
                man.updateItem(item);
            }
            if (zoneId > 0) {
                Zone zone = new ZoneManager(this.con, this.mid).getZone(zoneId);
                zoneEl.setAttribute("id", String.valueOf(zone.getId()));
                zoneEl.setAttribute("title", zone.getTitle());
            }
        }
        if (levelStart >= 0) {
            item.setLevelStart(levelStart);
            for (String code : codes) {
                item.setGCode(code);
                man.updateItemLevel(item, true);
            }
        }
        if (levelEnd >= 0) {
            item.setLevelEnd(levelEnd);
            for (String code : codes) {
                item.setGCode(code);
                man.updateItemLevel(item, false);
            }
        }
    }
}

