/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.flowtools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.flowtools.FlowToolsLog;
import ru.bitel.bgbilling.kernel.network.datalog.flowtools.FlowToolsLogRecord;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;

public class FlowToolsLogReader
extends DataLogReader<FlowToolsLog>
implements FlowReader {
    private static final Logger log = LogManager.getLogger();
    protected final int recordSize;
    protected final FlowArray<FlowToolsLogRecord> recordList;

    protected FlowToolsLogReader(FlowToolsLog dataLog, ByteBuffer readBuffer) {
        super(dataLog, readBuffer);
        this.readBuffer.position(this.readBuffer.capacity());
        this.recordSize = dataLog.recordSize;
        int size = this.readBuffer.capacity() / this.recordSize;
        ArrayList<FlowToolsLogRecord> recordList = new ArrayList<FlowToolsLogRecord>(size);
        for (int i = 0; i < size; ++i) {
            recordList.add(new FlowToolsLogRecord());
        }
        this.recordList = new FlowArray(recordList);
    }

    public FlowArray<FlowToolsLogRecord> readChunk() {
        try {
            if (this.readBuffer(this.readBuffer) == -1) {
                return null;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        int remainingRecordCount = this.readBuffer.remaining() / this.recordSize;
        for (int i = 0; i < remainingRecordCount; ++i) {
            FlowToolsLogRecord rec = ((FlowToolsLogRecord[])this.recordList.array)[i];
            int position = i * this.recordSize;
            rec.fillData(this.readBuffer, position + 16);
            rec.milliseconds = ((long)this.readBuffer.getInt(position) & 0xFFFFFFFFL) * 1000L;
        }
        this.readBuffer.position(remainingRecordCount * this.recordSize);
        this.recordList.size = remainingRecordCount;
        return this.recordList;
    }
}

