/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean.pattern;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.AbstractDocumentProcessor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentPatternUtils;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentProcessor;
import ru.bitel.bgbilling.server.util.Setup;

public class XlsxDocumentProcessor
extends AbstractDocumentProcessor
implements DocumentProcessor {
    XlsxDocumentProcessor(Connection con, Document document, DocumentPattern pattern, Map<String, Object> varData) {
        this.document = document;
        this.variableData = varData;
        this.con = con;
        this.pattern = pattern;
    }

    @Override
    public File process(FileInputStream patternInputStream) throws BGException {
        File tempDocumentFile;
        block16: {
            tempDocumentFile = new File(Setup.getSetup().getTempDirPath() + "tmp" + this.document.getContractId() + ".xlsx");
            try {
                this.getLogger().debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 XLSX-\u0448\u0430\u0431\u043b\u043e\u043d\u0430");
                try (XSSFWorkbook workbook = new XSSFWorkbook((InputStream)patternInputStream);){
                    for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                        XSSFSheet sheet = workbook.getSheetAt(i);
                        int rowStart = sheet.getFirstRowNum();
                        int rowEnd = sheet.getLastRowNum();
                        for (int j = rowStart; j <= rowEnd; ++j) {
                            XSSFRow row = sheet.getRow(j);
                            if (row == null) continue;
                            int cellStart = row.getFirstCellNum();
                            short cellEnd = row.getLastCellNum();
                            if (cellStart < 0) continue;
                            for (int k = cellStart; k <= cellEnd; ++k) {
                                XSSFCell cell = row.getCell(k, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                                if (cell == null || cell.getCellType() != CellType.STRING) continue;
                                String cellText = cell.getStringCellValue();
                                List<String> varList = DocumentPatternUtils.getKeysFromString(cellText);
                                for (String varName : varList) {
                                    cellText = DocumentPatternUtils.replaceText(cellText, varName, (String)this.variableData.get(varName));
                                }
                                cell.setCellValue(cellText);
                            }
                        }
                    }
                    if (!tempDocumentFile.createNewFile()) break block16;
                    try (FileOutputStream fos = new FileOutputStream(tempDocumentFile);){
                        workbook.write((OutputStream)fos);
                    }
                    this.getLogger().debug("\u0421\u043e\u0437\u0434\u0430\u043d \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b {}", (Object)tempDocumentFile.getName());
                }
            }
            catch (IOException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return tempDocumentFile;
    }
}

