/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.event;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.kernel.event.common.PoolEvent;
import ru.bitel.common.SerialUtils;

@XmlRootElement
public class ContractBalanceChangedEvent
extends PoolEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(ContractBalanceChangedEvent.class);
    public static final int TYPE_ACCOUNT_CHANGE = 1;
    public static final int TYPE_ACCOUNT_SET = 2;
    public static final int TYPE_PAYMENT_CHANGE = 3;
    public static final int TYPE_CHARGE_CHANGE = 4;
    public static final int RESERVE_CHANGE = 5;
    public static final int RESERVE_CLOSE = 6;
    @XmlAttribute
    private final int type;
    @XmlAttribute
    private final int year;
    @XmlAttribute
    private final int month;
    @XmlAttribute
    private final BigDecimal summa;

    protected ContractBalanceChangedEvent() {
        this.type = -1;
        this.year = -1;
        this.month = -1;
        this.summa = null;
    }

    public ContractBalanceChangedEvent(int contractId, int type, int year, int month, BigDecimal summa) {
        super(0, contractId, -1);
        this.type = type;
        this.year = year;
        this.month = month;
        this.summa = summa;
    }

    public ContractBalanceChangedEvent(int contractId, int type, Date date, BigDecimal summa) {
        super(0, contractId, -1);
        this.type = type;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.summa = summa;
    }

    @Deprecated
    public ContractBalanceChangedEvent(int contractId, BigDecimal summa) {
        this(contractId, 3, summa);
    }

    public ContractBalanceChangedEvent(int contractId, int type, BigDecimal summa) {
        super(0, contractId, -1);
        this.type = type;
        this.year = -1;
        this.month = -1;
        this.summa = summa;
    }

    public int getType() {
        return this.type;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public BigDecimal getSumma() {
        return this.summa;
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append("; type: ");
        sb.append(this.type);
        sb.append("; year: ");
        sb.append(this.year);
        sb.append("; month: ");
        sb.append(this.month);
        sb.append("; summa: ");
        sb.append(this.summa);
    }
}

