/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.task;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.common.bean.Transaction;
import ru.bitel.bgbilling.modules.assist.server.RecurringRequest;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistUtils;
import ru.bitel.bgbilling.modules.assist.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestOrder;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolTransfer;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolTransferException;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;

public class AssistRecurringTask
extends TaskBase {
    private int m_cid = -1;
    private BigDecimal m_sum = null;

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Assist. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0440\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + (String)(this.m_cid > 0 ? ". \u041f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 #" + this.m_cid + " \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 " + this.m_sum.toPlainString() : ". \u041f\u043e \u0432\u0441\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c") + ".";
    }

    protected boolean initTask() {
        return true;
    }

    public void setManualRecurring(int contractId, BigDecimal sum) {
        this.m_cid = contractId;
        this.m_sum = sum;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection conSlave = this.setup.getDBSlaveConnectionFromPool();){
            this.getLogger().info("Do recurring...");
            this.doRecurring(con, conSlave, this.getOperatingTime());
        }
        catch (Exception e) {
            this.getLogger().error("error assist recurring task", (Throwable)e);
            this.error = e;
        }
    }

    private void doRecurring(Connection con, Connection conSlave, Calendar time) throws Exception {
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        TransactionManager pmanager = new TransactionManager(con, this.moduleId);
        AssistPaymentRecurringManager prmanager = new AssistPaymentRecurringManager(con, this.moduleId);
        String Merchant_ID = moduleSetup.get("assist.Merchant_ID", null);
        String login = moduleSetup.get("assist.login", null);
        String password = moduleSetup.get("assist.password", null);
        AssistProtocolTransfer atransfer = new AssistProtocolTransfer(Merchant_ID, login, password);
        String recurringRequestClass = moduleSetup.get("assist.recurring.request.class");
        RecurringRequest dynRecurringRequestClass = null;
        if (recurringRequestClass != null) {
            dynRecurringRequestClass = (RecurringRequest)DynamicClassManager.getInstance().newInstance(RecurringRequest.class, recurringRequestClass);
        }
        List<AssistPaymentRecurring> recList = prmanager.getRecurringList(this.m_cid);
        if (this.m_cid > 0 && recList.isEmpty()) {
            this.getLogger().error("\u0420\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 #" + this.m_cid + " \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        for (AssistPaymentRecurring pr : recList) {
            int contractId = pr.getContractId();
            if (this.m_cid > 0) {
                this.getLogger().info("recurring: cid=" + contractId + ", \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0430 \u0430\u0432\u0442\u043e\u043e\u043f\u043b\u0430\u0442\u0430, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0430 \u0434\u0430\u0442\u044b \u043d\u0435 \u0434\u0435\u043b\u0430\u0435\u0442\u0441\u044f");
            } else {
                if (!this.isTimeHasCome(contractId, pmanager, prmanager, pr, time)) {
                    this.getLogger().info("recurring: cid=" + contractId + ", \u0432\u0440\u0435\u043c\u044f \u043d\u0435 \u043f\u0440\u0438\u0448\u043b\u043e, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f");
                    continue;
                }
                this.getLogger().info("recurring: cid=" + contractId + ", \u0434\u0435\u043b\u0430\u0435\u0442\u0441\u044f \u043f\u043b\u0430\u0442\u0451\u0436...");
            }
            boolean dynCodeReturn = true;
            if (dynRecurringRequestClass != null) {
                dynCodeReturn = dynRecurringRequestClass.request(pr, this.m_sum);
            }
            if (!dynCodeReturn || pr.getAmount() == null || pr.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            Transaction transaction = pmanager.addPayment(contractId, pr.getAmount(), pr.getOrdernumber());
            String orderComment = AssistUtils.getPaymentDesc(con, moduleSetup.get("assist.OrderCommentRecurring", ""), contractId);
            AssistProtocolRequestOrder paymentOrder = null;
            try {
                this.getLogger().info("recurring: cid=" + contractId + ", send recurring request: Billnumber=" + pr.getBillnumber() + ", orderId=" + transaction.getId() + ", Amount=" + String.valueOf(pr.getAmount()));
                paymentOrder = atransfer.doRecurring(pr.getBillnumber(), transaction.getId(), pr.getAmount(), orderComment);
                this.getLogger().info("recurring: cid=" + contractId + ", send recurring request success: " + paymentOrder.toString());
            }
            catch (AssistProtocolTransferException e) {
                this.getLogger().error("recurring: cid=" + contractId + ", error send recurring request", (Throwable)e);
            }
        }
    }

    private boolean isTimeHasCome(int contractId, TransactionManager pmanager, AssistPaymentRecurringManager prmanager, AssistPaymentRecurring pr, Calendar now) throws Exception {
        Calendar date_next;
        Calendar date_now;
        Transaction payment = pmanager.getLastRecurringForCid(contractId, pr.getOrdernumber());
        Date lastDate = null;
        if (payment != null) {
            this.getLogger().debug("  last recurring payment for cid=" + contractId + ", parent_order=" + pr.getOrdernumber() + " : " + payment.toString());
            lastDate = payment.getCreateDate();
        } else {
            this.getLogger().debug("  this is first recurring payment for cid=" + contractId + ", parent_order=" + pr.getOrdernumber());
            lastDate = pr.getDate();
        }
        int recPeriod = pr.getRecurringPeriod();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("  last_date=" + TimeUtils.format((Date)lastDate, (String)"dd.MM.yyyy HH:mm:ss") + ", now=" + TimeUtils.format((Calendar)now, (String)"dd.MM.yyyy HH:mm:ss") + ", period=" + recPeriod);
        }
        Date nextDate = null;
        if (recPeriod == 31) {
            nextDate = TimeUtils.plusPeriod((Date)lastDate, (int)2, (int)1);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("  next_date = last_date + 1_month = " + TimeUtils.format((Date)nextDate, (String)"dd.MM.yyyy HH:mm:ss"));
            }
        } else {
            nextDate = TimeUtils.plusPeriod((Date)lastDate, (int)5, (int)recPeriod);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("  next_date = last_date + " + recPeriod + "_days = " + TimeUtils.format((Date)nextDate, (String)"dd.MM.yyyy HH:mm:ss"));
            }
        }
        boolean result = (date_now = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)now)).compareTo(date_next = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)TimeUtils.convertDateToCalendar((Date)nextDate))) >= 0;
        this.getLogger().debug("  date_now >= date_next (" + TimeUtils.format((Calendar)date_now, (String)"dd.MM.yyyy HH:mm:ss") + " >= " + TimeUtils.format((Calendar)date_next, (String)"dd.MM.yyyy HH:mm:ss") + "): " + result);
        return result;
    }
}

