/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.uniteller.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Date;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.uniteller.common.bean.Transaction;
import ru.bitel.bgbilling.modules.uniteller.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.uniteller.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.uniteller.server.bean.Constants;
import ru.bitel.bgbilling.modules.uniteller.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.uniteller.server.event.UnitellerSumEvent;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("uniteller");
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = SearchParam.builder().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL)).build();
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction(searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        boolean fiscalization = this.moduleSetup.getBoolean("uniteller.fiscalization.enable", false);
        String gateUrl = fiscalization ? this.moduleSetup.get("uniteller.fiscalization.url.gate", "https://fpay.uniteller.ru/v2/") : this.moduleSetup.get("uniteller.url.gate", "https://wpay.uniteller.ru/");
        this.setResultParam("gateUrl", gateUrl + "pay");
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    public void success() throws Exception {
        this.execute();
    }

    public void fail() throws Exception {
        this.execute();
    }

    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        UnitellerSumEvent event = new UnitellerSumEvent(this.moduleId, this.contractId, this.sum);
        BigDecimal newSum = ((UnitellerSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
        if (newSum != null) {
            this.sum = newSum;
        }
        this.doRedirect(this.sum, 0);
    }

    public void autopayment() throws Exception {
        int mode;
        boolean autopaymentEnable;
        super.autopayment();
        if (this.context.getRequest().getParameter("contentType") == null) {
            this.setResultParam("contentType", ActionResultContentType.json);
        }
        if ((autopaymentEnable = this.moduleSetup.getBoolean("uniteller.autopayment.enable", false)) && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = Autopayment.builder().setContractId(this.contractId).setModeData("").build();
            }
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK.getCode()) {
                this.autopaymentWeek("UNITELLER", modeDataMap, autopayment, Constants.class);
            } else if (mode == AutopaymentMode.MONTH.getCode()) {
                this.autopaymentMonth("UNITELLER", modeDataMap, autopayment, Constants.class);
            } else if (mode == AutopaymentMode.AUTO.getCode()) {
                this.autopaymentAuto("UNITELLER", modeDataMap, autopayment, Constants.class);
            }
            this.setResultParam("mode", autopayment.getMode().getCode());
            autopaymentManager.updateAutopayment(autopayment);
            if (autopayment.getMode().getCode() != AutopaymentMode.OFF.getCode()) {
                this.doRedirect(autopayment.getSum(), autopayment.getId());
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            if (autopayment.getMode().getCode() == AutopaymentMode.OFF.getCode()) {
                this.execute();
            }
        }
    }

    private void doRedirect(BigDecimal sum, int autopaymentId) throws Exception {
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        String description = "";
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        description = this.moduleSetup.get("uniteller.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(this.contractId)).setCreateDate(new Date())).setTransactionId(String.valueOf(System.currentTimeMillis() + (long)(100.0 * Math.random())))).setParameters(autopaymentId > 0 ? "autopaymentId=" + autopaymentId : null)).build();
        transactionManager.update(transaction);
        this.setResultParam("Shop_IDP", this.moduleSetup.get("uniteller.point.id", ""));
        this.setResultParam("Order_IDP", String.valueOf(transaction.getTransactionId()));
        this.setResultParam("Subtotal_P", transactionManager.getFormatSum(sum));
        this.setResultParam("Lifetime", this.moduleSetup.get("uniteller.lifetime", String.valueOf(3600)));
        this.setResultParam("Comment", description);
        this.setResultParam("URL_RETURN_OK", this.moduleSetup.get("uniteller.url.return.ok", ""));
        this.setResultParam("URL_RETURN_NO", this.moduleSetup.get("uniteller.url.return.no", ""));
        this.setResultParam("CallbackFields", this.moduleSetup.get("uniteller.callback.fields", "AcquirerID ApprovalCode BillNumber Card_IDP CardNumber Customer_IDP PaymentType Total"));
        if (autopaymentId > 0) {
            this.setResultParam("IsRecurrentStart", "1");
        }
        String receiptSignature = null;
        String receipt = null;
        if (this.moduleSetup.getBoolean("uniteller.fiscalization.enable", false)) {
            receipt = transactionManager.getReceipt(sum, this.req.get("customerAddress"), contract.getTitle());
            try {
                this.setResultParam("Receipt", Base64.getEncoder().encodeToString(receipt.getBytes("UTF-8")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            receiptSignature = transactionManager.getReceiptSignature(this.getResultParam("Shop_IDP"), this.getResultParam("Order_IDP"), this.getResultParam("Subtotal_P"), this.getResultParam("Receipt"));
            this.setResultParam("ReceiptSignature", receiptSignature);
        }
        String signature = new StringBuffer().append(Utils.getDigest((String)String.valueOf(this.getResultParam("Shop_IDP")), (String)"ASCII").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(this.getResultParam("Order_IDP")), (String)"ASCII").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(this.getResultParam("Subtotal_P")), (String)"ASCII").toLowerCase()).append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append(Utils.getDigest((String)String.valueOf(this.getResultParam("Lifetime")), (String)"ASCII").toLowerCase()).append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append("d41d8cd98f00b204e9800998ecf8427e").append("&").append(Utils.getDigest((String)this.moduleSetup.get("uniteller.password", ""), (String)"ASCII").toLowerCase()).toString();
        this.setResultParam("Signature", Utils.getDigest((String)signature, (String)"ASCII"));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Shop_IDP: " + String.valueOf(this.getResultParam("Shop_IDP")));
            this.getLogger().debug("Order_IDP: " + String.valueOf(this.getResultParam("Order_IDP")));
            this.getLogger().debug("Subtotal_P: " + String.valueOf(this.getResultParam("Subtotal_P")));
            this.getLogger().debug("Lifetime: " + String.valueOf(this.getResultParam("Lifetime")));
            this.getLogger().debug("Comment: " + String.valueOf(this.getResultParam("Comment")));
            this.getLogger().debug("URL_RETURN_OK: " + String.valueOf(this.getResultParam("URL_RETURN_OK")));
            this.getLogger().debug("URL_RETURN_NO: " + String.valueOf(this.getResultParam("URL_RETURN_NO")));
            this.getLogger().debug("CallbackFields: " + String.valueOf(this.getResultParam("CallbackFields")));
            this.getLogger().debug("Signature: " + String.valueOf(this.getResultParam("Signature")) + " => " + signature);
            if (this.moduleSetup.getBoolean("uniteller.fiscalization.enable", false)) {
                this.getLogger().debug("Receipt: " + String.valueOf(this.getResultParam("Receipt")) + " => " + receipt);
                this.getLogger().debug("ReceiptSignature: " + String.valueOf(this.getResultParam("ReceiptSignature")) + " => " + receiptSignature);
            }
        }
    }
}

