/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.nas;

import java.net.InetAddress;
import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasScript;
import ru.bitel.bgbilling.kernel.network.radius.nas.RadiusFanout;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Idable;
import ru.bitel.common.sql.ConnectionSet;

public class Nas<C extends NasConnection<?>, S extends Preferences, P extends RadiusProcessor<C, ?, ?>>
extends BGLogger
implements Idable {
    protected final S setup;
    protected final P processor;
    private final int id;
    private final InetAddress nasIPAddress;
    private final String nasIdentifier;
    private final int vendorCode;
    private final ParameterMap conf;
    private final byte[] secret;
    private final NasScript script;
    private final Map<Integer, RadiusAttributeSet> attributeSetMap;
    private final Map<String, RadiusAttributeSet> realmAttributeMap;
    protected final ConcurrentMap<Object, C> connections;
    protected final Set<Integer> activateServices = new HashSet<Integer>();
    protected final NasConnectionInspector inspector;
    protected final RadiusFanout fanout;
    private final boolean mppeAddTypesAndPolicy;
    private final String digestRealm;
    private final String digestQop;
    public static final int RESPONSE_SEND_MODE_SYNC = 0;
    public static final int RESPONSE_SEND_MODE_ASYNC_UPDATE = 1;
    public static final int RESPONSE_SEND_MODE_ASYNC_ALL = 2;
    private final int responseSendMode;
    private final boolean checkMessageAuthenticator;

    public Nas(S setup, int moduleId, P processor, int id, Nas<C, S, P> oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, C> connections, String script, NasConnectionInspector inspector) {
        this.setup = setup;
        this.processor = processor;
        this.id = id;
        this.nasIPAddress = nasIPAddress;
        this.nasIdentifier = nasIdentifier;
        this.vendorCode = vendorCode;
        this.conf = conf;
        this.secret = secret;
        this.connections = connections;
        this.inspector = inspector;
        Script scr = new Script();
        scr.setTitle(this.toString());
        scr.setScript(script);
        this.script = new NasScript(scr, this);
        this.attributeSetMap = RadiusAttributeSet.newRadiusAttributeSetMap(setup, "attrset.", "attributes");
        this.attributeSetMap.putAll(RadiusAttributeSet.newRadiusAttributeSetMap(conf, "attrset.", "attributes"));
        this.realmAttributeMap = RadiusAttributeSet.newRadiusAttributeRealmMap(setup, "realm.", "");
        this.realmAttributeMap.putAll(RadiusAttributeSet.newRadiusAttributeRealmMap(conf, "realm.", ""));
        String services = conf.get("card.activate.serviceIds", conf.get("card.activate.service", null));
        if (services != null) {
            StringTokenizer st = new StringTokenizer(services, ";");
            while (st.hasMoreTokens()) {
                String service = st.nextToken();
                this.activateServices.add(Utils.parseInt(service, 0));
            }
        }
        this.mppeAddTypesAndPolicy = conf.getInt("add.mppe.enc.types.and.policy", 1) == 1;
        this.getLogger().debug("activate services: " + String.valueOf(this.activateServices));
        this.fanout = new RadiusFanout(this, conf);
        this.digestQop = conf.get("radius.digest5090.qop", "auth");
        this.digestRealm = conf.get("radius.digest5090.realm", "bgbilling.ru");
        this.responseSendMode = conf.getInt("radius.response.sendMode", 0);
        this.checkMessageAuthenticator = conf.getInt("radius.messageAuthenticator.validate", 1) > 0;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public InetAddress getNasIPAddress() {
        return this.nasIPAddress;
    }

    public String getNasIdentifier() {
        return this.nasIdentifier;
    }

    public int getVendorCode() {
        return this.vendorCode;
    }

    public ParameterMap getConf() {
        return this.conf;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public NasScript getScript() {
        return this.script;
    }

    public Map<Integer, RadiusAttributeSet> getAttributeSetMap() {
        return this.attributeSetMap;
    }

    public Map<String, RadiusAttributeSet> getRealmAttributeMap() {
        return this.realmAttributeMap;
    }

    public String toString() {
        String result = "Nas id: " + this.nasIdentifier + "; ip: " + (this.nasIPAddress != null ? this.nasIPAddress.getHostAddress() : "null");
        return result;
    }

    public boolean canActivateCard(Card card) {
        return card.getServiceActivateId() != 0 && this.activateServices.contains(card.getServiceActivateId()) || this.activateServices.contains(0);
    }

    public boolean isMppeAddTypesAndPolicy() {
        return this.mppeAddTypesAndPolicy;
    }

    public Iterable<C> connections() {
        return this.connections.values();
    }

    public int connectionCount() {
        return this.connections.size();
    }

    public String getDigestRealm() {
        return this.digestRealm;
    }

    public String getDigestQop() {
        return this.digestQop;
    }

    public int getResponseSendMode() {
        return this.responseSendMode;
    }

    public C setConnection(C nasCon, RadiusPacket request, Connection con, Connection conSlave) {
        throw new UnsupportedOperationException();
    }

    public C startConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        throw new UnsupportedOperationException();
    }

    public C stopConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        throw new UnsupportedOperationException();
    }

    public C updateConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        throw new UnsupportedOperationException();
    }

    public void fanoutPacket(RadiusListenerWorker<?> req, RadiusPacket packet) {
        this.fanout.fanout(req, packet, 0);
    }

    public void destroy() {
        this.fanout.shutdown();
    }

    public boolean isCheckMessageAuthenticator() {
        return this.checkMessageAuthenticator;
    }
}

