/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.period.server.bean;

import java.sql.Connection;
import java.util.concurrent.Callable;
import ru.bitel.bgbilling.kernel.contract.period.common.bean.ContractPeriod;
import ru.bitel.bgbilling.kernel.contract.period.server.bean.ContractPeriodDao;
import ru.bitel.bgbilling.kernel.contract.period.server.event.ContractPeriodCloseEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.ParameterMap;
import ru.bitel.oss.kernel.job.server.JobContext;

public class ContractPeriodCloseEventJob
implements Callable<Object> {
    public static final String PARAM_CONTRACT_PERIOD_ID = "contractPeriodId";

    @Override
    public Object call() throws Exception {
        JobContext context = (JobContext)JobContext.get();
        Connection con = context.getConnection();
        ParameterMap params = context.getJobParams();
        while (context.getJobTriggerTime().getTime() > System.currentTimeMillis()) {
            Thread.sleep((context.getJobTriggerTime().getTime() - System.currentTimeMillis()) / 2L);
        }
        ContractPeriod contractPeriod = null;
        ContractPeriodDao contractPeriodDao = new ContractPeriodDao(con);
        int contractPeriodId = params.getInt(PARAM_CONTRACT_PERIOD_ID, -1);
        contractPeriod = (ContractPeriod)contractPeriodDao.get(contractPeriodId);
        if (contractPeriod != null && contractPeriodDao.setSentCloseEventFlag(contractPeriod.getId())) {
            EventProcessor.getInstance().publish(new ContractPeriodCloseEvent(contractPeriod, 0));
        }
        return contractPeriod;
    }
}

