/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.tv.common.bean.ProlongationType;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvAccountOptionsModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvProductsModifyEvent;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeRoot;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvTarifficationManager;
import ru.bitel.bgbilling.modules.tv.server.runtime.bean.ProductRejectCause;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.bgbilling.modules.tv.server.task.TvRecalculator;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.event.ProductEntry;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifiedEvent;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductPeriodDao;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;
import ru.bitel.oss.systems.inventory.service.common.event.ServiceEntry;

public class ProductManager
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger();
    private final ServerContext context;
    private final ConnectionSet connectionSet;
    private final Connection con;
    private final int moduleId;
    private final ProductPeriodDao productPeriodDao;
    private PreparedStatement lockPS;
    private PreparedStatement selectAccountPS;
    private PreparedStatement selectPS;
    private int primaryPriority;
    private int secondaryPriority;
    protected static final Comparator<Entry> ENTRY_COMPARATOR = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            int i1 = o1.productSpec.getPriority();
            int i2 = o2.productSpec.getPriority();
            if (o2.productSpec.getDepends() != null && o2.productSpec.getDepends().contains(o1.productSpec.getId())) {
                return -1;
            }
            if (o1.productSpec.getDepends() != null && o1.productSpec.getDepends().contains(o2.productSpec.getId())) {
                return 1;
            }
            return Integer.compare(i2, i1);
        }
    };

    public ProductManager(ServerContext context, int moduleId) throws BGException {
        this.context = context;
        this.connectionSet = context.getConnectionSet();
        this.con = this.connectionSet.getConnection();
        this.moduleId = moduleId;
        ModuleSetup moduleSetup = context.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.primaryPriority = moduleSetup.getInt("prolongation.primary.priority", 0);
        this.secondaryPriority = moduleSetup.getInt("prolongation.secondary.priority", 0);
        try {
            this.productPeriodDao = new ProductPeriodDao(this.con, 0);
            this.lockPS = this.con.prepareStatement("SELECT mid FROM contract_module WHERE cid=? AND mid=? FOR UPDATE");
            this.selectAccountPS = this.con.prepareStatement("SELECT id, deviceId, status, deviceState, deviceOptions, dateTo FROM tv_account_" + moduleId + " WHERE id=? AND contractId=?");
            this.selectPS = this.con.prepareStatement("SELECT product.accountId, period.id, period.activationTime, period.timeFrom, period.timeTo, period.flags, product.id, product.productSpecId, product.activationModeId, product.activationTime, product.activationPrice, product.timeFrom, product.timeTo, product.deviceProductId, product.deviceState FROM inv_product as product LEFT JOIN inv_product_period as period ON period.productId=product.id LEFT JOIN inv_product_spec as spec ON product.productSpecId=spec.id WHERE product.contractId=? AND period.contractId=? AND (period.timeTo<=? OR (product.timeTo<=? AND period.timeTo>product.timeTo)) AND product.id IS NOT NULL AND (period.flags&?)=? ORDER BY product.accountId ASC LOCK IN SHARE MODE");
            assert (!this.con.getAutoCommit());
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public int getPrimaryPriority() {
        return this.primaryPriority;
    }

    public void setPrimaryPriority(int primaryPriority) {
        this.primaryPriority = primaryPriority;
    }

    public int getSecondaryPriority() {
        return this.secondaryPriority;
    }

    public void setSecondaryPriority(int secondaryPriority) {
        this.secondaryPriority = secondaryPriority;
    }

    @Override
    public void close() {
        this.closePS(this.lockPS);
        this.closePS(this.selectPS);
        this.closePS(this.selectAccountPS);
    }

    private void closePS(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public BigDecimal productsProlongate(TvTariffContext tvTariffContext, TvTariffWorkerContext tvTariffWorkerContext, TvTarifficationManager tvTarifficationManager, ContractRuntime contractRuntime, int contractId, BigDecimal balance, BigDecimal limit, TariffModuleTreeSet tariffTreeSet, TvAccountRuntimeMap tvAccountRuntimeMap, java.util.Date currentTime, ProlongationType type) throws Exception {
        try {
            logger.debug("productsProlongate");
            Directory productSpecDirectory = tvTariffWorkerContext.getDirectory(ProductSpec.class, 0);
            ContractTariffOptionList contractTariffOptions = contractRuntime.getTariffOptions(currentTime.getTime());
            Map tariffOptionsMap = null;
            if (contractTariffOptions != null) {
                long millis = currentTime.getTime();
                tariffOptionsMap = contractTariffOptions.map(millis, millis);
            }
            logger.debug("TariffOptionMap: " + String.valueOf(tariffOptionsMap));
            ProductRejectCause reject = new ProductRejectCause();
            Set suspendedStatusSet = StatusCache.getInstance().getModuleSuspendStatusSet(this.moduleId, "");
            if (suspendedStatusSet.contains(contractRuntime.getStatus())) {
                reject.setRejectByContractStatus(contractRuntime.getStatus(), true);
                logger.debug("Contract:" + contractRuntime.contractId + " status is suspended");
            } else {
                reject.setRejectByContractStatus(contractRuntime.getStatus(), false);
            }
            ProductSpecRuntimeMap productSpecRuntimeMap = ProductSpecRuntimeMap.getInstance(this.connectionSet);
            this.contractModuleLock(contractId);
            HashMap<Integer, AccountData> accountDataMap = new HashMap<Integer, AccountData>();
            List<Entry> fullEntryList = this.getProductEntryList(tvTariffContext, (Directory<ProductSpec>)productSpecDirectory, tvAccountRuntimeMap, accountDataMap, contractId, currentTime, type);
            AtomicReference<BigDecimal> balanceRef = new AtomicReference<BigDecimal>(balance);
            LinkedHashMap<Integer, List<Entry>> accountEntryListMap = new LinkedHashMap<Integer, List<Entry>>();
            accountEntryListMap.put(0, new ArrayList());
            EnumMap priorityEntryListMap = fullEntryList.stream().collect(Collectors.groupingBy(a -> this.getProlongationPriority(a.productSpec.getPriority()), () -> new EnumMap(ProlongationPriority.class), Collectors.toList()));
            priorityEntryListMap.getOrDefault((Object)ProlongationPriority.PRIMARY, Collections.emptyList()).stream().collect(Collectors.groupingBy(a -> a.accountId, () -> accountEntryListMap, Collectors.toList()));
            this.processProducts(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, balanceRef, limit, tariffTreeSet, contractTariffOptions, tvAccountRuntimeMap, currentTime, productSpecRuntimeMap, accountDataMap, accountEntryListMap, new ProductRejectCause(reject));
            if (priorityEntryListMap.get((Object)ProlongationPriority.SECONDARY) != null) {
                accountEntryListMap.clear();
                accountEntryListMap.put(0, new ArrayList(5));
                priorityEntryListMap.getOrDefault((Object)ProlongationPriority.SECONDARY, Collections.emptyList()).stream().collect(Collectors.groupingBy(a -> a.accountId, () -> accountEntryListMap, Collectors.toList()));
                ProductRejectCause secondaryReject = new ProductRejectCause(reject);
                if (!this.checkSecondaryProducts(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, balanceRef, limit, tariffTreeSet, contractTariffOptions, tvAccountRuntimeMap, currentTime, productSpecRuntimeMap, accountDataMap, accountEntryListMap, new ProductRejectCause(reject))) {
                    secondaryReject.setRejectBySecondary();
                }
                this.processProducts(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, balanceRef, limit, tariffTreeSet, contractTariffOptions, tvAccountRuntimeMap, currentTime, productSpecRuntimeMap, accountDataMap, accountEntryListMap, secondaryReject);
            }
            if (priorityEntryListMap.get((Object)ProlongationPriority.TERTIARY) != null) {
                accountEntryListMap.clear();
                accountEntryListMap.put(0, new ArrayList(5));
                priorityEntryListMap.getOrDefault((Object)ProlongationPriority.TERTIARY, Collections.emptyList()).stream().collect(Collectors.groupingBy(a -> a.accountId, () -> accountEntryListMap, Collectors.toList()));
                this.processProducts(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, balanceRef, limit, tariffTreeSet, contractTariffOptions, tvAccountRuntimeMap, currentTime, productSpecRuntimeMap, accountDataMap, accountEntryListMap, reject);
            }
            this.publishChanges(contractRuntime, contractId, accountDataMap);
            return balance;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private ProlongationPriority getProlongationPriority(int priority) {
        return priority >= this.primaryPriority ? ProlongationPriority.PRIMARY : (priority >= this.secondaryPriority ? ProlongationPriority.SECONDARY : ProlongationPriority.TERTIARY);
    }

    private void publishChanges(ContractRuntime contractRuntime, int contractId, Map<Integer, AccountData> accountDataMap) throws BGException {
        for (Map.Entry<Integer, AccountData> e : accountDataMap.entrySet()) {
            if (e.getKey() == 0) continue;
            AccountData accountData = e.getValue();
            if (accountData == null) {
                logger.info("ProductManager.publishChanges: accountData==null for key={} - SKIP", (Object)e.getKey());
                continue;
            }
            if (accountData.productEntryList.size() > 0) {
                OmTvProductsModifyEvent omTvProductsModifyEvent = new OmTvProductsModifyEvent(this.moduleId, contractRuntime.contractId, 0, accountData.deviceId, accountData.account.tvAccountId, accountData.productEntryList, accountData.newDeviceOptions);
                omTvProductsModifyEvent.setSource(ProductManager.class.getSimpleName() + ".publishChanges");
                this.context.publishAfterCommit((Event)omTvProductsModifyEvent);
                continue;
            }
            if (accountData.newDeviceOptions.equals(accountData.deviceOptions)) continue;
            if (accountData.account != null) {
                accountData.account.processOptionsModified(this.context, this.moduleId, System.currentTimeMillis(), accountData.newDeviceOptions);
                continue;
            }
            this.context.publishAfterCommit((Event)new OmTvAccountOptionsModifyEvent(this.moduleId, contractId, 0, accountData.deviceId, accountData.account.tvAccountId, accountData.newDeviceOptions));
        }
    }

    private void processProducts(TvTariffContext tvTariffContext, TvTariffWorkerContext tvTariffWorkerContext, TvTarifficationManager tvTarifficationManager, ContractRuntime contractRuntime, int contractId, AtomicReference<BigDecimal> balanceRef, BigDecimal limit, TariffModuleTreeSet tariffTreeSet, ContractTariffOptionList contractTariffOptions, TvAccountRuntimeMap tvAccountRuntimeMap, java.util.Date currentTime, ProductSpecRuntimeMap productSpecRuntimeMap, Map<Integer, AccountData> accountDataMap, LinkedHashMap<Integer, List<Entry>> accountEntryListMap, ProductRejectCause defaultReject) throws Exception {
        for (Map.Entry<Integer, List<Entry>> e : accountEntryListMap.entrySet()) {
            if (e.getValue().size() == 0) continue;
            AccountData accountData = accountDataMap.get(e.getKey());
            if (accountData == null) {
                logger.warn("TvAccount:" + String.valueOf(e.getKey()) + " not found!");
                continue;
            }
            ProductRejectCause reject = new ProductRejectCause(defaultReject);
            if (accountData.deviceState != 1) {
                reject.setRejectByDeviceState(accountData.deviceState, true);
                logger.debug("TvAccount:" + String.valueOf(e.getKey()) + " is not enabled");
            } else {
                reject.setRejectByDeviceState(accountData.deviceState, false);
            }
            List<TvServiceCost> tvServiceCostList = TvUtils.createServiceCostList(productSpecRuntimeMap, e.getValue());
            TvTariffRequest prolongateReq = this.calculateAndProlongate(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, tariffTreeSet, balanceRef.get(), limit, contractTariffOptions, accountData.account, accountData.account != null ? accountData.account.tvAccountId : 0, currentTime, currentTime, tvServiceCostList, accountData.productEntryList, reject);
            balanceRef.set(prolongateReq.getBalance());
            accountData.newDeviceOptions.clear();
            accountData.newDeviceOptions.addAll(prolongateReq.getOptionSet());
        }
    }

    private boolean checkSecondaryProducts(TvTariffContext tvTariffContext, TvTariffWorkerContext tvTariffWorkerContext, TvTarifficationManager tvTarifficationManager, ContractRuntime contractRuntime, int contractId, AtomicReference<BigDecimal> balanceRef, BigDecimal limit, TariffModuleTreeSet tariffTreeSet, ContractTariffOptionList contractTariffOptions, TvAccountRuntimeMap tvAccountRuntimeMap, java.util.Date currentTime, ProductSpecRuntimeMap productSpecRuntimeMap, Map<Integer, AccountData> accountDataMap, LinkedHashMap<Integer, List<Entry>> accountEntryListMap, ProductRejectCause reject) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        BigDecimal balance = balanceRef.get();
        for (Map.Entry<Integer, List<Entry>> e : accountEntryListMap.entrySet()) {
            if (e.getValue().size() == 0) continue;
            calendar.setTime(currentTime);
            AccountData accountData = accountDataMap.get(e.getKey());
            if (accountData == null) {
                logger.warn("TvAccount:" + String.valueOf(e.getKey()) + " not found!");
                continue;
            }
            if (accountData.status != 0) {
                logger.debug("TvAccount:" + String.valueOf(e.getKey()) + " status not active");
                continue;
            }
            List<TvServiceCost> tvServiceCostList = TvUtils.createServiceCostList(productSpecRuntimeMap, e.getValue());
            TvTarifficationManager.CalculateResult calculateResult = tvTarifficationManager.calculate(false, false, tvTariffContext, tvTariffWorkerContext, false, true, contractRuntime, contractRuntime.contractId, contractTariffOptions, accountData.account, accountData.account != null ? accountData.account.tvAccountId : 0, tvServiceCostList, tariffTreeSet, calendar, currentTime, balance, limit, false, false, null, null, reject);
            TvTariffRequest req = calculateResult.getReq();
            balance = req.getBalance();
            for (List reqTvServiceCostList : req.getServiceCost().values()) {
                for (TvServiceCost tvServiceCost : reqTvServiceCostList) {
                    if (tvServiceCost.prolongation != 0) continue;
                    logger.info("Can't prolongate secondary products - rejecting");
                    return false;
                }
            }
        }
        return true;
    }

    private void contractModuleLock(int contractId) throws SQLException {
        this.lockPS.setInt(1, contractId);
        this.lockPS.setInt(2, this.moduleId);
        this.lockPS.executeQuery().close();
    }

    private List<Entry> getProductEntryList(TvTariffContext tvTariffContext, Directory<ProductSpec> productSpecDirectory, TvAccountRuntimeMap tvAccountRuntimeMap, Map<Integer, AccountData> accountDataMap, int contractId, java.util.Date currentTime, ProlongationType type) throws SQLException, BGException {
        this.selectPS.setInt(1, contractId);
        this.selectPS.setInt(2, contractId);
        Timestamp sqlTime = TimeUtils.convertDateToTimestamp((java.util.Date)currentTime);
        this.selectPS.setTimestamp(3, sqlTime);
        this.selectPS.setTimestamp(4, sqlTime);
        switch (type) {
            case payment: {
                this.selectPS.setInt(5, 7);
                this.selectPS.setInt(6, 1);
                break;
            }
            default: {
                this.selectPS.setInt(5, 6);
                this.selectPS.setInt(6, 0);
            }
        }
        ArrayList<Entry> entryList = new ArrayList<Entry>();
        ResultSet rs = this.selectPS.executeQuery();
        while (rs.next()) {
            int accountId = rs.getInt(1);
            int productPeriodId = rs.getInt(2);
            java.util.Date productPeriodActivationTime = TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(3));
            java.util.Date productPeriodTimeFrom = TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(4));
            java.util.Date productPeriodTimeTo = TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(5));
            int productPeriodFlags = rs.getInt(6);
            int productId = rs.getInt(7);
            int productSpecId = rs.getInt(8);
            ProductSpec productSpec = (ProductSpec)productSpecDirectory.get(productSpecId);
            if (productSpec == null) {
                logger.warn("ProductSpec with id=" + productSpecId + " for product:" + productId + " not found");
                continue;
            }
            if (productSpec.getModuleId() != this.moduleId || tvTariffContext.getTariffMode() == TvTariffContext.TvTariffMode.realtime && type != ProlongationType.payment && productSpec.isNotRealtime() && !productPeriodTimeTo.before(productPeriodTimeFrom)) continue;
            AccountData accountData = this.getAccountData(tvAccountRuntimeMap, accountDataMap, contractId, accountId);
            if (accountData == null) {
                assert (accountId != 0) : "accountData null for contract";
                continue;
            }
            int activationModeId = rs.getInt(9);
            java.util.Date activationTime = TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(10));
            BigDecimal activationPrice = rs.getBigDecimal(11);
            Timestamp productTimeFrom = rs.getTimestamp(12);
            Timestamp productTimeTo = rs.getTimestamp(13);
            String deviceProductId = rs.getString(14);
            short deviceState = rs.getShort(15);
            Entry entry = new Entry(accountId, productPeriodId, productPeriodActivationTime, productPeriodTimeFrom, productPeriodTimeTo, productPeriodFlags, productId, productSpecId, productSpec, activationModeId, activationTime, activationPrice, productTimeFrom, productTimeTo, deviceProductId, deviceState, null);
            if (productTimeTo != null && (tvTariffContext.isProlongation() && !currentTime.before(productTimeTo) || !productPeriodTimeTo.before(productTimeTo))) {
                this.productPeriodDao.addFlag(entry.productPeriodId, 4);
                Product product = entry.toProduct(contractId, accountId);
                logger.info("Product ended: " + String.valueOf(product));
                if (accountData == null) continue;
                accountData.productEntryList.add(new ProductEntry(product, product, entry.deviceState, 0));
                continue;
            }
            entryList.add(entry);
        }
        rs.close();
        Collections.sort(entryList, ENTRY_COMPARATOR);
        return entryList;
    }

    private TvTariffRequest calculateAndProlongate(TvTariffContext tvTariffContext, TvTariffWorkerContext tvTariffWorkerContext, TvTarifficationManager tvTarifficationManager, ContractRuntime contractRuntime, int contractId, TariffModuleTreeSet tariffTreeSet, BigDecimal balance, BigDecimal limit, ContractTariffOptionList contractTariffOptions, TvAccountRuntimeRoot tvAccountRuntime, int tvAccountId, java.util.Date tariffRequestTime, java.util.Date currentTime, List<TvServiceCost> tvServiceCostList, List<ProductEntry> productEntryList, ProductRejectCause reject) throws Exception {
        assert (tvAccountId == 0 == (tvAccountRuntime == null)) : "tvAccountRuntime must be null only for contract (accountId==0)";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(tariffRequestTime);
        TvTarifficationManager.CalculateResult calculateResult = tvTarifficationManager.calculate(true, true, tvTariffContext, tvTariffWorkerContext, false, true, contractRuntime, contractRuntime.contractId, contractTariffOptions, tvAccountRuntime, tvAccountId, tvServiceCostList, tariffTreeSet, calendar, currentTime, balance, limit, false, false, null, null, reject);
        TvTariffRequest req = calculateResult.getReq();
        GregorianCalendar utilCalendar1 = new GregorianCalendar();
        GregorianCalendar utilCalendar2 = new GregorianCalendar();
        for (List reqTvServiceCostList : req.getServiceCost().values()) {
            block6: for (TvServiceCost tvServiceCost : reqTvServiceCostList) {
                boolean prolongationWithoutPause;
                Entry entry = tvServiceCost.getProductItem();
                switch (tvServiceCost.prolongation) {
                    case 2: {
                        if (entry == null) {
                            prolongationWithoutPause = true;
                            break;
                        }
                        if ((entry.productPeriodFlags & 8) == 0) {
                            if (entry.productPeriodTimeTo.before(entry.productPeriodTimeFrom)) {
                                prolongationWithoutPause = true;
                                break;
                            }
                            utilCalendar1.setTime(entry.productPeriodTimeFrom);
                            utilCalendar2.setTime(tvServiceCost.periodTimeFrom);
                            if (TimeUtils.compare((Calendar)utilCalendar1, (Calendar)utilCalendar2, (int)2) == 0) {
                                prolongationWithoutPause = true;
                                break;
                            }
                        }
                    }
                    case 1: {
                        prolongationWithoutPause = false;
                        this.productPeriodDao.addFlag(entry.productPeriodId, 2);
                        break;
                    }
                    case 3: {
                        if (entry.productPeriodTimeTo.before(entry.productPeriodTimeFrom) && tvServiceCost.periodTimeFrom.equals(entry.productPeriodTimeFrom)) {
                            prolongationWithoutPause = true;
                            this.productPeriodDao.addFlag(entry.productPeriodId, 8);
                            break;
                        }
                        prolongationWithoutPause = false;
                        this.productPeriodDao.addFlag(entry.productPeriodId, 2);
                        break;
                    }
                    default: {
                        this.productPeriodDao.addFlag(entry.productPeriodId, 1);
                        Product product = entry.toProduct(contractRuntime.contractId, tvAccountId);
                        productEntryList.add(new ProductEntry(product, product, entry.deviceState, 0));
                        continue block6;
                    }
                }
                if (prolongationWithoutPause) {
                    java.util.Date time = tvServiceCost.periodTimeTo;
                    logger.info("Product[" + entry.productSpecId + "-" + entry.productId + "] period[" + entry.productPeriodId + "] prolongate to " + String.valueOf(time));
                    int version = this.productPeriodDao.updatePeriod(entry.productPeriodId, time, tvServiceCost.periodTimeFrom);
                    this.productPeriodUpdate(contractRuntime, tvAccountRuntime, tvAccountId, tvServiceCost, entry, time, version);
                    Product product = tvServiceCost.getProductItem().toProduct(contractRuntime.contractId, tvAccountId);
                    product.setSubscriptionTimeFrom(tvServiceCost.periodTimeFrom);
                    product.setSubscriptionTimeTo(tvServiceCost.periodTimeTo);
                    productEntryList.add(new ProductEntry(product, product, tvServiceCost.getProductItem().deviceState, 1));
                    continue;
                }
                ProductPeriod productPeriod = ProductPeriod.builder().setAccountId(tvAccountId).setContractId(contractId).setProductId(entry.productId).setProductSpecId(entry.productSpecId).setActivationTime(currentTime).setTimeFrom(tvServiceCost.periodTimeFrom).setTimeTo(tvServiceCost.periodTimeTo).build();
                productPeriod.setProlongationTime(tvServiceCost.periodTimeFrom);
                if (tvServiceCost.prolongation == 3) {
                    productPeriod.setFlags(8);
                    if (tvServiceCost.prolongationTime != null) {
                        productPeriod.setProlongationTime(tvServiceCost.prolongationTime);
                    }
                }
                this.productPeriodDao.update(productPeriod);
                logger.info("Product[" + entry.productSpecId + "-" + entry.productId + "] period create[" + productPeriod.getId() + "] to " + String.valueOf(productPeriod.getTimeTo()));
                this.productPeriodNew(contractRuntime, tvAccountRuntime, tvAccountId, entry, productPeriod);
                Product product = tvServiceCost.getProductItem().toProduct(contractRuntime.contractId, tvAccountId);
                product.setSubscriptionTimeFrom(tvServiceCost.periodTimeFrom);
                product.setSubscriptionTimeTo(tvServiceCost.periodTimeTo);
                productEntryList.add(new ProductEntry(product, product, tvServiceCost.getProductItem().deviceState, 1));
            }
        }
        return req;
    }

    private void productPeriodUpdate(ContractRuntime contractRuntime, TvAccountRuntimeRoot tvAccountRuntime, int tvAccountId, TvServiceCost tvServiceCost, Entry entry, java.util.Date time, int version) {
        if (tvAccountId != 0) {
            assert (tvAccountRuntime != null) : "tvAccountRuntime must be null only for contract (accountId==0)";
            tvAccountRuntime.setProductPeriodRuntimeList(tvAccountRuntime.getProductPeriodRuntimeList().update(entry.productSpecId, entry.productId, entry.productPeriodId, entry.productPeriodTimeFrom, time, tvServiceCost.periodTimeFrom));
        }
        contractRuntime.updateProductPeriods(tvAccountId, entry.productSpecId, entry.productId, entry.productPeriodId, entry.productPeriodTimeFrom, time, tvServiceCost.periodTimeFrom);
        this.context.publishAfterCommit((Event)new ProductPeriodModifiedEvent(this.moduleId, contractRuntime.contractId, tvAccountId, entry.productSpecId, entry.productId, entry.activationModeId, entry.productTimeFrom, entry.productTimeTo, entry.productPeriodId, entry.productPeriodTimeFrom, entry.productPeriodTimeTo, entry.productPeriodTimeFrom, time, tvServiceCost.periodTimeFrom, version));
    }

    private void productPeriodNew(ContractRuntime contractRuntime, TvAccountRuntimeRoot tvAccountRuntime, int tvAccountId, Entry entry, ProductPeriod productPeriod) {
        if (tvAccountId != 0) {
            assert (tvAccountRuntime != null) : "tvAccountRuntime must be null only for contract (accountId==0)";
            tvAccountRuntime.setProductPeriodRuntimeList(tvAccountRuntime.getProductPeriodRuntimeList().update(entry.productSpecId, entry.productId, productPeriod.getId(), productPeriod.getTimeFrom(), productPeriod.getTimeTo(), productPeriod.getProlongationTime()));
        }
        contractRuntime.updateProductPeriods(tvAccountId, entry.productSpecId, entry.productId, productPeriod.getId(), productPeriod.getTimeFrom(), productPeriod.getTimeTo(), productPeriod.getProlongationTime());
        this.context.publishAfterCommit((Event)new ProductPeriodModifiedEvent(this.moduleId, contractRuntime.contractId, tvAccountId, entry.productSpecId, entry.productId, entry.activationModeId, entry.productTimeFrom, entry.productTimeTo, productPeriod.getId(), null, null, productPeriod.getTimeFrom(), productPeriod.getTimeTo(), productPeriod.getProlongationTime(), 0));
    }

    public BigDecimal productsProlongate(ConnectionSet connectionSet, ContractRuntime contractRuntime, int contractId, BigDecimal balance, BigDecimal limit, java.util.Date time, ProlongationType type) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(time);
        ((Calendar)calendar).add(1, -1);
        TvTariffContext tvTariffContext = new TvTariffContext(connectionSet, this.moduleId, calendar.getTime(), TvTariffContext.TvTariffMode.realtime);
        tvTariffContext.getTvAccountRuntimeMap().load(connectionSet, contractId);
        List<TvAccountRuntime> list = tvTariffContext.getTvAccountRuntimeMap().list(contractId);
        if (list == null || list.size() == 0) {
            logger.info("TvAccounts not found for contractId: " + contractId);
            return balance;
        }
        TvTariffWorkerContext tvTariffWorkerContext = new TvTariffWorkerContext(this.context, this.moduleId);
        TvTarifficationManager tvTarifficationManager = new TvTarifficationManager(this.context.getSetup(), connectionSet, this.moduleId);
        try {
            BigDecimal bigDecimal;
            try (TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);){
                TariffModuleTreeSet tariffTreeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractRuntime.contractId, calendar.getTime(), "tv", this.moduleId, 0, 0);
                contractRuntime.lock();
                bigDecimal = this.productsProlongate(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, balance, limit, tariffTreeSet, tvTariffContext.getTvAccountRuntimeMap(), time, type);
            }
            return bigDecimal;
        }
        finally {
            contractRuntime.unlock();
        }
    }

    public BigDecimal productsProlongate(ConnectionSet connectionSet, int contractId, BigDecimal balance, BigDecimal limit, ProlongationType type) throws Exception {
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(connectionSet, Integer.valueOf(contractId));
        if (contractRuntime == null) {
            logger.info("Contract not found with id: " + contractId);
            return balance;
        }
        if (limit == null) {
            limit = ConvergenceBalanceManager.getInstance().getBalance(connectionSet, Integer.valueOf(contractId), System.currentTimeMillis()).getLimit();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        if (balance == null) {
            try (BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());){
                int yy = calendar.get(1);
                int mm = calendar.get(2) + 1;
                ContractBalance contractBalance = contractRuntime.getSuperContractId() > 0 ? balanceDao.getContractBalance(contractRuntime.getSuperContractId(), yy, mm) : balanceDao.getContractBalance(contractId, yy, mm);
                balance = contractBalance.toBalance();
            }
        }
        return this.productsProlongate(this.context.getConnectionSet(), contractRuntime, contractRuntime.contractId, balance, limit, calendar.getTime(), type);
    }

    @Deprecated
    public BigDecimal productActivate(ProductSpec productSpec, ProductSpecActivationMode productSpecActivationMode, Product product, boolean sync, List<ProductEntry> productEntryList) throws Exception {
        return this.productActivate(productSpec, productSpecActivationMode, product, sync, productEntryList, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal productActivate(ProductSpec productSpec, ProductSpecActivationMode productSpecActivationMode, Product product, boolean sync, List<ProductEntry> productEntryList, boolean customer) throws Exception {
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.connectionSet, Integer.valueOf(product.getContractId()));
        contractRuntime.lock();
        try {
            BigDecimal bigDecimal = this.productActivate0(productSpec, productSpecActivationMode, product, sync, productEntryList, customer);
            return bigDecimal;
        }
        finally {
            contractRuntime.unlock();
        }
    }

    private BigDecimal productActivate0(ProductSpec productSpec, ProductSpecActivationMode productSpecActivationMode, Product product, boolean sync, List<ProductEntry> productEntryList, boolean customer) throws Exception {
        BigDecimal limit;
        BigDecimal balance;
        TvTarifficationManager tvTarifficationManager;
        ContractRuntime contractRuntime;
        TvTariffWorkerContext tvTariffWorkerContext;
        TvTariffContext tvTariffContext;
        TariffModuleTreeSet tariffTreeSet;
        GregorianCalendar time;
        int contractId;
        block17: {
            logger.debug("productActivate");
            contractId = product.getContractId();
            int tvAccountId = product.getAccountId();
            time = new GregorianCalendar();
            time.setTime(product.getActivationTime());
            Calendar date = (Calendar)((Calendar)time).clone();
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)date);
            ArrayList<TvServiceCost> serviceCostList = new ArrayList<TvServiceCost>();
            Calendar productTimeFrom = TimeUtils.convertDateToCalendar((java.util.Date)product.getTimeFrom());
            Calendar productTimeTo = TimeUtils.convertDateToCalendar((java.util.Date)product.getTimeTo());
            ProductSpecRuntimeMap productSpecRuntimeMap = ProductSpecRuntimeMap.getInstance(this.connectionSet);
            int productSpecId = productSpec.getId();
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(productSpecId);
            TvServiceCost serviceCost = TvServiceCost.builder().setServiceId(-product.getProductSpecId()).setProductId(product.getId()).setActivationModeId(product.getActivationModeId()).setActivationTime(product.getActivationTime()).setProductSpecRuntime(productSpecRuntime).setServiceStart(productTimeFrom).setServiceEnd(productTimeTo).setAmount(1L).build();
            if (product.getActivationPrice() != null) {
                serviceCost.activationPrice = product.getActivationPrice();
                serviceCost.activationPriceExternal = true;
            }
            serviceCostList.add(serviceCost);
            TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(this.connectionSet.getConnection());
            tariffTreeSet = treeSetDao.getTariffTreeSetForDay(contractId, date, "tv", this.moduleId, this.moduleId, tvAccountId);
            treeSetDao.close();
            tvTariffContext = new TvTariffContext(this.connectionSet, this.moduleId, date.getTime(), TvTariffContext.TvTariffMode.realtime);
            tvTariffWorkerContext = new TvTariffWorkerContext(this.context, this.moduleId);
            contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.connectionSet, Integer.valueOf(contractId));
            boolean period = time.compareTo(TimeUtils.convertDateToCalendar((java.util.Date)product.getTimeFrom())) >= 0;
            tvTarifficationManager = new TvTarifficationManager(this.context.getSetup(), this.connectionSet, this.moduleId);
            if (tvAccountId > 0) {
                short tvAccountDeviceState;
                this.selectAccountPS.setInt(1, tvAccountId);
                this.selectAccountPS.setInt(2, contractId);
                ResultSet rs = this.selectAccountPS.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    throw new BGMessageException("TvAccount:" + tvAccountId + " not found!");
                }
                if (customer && (tvAccountDeviceState = rs.getShort(4)) == 0) {
                    throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0430 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u043c \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0435.");
                }
                java.util.Date dateTo = TimeUtils.convertSqlDateToDate((Date)rs.getDate(6));
                if (TimeUtils.dateBefore((java.util.Date)dateTo, (java.util.Date)new java.util.Date())) {
                    throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0435.");
                }
                rs.close();
            }
            ConvergenceBalance convergenceBalance = ConvergenceBalanceManager.getInstance().getBalance(this.connectionSet, Integer.valueOf(contractId), System.currentTimeMillis());
            balance = convergenceBalance.getBalance();
            limit = convergenceBalance.getLimit();
            ContractTariffOptionList contractTariffOptions = contractRuntime.getTariffOptions(time.getTime());
            Map tariffOptionsMap = null;
            if (contractTariffOptions != null) {
                long millis = time.getTimeInMillis();
                tariffOptionsMap = contractTariffOptions.map(millis, millis);
            }
            logger.debug("TariffOptionMap: " + String.valueOf(tariffOptionsMap));
            tvTariffContext.getTvAccountRuntimeMap().load(this.connectionSet, contractId);
            TvAccountRuntimeRoot tvAccountRuntime = (TvAccountRuntimeRoot)tvTariffContext.getTvAccountRuntimeMap().get(tvAccountId);
            tvTarifficationManager.calculate(true, true, tvTariffContext, tvTariffWorkerContext, true, false, contractRuntime, contractId, contractTariffOptions, tvAccountRuntime, tvAccountId, serviceCostList, tariffTreeSet, time, time.getTime(), balance, limit, true, false, null, null, new ProductRejectCause());
            this.contractModuleLock(contractId);
            ProductPeriod productPeriod = ProductPeriod.builder().setAccountId(product.getAccountId()).setContractId(product.getContractId()).setProductId(product.getId()).setProductSpecId(product.getProductSpecId()).setActivationTime(product.getActivationTime()).setTimeFrom(product.getTimeFrom()).setTimeTo(TvUtils.moveSecond(product.getTimeFrom(), -1, new GregorianCalendar())).build();
            try (ProductPeriodDao productPeriodDao = new ProductPeriodDao(this.connectionSet.getConnection(), 0);){
                logger.debug("Update productPeriod: " + String.valueOf(productPeriod));
                productPeriodDao.update(productPeriod);
            }
            boolean futureActivation = productPeriod.getTimeFrom().compareTo(new java.util.Date(System.currentTimeMillis() + 30000L)) > 0;
            logger.debug("period={}; futureActivation={}", (Object)period, (Object)futureActivation);
            if (period && !futureActivation) break block17;
            this.context.publishAfterCommit((Event)new ProductPeriodModifiedEvent(this.moduleId, contractId, 0, product, null, productPeriod));
            if (!futureActivation) break block17;
            logger.debug("balance = {}", (Object)balance);
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        try {
            logger.debug("productsProlongate");
            BigDecimal bigDecimal = balance = this.productsProlongate(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, balance, limit, tariffTreeSet, tvTariffContext.getTvAccountRuntimeMap(), time.getTime(), ProlongationType.normal);
            return bigDecimal;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void productDelete(Product product, boolean sync, List<ProductEntry> productEntryList) throws BGException {
        try {
            int tvAccountId = product.getAccountId();
            int contractId = product.getContractId();
            this.selectAccountPS.setInt(1, tvAccountId);
            this.selectAccountPS.setInt(2, contractId);
            ResultSet rs = this.selectAccountPS.executeQuery();
            if (!rs.next()) {
                rs.close();
                throw new BGException("TvAccount:" + tvAccountId + " not found!");
            }
            int deviceId = rs.getInt(2);
            rs.close();
            ProductEntry productEntry = new ProductEntry(product, null, product.getDeviceState(), -1);
            productEntryList.add(productEntry);
            List serviceList = product.getServiceList();
            product.setServiceList(null);
            ArrayList<ServiceEntry> serviceEntryList = new ArrayList<ServiceEntry>();
            if (serviceList != null) {
                for (Service service : serviceList) {
                    serviceEntryList.add(new ServiceEntry(service, service, productEntry.getOldState(), Service.STATE_REMOVED));
                }
            }
            productEntry.setServiceEntryList(serviceEntryList);
            this.recalculate(contractId, product.getTimeFrom(), product.getTimeTo());
            if (sync && productEntryList.size() > 0) {
                OmTvProductsModifyEvent omTvProductsModifyEvent = new OmTvProductsModifyEvent(this.moduleId, product.getContractId(), 0, deviceId, tvAccountId, productEntryList, null);
                omTvProductsModifyEvent.setSource(ProductManager.class.getSimpleName() + ".productDelete");
                this.context.publishAfterCommit((Event)omTvProductsModifyEvent);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void recalculate(int contractId, java.util.Date timeFrom, java.util.Date timeTo) {
        TvRecalculator recalculator;
        java.util.Date now = new java.util.Date();
        if (timeTo == null || timeTo.after(now)) {
            timeTo = now;
        }
        Setup setup = Setup.getSetup();
        GregorianCalendar calendarFrom = new GregorianCalendar();
        calendarFrom.setTime(timeFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendarFrom);
        GregorianCalendar calendarTo = new GregorianCalendar();
        calendarTo.setTime(timeFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendarTo);
        calendarTo.set(5, 1);
        ((Calendar)calendarTo).add(2, 1);
        ((Calendar)calendarTo).add(14, -1);
        while (TimeUtils.dateBefore((java.util.Date)calendarTo.getTime(), (java.util.Date)timeTo)) {
            recalculator = new TvRecalculator(this.moduleId, calendarFrom.getTime(), calendarTo.getTime(), null, Collections.singleton(contractId), null);
            recalculator.init(setup);
            recalculator.run();
            calendarFrom.set(5, 1);
            ((Calendar)calendarFrom).add(2, 1);
            calendarTo.setTime(calendarFrom.getTime());
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendarTo);
            calendarTo.set(5, 1);
            ((Calendar)calendarTo).add(2, 1);
            ((Calendar)calendarTo).add(14, -1);
        }
        calendarTo.setTime(timeTo);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendarTo);
        ((Calendar)calendarTo).add(5, 1);
        ((Calendar)calendarTo).add(14, -1);
        if (TimeUtils.dateBeforeOrEq((java.util.Date)calendarTo.getTime(), (java.util.Date)timeTo)) {
            recalculator = new TvRecalculator(this.moduleId, calendarFrom.getTime(), calendarTo.getTime(), null, Collections.singleton(contractId), null);
            recalculator.init(setup);
            recalculator.run();
        }
    }

    private AccountData loadAccountData(TvAccountRuntimeMap tvAccountRuntimeMap, int contractId, int accountId) throws SQLException {
        TvAccountRuntimeRoot tvAccountRuntime = (TvAccountRuntimeRoot)tvAccountRuntimeMap.get(accountId);
        if (tvAccountRuntime == null) {
            logger.error("TvAccount not found with id=" + accountId);
            return null;
        }
        this.selectAccountPS.setInt(1, accountId);
        this.selectAccountPS.setInt(2, contractId);
        ResultSet rs = this.selectAccountPS.executeQuery();
        if (!rs.next()) {
            rs.close();
            logger.error("TvAccount not found with id=" + accountId + " in DB");
            return null;
        }
        int deviceId = rs.getInt(2);
        int status = rs.getInt(3);
        short deviceState = rs.getShort(4);
        Set deviceOptions = Utils.toIntegerSet((String)rs.getString(5));
        rs.close();
        return new AccountData(tvAccountRuntime, deviceId, status, deviceState, deviceOptions);
    }

    private AccountData getAccountData(TvAccountRuntimeMap tvAccountRuntimeMap, Map<Integer, AccountData> accountDataMap, int contractId, int accountId) throws SQLException {
        AccountData accountData = accountDataMap.get(accountId);
        if (accountData == null) {
            if (accountDataMap.containsKey(accountId)) {
                return null;
            }
            accountData = accountId == 0 ? new AccountData(null, 0, 0, 1, Collections.emptySet()) : this.loadAccountData(tvAccountRuntimeMap, contractId, accountId);
            accountDataMap.put(accountId, accountData);
        }
        return accountData;
    }

    public BigDecimal precalculateAccount(int contractId, java.util.Date dateTo) throws Exception {
        TvTarifficationManager.CalculateResult calculateResult = this.precalculateAccountDetail(contractId, dateTo, true);
        if (calculateResult == null) {
            return null;
        }
        return calculateResult.getBalance();
    }

    public TvTarifficationManager.CalculateResult precalculateAccountDetail(int contractId, java.util.Date dateTo) throws Exception {
        return this.precalculateAccountDetail(contractId, dateTo, true);
    }

    public ServiceCostCache precalculateServiceCost(int contractId, java.util.Date dateTo) throws Exception {
        TvTarifficationManager.CalculateResult calculateResult = this.precalculateAccountDetail(contractId, dateTo);
        if (calculateResult == null) {
            return null;
        }
        ServiceCostCache result = new ServiceCostCache();
        calculateResult.getProductAccountDeltaMonthMap().values().stream().map(Map::entrySet).flatMap(Collection::stream).filter(e -> e.getValue() != null && e.getKey() != null).forEach(e -> result.addAmount(new CostSum(contractId, ((TvTarifficationManager.ProductAccountKey)e.getKey()).serviceId, ((TvTarifficationManager.AccountDelta)e.getValue()).delta)));
        return result;
    }

    private TvTarifficationManager.CalculateResult precalculateAccountDetail(int contractId, java.util.Date dateTo, boolean accountDetail) throws Exception {
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.connectionSet, Integer.valueOf(contractId));
        if (contractRuntime == null) {
            logger.info("Contract not found with id: " + contractId);
            return null;
        }
        contractRuntime.lock();
        try {
            TvTarifficationManager.CalculateResult calculateResult = this.precalculateAccountDetail0(contractRuntime, contractId, dateTo, accountDetail);
            return calculateResult;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            contractRuntime.unlock();
        }
    }

    private TvTarifficationManager.CalculateResult precalculateAccountDetail0(ContractRuntime contractRuntime, int contractId, java.util.Date dateTo, boolean accountDetail) throws Exception {
        List<Entry> fullEntryList;
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar utilCalendar = new GregorianCalendar();
        TvTariffContext tvTariffContext = new TvTariffContext(this.connectionSet, this.moduleId, now.getTime(), TvTariffContext.TvTariffMode.precalculate);
        tvTariffContext.getTvAccountRuntimeMap().load(this.connectionSet, contractId);
        List<TvAccountRuntime> tvAccountRuntimeList = tvTariffContext.getTvAccountRuntimeMap().list(contractId);
        if (tvAccountRuntimeList == null || tvAccountRuntimeList.size() == 0) {
            logger.info("TvAccounts not found for contractId: " + contractId);
            return null;
        }
        ProductSpecRuntimeMap productSpecRuntimeMap = ProductSpecRuntimeMap.getInstance(this.connectionSet);
        TvTariffWorkerContext tvTariffWorkerContext = new TvTariffWorkerContext(this.context, this.moduleId);
        TvTarifficationManager tvTarifficationManager = new TvTarifficationManager(this.context.getSetup(), this.connectionSet, this.moduleId);
        TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);
        TariffModuleTreeSet tariffTreeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractRuntime.contractId, now.getTime(), "tv", this.moduleId, 0, 0);
        tariffModuleTreeSetDao.close();
        Set<Calendar> tariffPeriods = TvUtils.getTariffPeriods(new java.util.Date(), tariffTreeSet);
        Directory productSpecDirectory = tvTariffWorkerContext.getDirectory(ProductSpec.class, 0);
        HashMap<Integer, AccountData> accountDataMap = new HashMap<Integer, AccountData>();
        try {
            fullEntryList = this.getProductEntryList(tvTariffContext, (Directory<ProductSpec>)productSpecDirectory, tvTariffContext.getTvAccountRuntimeMap(), accountDataMap, contractId, dateTo, ProlongationType.normal);
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        Map<Integer, List<Entry>> entryListMap = fullEntryList.stream().collect(Collectors.groupingBy(a -> a.accountId));
        BigDecimal balance = BigDecimal.ZERO;
        Map<TvTarifficationManager.MonthKey, Map<TvTarifficationManager.ProductAccountKey, TvTarifficationManager.AccountDelta>> result = null;
        for (TvAccountRuntime _tvAccountRuntime : tvAccountRuntimeList) {
            if (_tvAccountRuntime.getTvAccount().getParentId() > 0) continue;
            TvAccountRuntimeRoot tvAccountRuntime = (TvAccountRuntimeRoot)_tvAccountRuntime;
            List<Entry> entryList = entryListMap.get(tvAccountRuntime.tvAccountId);
            if (entryList == null || entryList.size() == 0) continue;
            List<TvServiceCost> serviceCostList = TvUtils.createServiceCostListForRecalculate(productSpecRuntimeMap, entryList);
            for (TvServiceCost cost : serviceCostList) {
                utilCalendar.setTime(cost.periodTimeTo);
                if (utilCalendar.before(now)) {
                    cost.periodTimeFrom = now.getTime();
                } else {
                    ((Calendar)utilCalendar).add(13, 1);
                    utilCalendar.set(14, 0);
                    cost.periodTimeFrom = utilCalendar.getTime();
                }
                cost.periodTimeTo = dateTo;
            }
            ArrayList<TvServiceCost> workingServiceCostList = new ArrayList<TvServiceCost>(serviceCostList.size());
            HashSet<TvServiceCost> processedSet = new HashSet<TvServiceCost>();
            Calendar tariffPeriodStart = null;
            for (Calendar tariffPeriod : tariffPeriods) {
                if (tariffPeriodStart != null) {
                    TvTarifficationManager.CalculateResult calculateResult = TvRecalculator.calculatePart(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, tvAccountRuntime, tvAccountRuntime.tvAccountId, tariffTreeSet, tariffPeriodStart, tariffPeriod, serviceCostList, workingServiceCostList, processedSet, null, null, accountDetail, false, balance);
                    balance = calculateResult.getBalance();
                    result = result == null || result.size() == 0 ? calculateResult.getProductAccountDeltaMonthMap() : this.aggregateAccount(result, calculateResult.getProductAccountDeltaMonthMap());
                }
                tariffPeriodStart = tariffPeriod;
            }
            GregorianCalendar tariffPeriod = new GregorianCalendar();
            tariffPeriod.setTime(dateTo);
            TvTarifficationManager.CalculateResult calculateResult = TvRecalculator.calculatePart(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, tvAccountRuntime, tvAccountRuntime.tvAccountId, tariffTreeSet, tariffPeriodStart, tariffPeriod, serviceCostList, workingServiceCostList, processedSet, null, null, accountDetail, false, balance);
            balance = calculateResult.getBalance();
            if (result == null || result.size() == 0) {
                result = calculateResult.getProductAccountDeltaMonthMap();
                continue;
            }
            result = this.aggregateAccount(result, calculateResult.getProductAccountDeltaMonthMap());
        }
        if (balance != null && BigDecimal.ZERO.compareTo(balance) != 0) {
            balance = balance.negate();
        }
        if (result == null) {
            result = new HashMap<TvTarifficationManager.MonthKey, Map<TvTarifficationManager.ProductAccountKey, TvTarifficationManager.AccountDelta>>(4);
        }
        return new TvTarifficationManager.CalculateResult(null, balance, result);
    }

    private TvTarifficationManager.AccountDelta mergeAccount(TvTarifficationManager.AccountDelta d1, TvTarifficationManager.AccountDelta d2) {
        if (d2.delta != null && BigDecimal.ZERO.compareTo(d2.delta) != 0) {
            d1.delta = d1.delta.add(d2.delta);
        }
        return d1;
    }

    private Map<TvTarifficationManager.ProductAccountKey, TvTarifficationManager.AccountDelta> mergeAccountMap(Map<TvTarifficationManager.ProductAccountKey, TvTarifficationManager.AccountDelta> result, Map<TvTarifficationManager.ProductAccountKey, TvTarifficationManager.AccountDelta> map) {
        assert (result != null);
        assert (map != null);
        return Stream.of(result, map).map(Map::entrySet).flatMap(Collection::stream).filter(a -> ((TvTarifficationManager.AccountDelta)a.getValue()).delta != null && BigDecimal.ZERO.compareTo(((TvTarifficationManager.AccountDelta)a.getValue()).delta) != 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, this::mergeAccount));
    }

    private Map<TvTarifficationManager.MonthKey, Map<TvTarifficationManager.ProductAccountKey, TvTarifficationManager.AccountDelta>> aggregateAccount(Map<TvTarifficationManager.MonthKey, Map<TvTarifficationManager.ProductAccountKey, TvTarifficationManager.AccountDelta>> result, Map<TvTarifficationManager.MonthKey, Map<TvTarifficationManager.ProductAccountKey, TvTarifficationManager.AccountDelta>> productAccountDeltaMonthMap) {
        assert (result != null);
        if (productAccountDeltaMonthMap == null) {
            return result;
        }
        return Stream.of(result, productAccountDeltaMonthMap).map(Map::entrySet).flatMap(Collection::stream).filter(e -> e.getValue() != null && e.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, this::mergeAccountMap));
    }

    private static enum ProlongationPriority {
        PRIMARY,
        SECONDARY,
        TERTIARY;

    }

    private static class AccountData {
        final TvAccountRuntimeRoot account;
        final int deviceId;
        final int status;
        final short deviceState;
        final Set<Integer> deviceOptions;
        final List<ProductEntry> productEntryList = new ArrayList<ProductEntry>();
        final Set<Integer> newDeviceOptions = new HashSet<Integer>();

        public AccountData(TvAccountRuntimeRoot account, int deviceId, int status, short deviceState, Set<Integer> deviceOptions) {
            this.account = account;
            this.deviceId = deviceId;
            this.status = status;
            this.deviceState = deviceState;
            this.deviceOptions = Collections.unmodifiableSet(deviceOptions);
        }
    }

    public static class Entry {
        public final int accountId;
        public final int productPeriodId;
        public final java.util.Date productPeriodActivationTime;
        public final java.util.Date productPeriodTimeFrom;
        public final java.util.Date productPeriodTimeTo;
        public final java.util.Date productPeriodProlongationTime;
        public final int productPeriodFlags;
        public final int productId;
        public final int productSpecId;
        public final ProductSpec productSpec;
        public final int activationModeId;
        public final java.util.Date activationTime;
        public final BigDecimal activationPrice;
        public final java.util.Date productTimeFrom;
        public final java.util.Date productTimeTo;
        public final String deviceProductId;
        public final short deviceState;

        public Entry(int accountId, int productPeriodId, java.util.Date productPeriodActivationTime, java.util.Date productPeriodTimeFrom, java.util.Date productPeriodTimeTo, int productPeriodFlags, int productId, int productSpecId, ProductSpec productSpec, int activationModeId, java.util.Date activationTime, BigDecimal activationPrice, java.util.Date productTimeFrom, java.util.Date productTimeTo, String deviceProductId, short deviceState, java.util.Date productPeriodProlongationTime) {
            this.accountId = accountId;
            this.productPeriodId = productPeriodId;
            this.productPeriodActivationTime = productPeriodActivationTime;
            this.productPeriodTimeFrom = productPeriodTimeFrom;
            this.productPeriodTimeTo = productPeriodTimeTo;
            this.productPeriodProlongationTime = productPeriodProlongationTime;
            this.productPeriodFlags = productPeriodFlags;
            this.productId = productId;
            this.productSpecId = productSpecId;
            this.productSpec = productSpec;
            this.activationModeId = activationModeId;
            this.activationTime = activationTime;
            this.activationPrice = activationPrice;
            this.productTimeFrom = productTimeFrom;
            this.productTimeTo = productTimeTo;
            this.deviceProductId = deviceProductId;
            this.deviceState = deviceState;
        }

        public Product toProduct(int contractId, int accountId) {
            return Product.builder().setId(this.productId).setContractId(contractId).setAccountId(accountId).setProductSpecId(this.productSpecId).setTimeFrom(this.productTimeFrom).setTimeTo(this.productTimeTo).setActivationModeId(this.activationModeId).setSubscriptionTimeFrom(this.productPeriodTimeFrom).setSubscriptionTimeTo(this.productPeriodTimeTo).setDeviceProductId(this.deviceProductId).setDeviceState(this.deviceState).build();
        }
    }
}

