/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paykeeper.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.paykeeper.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paykeeper.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "paykeeper_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "create_date");
        this.fields.put("transactionDatetime", "transaction_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws SQLException {
        ResultSet rs;
        int index;
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        StringBuilder queryFromWhere = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true").append(this.queryPeriod(period, "pt.create_date"));
        if (Utils.notBlankString((String)status)) {
            queryFromWhere.append(" AND pt.status=?");
        }
        if (Utils.notBlankString((String)contractTitle)) {
            queryFromWhere.append(" AND c.title LIKE ?");
        }
        if (contractId > 0) {
            queryFromWhere.append(" AND c.id=").append(contractId);
        }
        String query = "SELECT pt.*, c.title AS contract_title" + queryFromWhere.toString() + this.getSQLOrder(sort, this.fields) + this.sqlLimit(page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = this.psSetPeriod(ps, 1, period);
            if (Utils.notBlankString((String)status)) {
                ps.setString(index++, status);
            }
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        ps = this.con.prepareStatement("SELECT SUM(pt.sum), COUNT(*) " + queryFromWhere.toString());
        try {
            index = this.psSetPeriod(ps, 1, period);
            if (Utils.notBlankString((String)status)) {
                ps.setString(index++, status);
            }
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    BigDecimal sum;
                    if (page != null) {
                        page.setRecordCount(rs.getInt(2));
                    }
                    if ((sum = rs.getBigDecimal(1)) == null) continue;
                    searchResult.setSum(sum);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionId(rs.getString("order_id"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setStatus(rs.getString("status"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).build();
    }

    protected Transaction getImpl(int transactionId) throws SQLException {
        return (Transaction)this.getById(transactionId);
    }

    protected String getQueryById() {
        return "SELECT pt.*, c.title AS contract_title FROM " + this.tableName + " AS pt LEFT JOIN contract AS c ON c.id=pt.contract_id WHERE pt.id=?";
    }

    public boolean update(Transaction transaction, TransactionStatus newTransactionStatus) throws SQLException {
        Objects.requireNonNull(transaction);
        Objects.requireNonNull(newTransactionStatus);
        boolean result = false;
        StringBuilder query = new StringBuilder("UPDATE ").append(this.tableName).append(" SET ").append("order_id=?, status=?").append(" WHERE ").append("status=? AND id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            int index = 1;
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, newTransactionStatus.getCode());
            ps.setString(index++, transaction.getStatus());
            ps.setInt(index++, transaction.getId());
            boolean bl = result = ps.executeUpdate() > 0;
            if (result) {
                transaction.setStatus(newTransactionStatus.getCode());
            }
        }
        return result;
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public void addTransactionPayment(Transaction transaction, String transactionParameters) throws Exception {
        if (this.update(transaction, TransactionStatus.APPROVED)) {
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            Payment payment = Payment.builder().setDate(new Date()).setTypeId(moduleSetup.getInt("paykeeper.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("paykeeper.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 PayKeeper").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).build();
            new PaymentDao(this.con).update((Object)payment);
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
            }
            transaction.setPaymentId(payment.getId());
            transaction.setTransactionDate(new Date());
            transaction.setParameters(transactionParameters);
            this.update(transaction);
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
        }
    }
}

