/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.moneta.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.moneta.common.bean.Transaction;
import ru.bitel.bgbilling.modules.moneta.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.moneta.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.Utils;

@WebServlet(name="MonetaExecutor", urlPatterns={"/moneta/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(ModuleExecutor.class);

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            TransactionManager transactionManager = new TransactionManager(con, moduleId);
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            String mntId = request.getParameter("MNT_ID");
            String mntTransactionId = request.getParameter("MNT_TRANSACTION_ID");
            String mntOperationId = request.getParameter("MNT_OPERATION_ID");
            String mntAmount = request.getParameter("MNT_AMOUNT");
            String mntCurrencyCode = request.getParameter("MNT_CURRENCY_CODE");
            String mntSubscriberId = request.getParameter("MNT_SUBSCRIBER_ID");
            String mntTetsMode = request.getParameter("MNT_TEST_MODE");
            String mntSignature = request.getParameter("MNT_SIGNATURE");
            String mntUser = request.getParameter("MNT_USER");
            String paymentSystemUnitId = request.getParameter("paymentSystem.unitId");
            String mntCorraccount = request.getParameter("MNT_CORRACCOUNT");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("MNT_ID = " + mntId);
                this.getLogger().debug("MNT_TRANSACTION_ID = " + mntTransactionId);
                this.getLogger().debug("MNT_OPERATION_ID = " + mntOperationId);
                this.getLogger().debug("MNT_AMOUNT = " + mntAmount);
                this.getLogger().debug("MNT_CURRENCY_CODE = " + mntCurrencyCode);
                this.getLogger().debug("MNT_SUBSCRIBER_ID = " + mntSubscriberId);
                this.getLogger().debug("MNT_TEST_MODE = " + mntTetsMode);
                this.getLogger().debug("MNT_SIGNATURE = " + mntSignature);
                this.getLogger().debug("MNT_USER = " + mntUser);
                this.getLogger().debug("MNT_CORRACCOUNT = " + mntCorraccount);
                this.getLogger().debug("paymentSystem.unitId = " + paymentSystemUnitId);
            }
            String signData = mntId + mntTransactionId + mntOperationId + mntAmount + mntCurrencyCode + (mntSubscriberId != null ? mntSubscriberId : "") + mntTetsMode + moduleSetup.get("moneta.sign.check.code", "");
            String sign = Utils.getDigest((String)signData, (String)"UTF-8");
            if (mntSignature == null || !mntSignature.equalsIgnoreCase(sign)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("signData = " + signData);
                    this.getLogger().debug("sign = " + sign);
                    this.getLogger().debug("mntSignature = " + mntSignature);
                }
                this.sendResponse(500, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 MNT_SIGNATURE", response);
                return;
            }
            Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)mntTransactionId));
            if (transaction == null) {
                this.sendResponse(500, "Not found transaction for ID = " + mntTransactionId, response);
                return;
            }
            if (transaction.getPaymentId() > 0) {
                this.sendResponse(200, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0436\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d \u0440\u0430\u043d\u0435\u0435", response);
                return;
            }
            Date now = new Date();
            Payment payment = null;
            if ("0".equals(mntTetsMode)) {
                payment = Payment.builder().setDate(now).setTypeId(moduleSetup.getInt("moneta.payment.type.id", -1)).setContractId(transaction.getContractId()).setSum(new BigDecimal(mntAmount)).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("moneta.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 Moneta.ru [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).build();
                new PaymentDao(con).update((Object)payment);
            }
            if (payment != null) {
                transaction.setPaymentId(payment.getId());
                try (BalanceUtils bu = new BalanceUtils(con);){
                    bu.updateBalance(payment.getDate(), transaction.getContractId());
                }
                EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
            }
            transaction.setTransactionId(mntOperationId);
            transaction.setStatus(TransactionStatus.OK.getCode());
            transaction.setTransactionDate(now);
            transaction.setParameters(this.getParameters(request.getParameterMap()));
            transactionManager.update(transaction);
            this.sendResponse(200, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d", response);
        }
        catch (Exception ex) {
            this.logError(ex);
            this.sendResponse(500, ex.getLocalizedMessage(), response);
        }
    }

    private void sendResponse(int statusCode, String message, HttpServletResponse response) {
        if (statusCode != 200) {
            this.getLogger().error(message);
        }
        try {
            response.setStatus(statusCode);
            response.setContentType("text/plain;charset=UTF-8");
            response.getWriter().print((statusCode == 200 ? "SUCCESS" : "FAIL") + "\n" + message);
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getParameters(Map<String, String[]> data) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String[]> entry : data.entrySet()) {
            for (String value : entry.getValue()) {
                if (result.length() != 0) {
                    result.append("\n");
                }
                result.append(entry.getKey()).append("=").append(value);
            }
        }
        return result.toString();
    }
}

