/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.mail.server.handler;

import jakarta.mail.internet.MimeBodyPart;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.common.bean.MailConfig;
import ru.bitel.bgbilling.kernel.admin.mail.common.handler.MailConfigAbstractHandler;
import ru.bitel.bgbilling.kernel.admin.mail.common.handler.MailConfigHandler;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.common.Utils;

public class MailConfigDefaultHandler
extends MailConfigAbstractHandler
implements MailConfigHandler {
    @Override
    public void applyMailConfig(MailData mailData, MailConfig mailConfig) throws BGException {
        if (mailConfig != null) {
            MimeBodyPart mimeBodyPart;
            if (mailConfig.getSubjectMode() == MailConfig.SubjectMode.CUSTOM) {
                mailData.setSubject(mailConfig.getSubjectCustom());
            }
            String patternData = null;
            if (mailConfig.getPatternMode() == MailConfig.PatternMode.DEFAULT) {
                if (Utils.notBlankString((String)mailConfig.getPatternDefault())) {
                    patternData = mailConfig.getPatternDefault();
                }
            } else if (mailConfig.getPatternMode() == MailConfig.PatternMode.CUSTOM && Utils.notBlankString((String)mailConfig.getPatternCustom())) {
                patternData = mailConfig.getPatternCustom();
            }
            if (patternData != null && (mimeBodyPart = mailData.getMimeBodyPart("text")) != null) {
                try {
                    mimeBodyPart.setText(patternData.replaceAll("\\{\\{BODY\\}\\}", String.valueOf(mimeBodyPart.getContent())), "UTF-8");
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
    }
}

