/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.ref;

import java.lang.ref.Reference;
import java.util.Iterator;

public class ReferenceIterator<V>
implements Iterator<V> {
    private final Iterator<Reference<V>> iterator;
    private V next;

    public ReferenceIterator(Iterator<Reference<V>> iterator) {
        this.iterator = iterator;
        this.advance();
    }

    private void advance() {
        while (this.iterator.hasNext()) {
            V v;
            Reference<V> next = this.iterator.next();
            if (next == null || (v = next.get()) == null) continue;
            this.next = v;
            return;
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public V next() {
        V result = this.next;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

