/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.map.kernel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.CompoundPainter;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.GeoPosition;
import ru.bitel.bgbilling.kernel.map.bean.MapMarker;
import ru.bitel.bgbilling.kernel.map.bean.MapTrack;
import ru.bitel.bgbilling.kernel.map.bean.PointPair;
import ru.bitel.bgbilling.kernel.map.graphics.BGWaypoint;
import ru.bitel.bgbilling.kernel.map.graphics.BGWaypointPainter;
import ru.bitel.bgbilling.kernel.map.graphics.MapTrackRoutePainter;
import ru.bitel.bgbilling.kernel.map.graphics.PointPairsRoutePainter;
import ru.bitel.bgbilling.kernel.map.kernel.DefaultMapViewer;

public class MapViewerHelper {
    private final DefaultMapViewer mapViewer;

    public MapViewerHelper(DefaultMapViewer mapViewer) {
        this.mapViewer = mapViewer;
        this.mapViewer.setHelper(this);
    }

    public void setTrackToBetweenPoints(List<PointPair> pairs) {
        PointPairsRoutePainter defaultRoutePainter = new PointPairsRoutePainter(pairs);
        List<MapMarker> points = this.pointPairsToMapMarkerList(pairs);
        BGWaypointPainter waypointPainter = new BGWaypointPainter();
        List<BGWaypoint> waypoints = points.stream().map(BGWaypoint::new).collect(Collectors.toList());
        waypointPainter.setWaypoints(waypoints);
        ArrayList<Object> painters = new ArrayList<Object>();
        painters.add((Object)waypointPainter);
        painters.add(defaultRoutePainter);
        if (this.mapViewer.getOverlayPainter() == null) {
            this.revalidateMapViewer((Painter<? super JXMapViewer>)new CompoundPainter(painters), points, waypoints);
            return;
        }
        this.revalidateMapViewer((Painter<? super JXMapViewer>)new CompoundPainter(painters), points, waypoints);
    }

    private List<MapMarker> pointPairsToMapMarkerList(List<PointPair> pairs) {
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        for (PointPair pair : pairs) {
            markers.add(pair.getFirstPoint());
            if (pair.getSecondPoint() == null) continue;
            markers.add(pair.getSecondPoint());
        }
        return markers;
    }

    public void addTrackToMap(MapTrack track) {
        if (track == null) {
            return;
        }
        if (this.mapViewer.getOverlayPainter() == null) {
            this.setTrackToMap(track);
            return;
        }
        BGWaypointPainter bgWaypointPainter = this.findBGWaypointPainter();
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        if (bgWaypointPainter != null) {
            markers.addAll(bgWaypointPainter.getWaypointList().stream().map(BGWaypoint::getMapMarker).toList());
        }
        markers.addAll(track.getPoints());
        this.setTrackToMap(new MapTrack(markers));
    }

    public void setTrackToMap(MapTrack track) {
        MapTrackRoutePainter mapTrackRoutePainter = new MapTrackRoutePainter(track);
        BGWaypointPainter waypointPainter = new BGWaypointPainter();
        List<BGWaypoint> waypoints = track.getPoints().stream().map(BGWaypoint::new).collect(Collectors.toList());
        waypointPainter.setWaypoints(waypoints);
        ArrayList<Object> painters = new ArrayList<Object>();
        painters.add((Object)waypointPainter);
        painters.add(mapTrackRoutePainter);
        if (this.mapViewer.getOverlayPainter() == null) {
            this.revalidateMapViewer((Painter<? super JXMapViewer>)new CompoundPainter(painters), track.getPoints(), waypoints);
            return;
        }
        this.revalidateMapViewer((Painter<? super JXMapViewer>)new CompoundPainter(painters), track.getPoints(), waypoints);
    }

    public void revalidateMapViewer(Painter<? super JXMapViewer> painter, List<MapMarker> mapMarkers, List<BGWaypoint> waypoints) {
        for (Component component : this.mapViewer.getComponents()) {
            this.mapViewer.remove(component);
        }
        this.mapViewer.setOverlayPainter(painter);
        if (this.mapViewer.getZoom() == 0) {
            this.mapViewer.zoomToBestFit(new HashSet<MapMarker>(mapMarkers), 0.7);
        }
        for (BGWaypoint waypoint : waypoints) {
            if (!waypoint.getMapMarker().isVisible()) continue;
            this.mapViewer.add(waypoint.getViewComponent());
        }
        this.mapViewer.revalidate();
        this.mapViewer.repaint();
    }

    public void addItemsToMap(List<MapMarker> items) {
        if (items == null) {
            return;
        }
        if (this.mapViewer.getOverlayPainter() == null) {
            this.setItemsToMap(items);
            return;
        }
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        BGWaypointPainter bgWaypointPainter = this.findBGWaypointPainter();
        if (bgWaypointPainter != null) {
            markers.addAll(bgWaypointPainter.getWaypointList().stream().map(BGWaypoint::getMapMarker).toList());
        }
        markers.addAll(items);
        if (bgWaypointPainter == null) {
            bgWaypointPainter = new BGWaypointPainter();
        }
        List<BGWaypoint> waypoints = markers.stream().map(BGWaypoint::new).collect(Collectors.toList());
        bgWaypointPainter.setWaypoints(waypoints);
        this.revalidateMapViewer((Painter<? super JXMapViewer>)bgWaypointPainter, markers, waypoints);
    }

    public List<MapMarker> getMapItems() {
        ArrayList<MapMarker> result = new ArrayList<MapMarker>();
        BGWaypointPainter bgWaypointPainter = this.findBGWaypointPainter();
        if (bgWaypointPainter != null) {
            result.addAll(bgWaypointPainter.getWaypointList().stream().map(BGWaypoint::getMapMarker).toList());
        }
        return result;
    }

    public List<BGWaypoint> getWaypoints() {
        ArrayList<BGWaypoint> result = new ArrayList<BGWaypoint>();
        BGWaypointPainter bgWaypointPainter = this.findBGWaypointPainter();
        if (bgWaypointPainter != null) {
            result.addAll(bgWaypointPainter.getWaypointList());
        }
        return result;
    }

    public void setItemsToMap(List<MapMarker> items) {
        if (items == null) {
            return;
        }
        BGWaypointPainter waypointPainter = new BGWaypointPainter();
        List<BGWaypoint> waypoints = items.stream().map(BGWaypoint::new).collect(Collectors.toList());
        waypointPainter.setWaypoints(waypoints);
        this.revalidateMapViewer((Painter<? super JXMapViewer>)waypointPainter, items, waypoints);
    }

    private BGWaypointPainter findBGWaypointPainter() {
        Painter painter = this.mapViewer.getOverlayPainter();
        if (painter instanceof BGWaypointPainter) {
            return (BGWaypointPainter)painter;
        }
        if (painter instanceof CompoundPainter) {
            for (Object p : ((CompoundPainter)painter).getPainters()) {
                if (!(p instanceof BGWaypointPainter)) continue;
                return (BGWaypointPainter)((Object)p);
            }
        }
        return null;
    }

    public JXMapViewer getMapViewer() {
        return this.mapViewer;
    }

    public void setZoom(int zoom) {
        this.mapViewer.setZoom(zoom);
    }

    public void setAddressLocation(GeoPosition addressLocation) {
        this.mapViewer.setAddressLocation(addressLocation);
    }
}

