/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.client.RoleEditor;
import ru.bitel.bgbilling.kernel.bgsecure.client.RoleTreeTablePanel;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.module.common.event.PermissionKitUpdateEvent;
import ru.bitel.common.client.AbstractBGUPanel;

public class RolePanel
extends BGUPanel
implements EventSubscriber<PermissionKitUpdateEvent> {
    private RoleEditor roleEditor;
    protected RoleService roleService;
    protected RoleTreeTablePanel roleTreeTablePanel;

    public RolePanel(RoleService roleService) {
        this.roleService = roleService;
    }

    @Override
    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, this.getRoleTreeTablePanel(), (Component)this.getEditorPanel(), 500L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        EventBus.subscribe(PermissionKitUpdateEvent.class, (EventSubscriber)this);
    }

    public void onEvent(PermissionKitUpdateEvent event) {
        this.performAction("refresh");
        this.roleEditor.onEvent(null);
    }

    private JPanel getRoleTreeTablePanel() throws BGException {
        if (this.roleTreeTablePanel == null) {
            this.roleTreeTablePanel = new RoleTreeTablePanel();
            this.roleTreeTablePanel.getTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        RolePanel.this.roleTreeTablePanel.getSelectedRole().ifPresent(role -> RolePanel.this.tryCall(() -> RolePanel.this.roleEditor.openEditor(RolePanel.this.roleService.getByRoleId(role.getId()))));
                    }
                }
            });
        }
        return this.roleTreeTablePanel;
    }

    private JPanel getEditorPanel() {
        this.roleEditor = new RoleEditor(this);
        this.roleEditor.setVisible(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.roleEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.roleTreeTablePanel.setRoles(this.roleService.getRoleItems(true, false)));
        new AbstractBGUPanel.BGActionNew(e -> this.roleEditor.openEditor(null));
        new AbstractBGUPanel.BGActionEdit(e -> this.roleTreeTablePanel.getSelectedRole().ifPresent(role -> this.tryCall(() -> this.roleEditor.openEditor(this.roleService.getByRoleId(role.getId())))));
        new AbstractBGUPanel.BGActionDelete(e -> this.roleTreeTablePanel.getSelectedRole().ifPresent(role -> {
            if (ClientUtils.confirmDelete(role.getTitle())) {
                this.tryCall(() -> this.roleService.deleteRoleById(role.getId()));
                this.performAction("refresh");
            }
        }));
    }
}

