/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.device;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Id;
import ru.bitel.oss.systems.inventory.resource.client.device.DeviceFormMain;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class InetDeviceFormMain
extends DeviceFormMain<InetDevice, InetDeviceType> {
    private BGIntTextField svlan = new BGIntTextField();
    AbstractBGUPanel.DefaultAction freeVlan = new AbstractBGUPanel.DefaultAction("find.vlan.resource", "<<<"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            int parentId = 0;
            parentId = ((InetDevice)InetDeviceFormMain.this.current).getId() <= 0 ? InetDeviceFormMain.this.devicePanel.getModel().optSelectedRow().map(parent -> parent.getId()).orElse(parentId).intValue() : ((InetDevice)InetDeviceFormMain.this.current).getParentId();
            if (parentId > 0) {
                InetDeviceService deviceService = (InetDeviceService)((ClientContext)InetDeviceFormMain.this.getContext()).getPort(InetDeviceService.class);
                ResourceService resourceService = (ResourceService)((ClientContext)InetDeviceFormMain.this.getContext()).getPort(ResourceService.class);
                Set vlanResourceCategoryIds = deviceService.svlanResourceCategoryIds(parentId);
                int vlanId = resourceService.freeVlan(vlanResourceCategoryIds, InetDeviceFormMain.this.period.getDateFrom(), InetDeviceFormMain.this.period.getDateTo());
                InetDeviceFormMain.this.svlan.setText(String.valueOf(vlanId));
            }
        }
    };

    public InetDeviceFormMain(DevicePanel<InetDevice, InetDeviceType> devicePanel, AtomicReference<InetDevice> currentRef) {
        super(devicePanel, currentRef, "inet");
    }

    protected void jbInit() {
        super.jbInit();
    }

    protected void addPanelAfterSecret() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.svlan, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new BGButton((Action)this.freeVlan), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        JPanel svlanPanel = new JPanel(new GridBagLayout());
        svlanPanel.add((Component)new JLabel("SVLAN:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        svlanPanel.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        this.paramPanel.add((Component)svlanPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void showCustomValues() {
        this.svlan.setText(((InetDevice)this.current).getSvlan() < 0 ? "" : String.valueOf(((InetDevice)this.current).getSvlan()));
    }

    protected void saveCustomValues() {
        ((InetDevice)this.current).setSvlan(Utils.parseInt((String)this.svlan.getText(), (int)-1));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.current = (Device)this.currentRef.get();
            ((InetDevice)this.current).setId(-1);
            ((InetDevice)this.current).setEntityAttributes(new HashMap());
            InetDevice parent = (InetDevice)this.devicePanel.getModel().getSelectedRow();
            if (parent != null) {
                ((InetDevice)this.current).setParentId(parent.getId());
            }
            this.deviceId.setText("");
            this.deviceTitle.setText("");
            this.identifier.setText("");
            this.host.setText("");
            this.period.setLocalDateFrom(null);
            this.period.setLocalDateTo(null);
            this.user.setText("");
            this.password.setText("");
            this.secret.setText("");
            List deviceTypeList = ((ClientContext)this.getContext()).getDirectory(InetDeviceType.class).list();
            this.initDeviceTypeCombobox(deviceTypeList);
            if (this.customDeviceType != null) {
                this.initCustomDeviceTypeCombo(deviceTypeList);
            }
            DeviceGroup deviceGroupRoot = this.wsDevice.deviceGroupRoot();
            this.deviceGroup.setData((Id)deviceGroupRoot);
            this.deviceGroup.expand();
            if (this.customDeviceGroup != null) {
                this.customDeviceGroup.setData((Id)deviceGroupRoot);
                this.customDeviceGroup.expand();
            }
            this.orderManagerDisabled.setSelected(false);
            this.comment.setText("");
            this.config.setText("");
            if (this.customConfig != null) {
                this.customConfig.setText("");
            }
            this.svlan.setText("");
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.current = (Device)this.currentRef.get();
            if (this.current != null) {
                this.deviceId.setText(String.format("%d", ((InetDevice)this.current).getId()));
                this.deviceTitle.setText(((InetDevice)this.current).getTitle());
                this.identifier.setText(((InetDevice)this.current).getInvIdentifier());
                this.customIdentifier.setText(!((InetDevice)this.current).getInvIdentifier().equals(((InetDevice)this.current).getIdentifier()) ? ((InetDevice)this.current).getIdentifier() : "");
                this.host.setText(((InetDevice)this.current).getInvHost());
                this.customHost.setText(!((InetDevice)this.current).getInvHost().equals(((InetDevice)this.current).getHost()) ? ((InetDevice)this.current).getHost() : "");
                this.period.setDateFrom(((InetDevice)this.current).getDateFrom());
                this.period.setDateTo(((InetDevice)this.current).getDateTo());
                this.user.setText(((InetDevice)this.current).getUsername());
                this.password.setText(((InetDevice)this.current).getPassword());
                this.secret.setText(((InetDevice)this.current).getSecret());
                List deviceTypeList = ((ClientContext)this.getContext()).getDirectory(InetDeviceType.class).list();
                this.initDeviceTypeCombobox(deviceTypeList);
                if (this.customDeviceType != null) {
                    this.initCustomDeviceTypeCombo(deviceTypeList);
                }
                this.deviceType.setSelectedItem((Object)((InetDevice)this.current).getInvDeviceTypeId());
                if (((InetDevice)this.current).getInvDeviceTypeId() != ((InetDevice)this.current).getDeviceTypeId()) {
                    this.customDeviceType.setSelectedItem((Object)((InetDevice)this.current).getDeviceTypeId());
                }
                this.orderManagerDisabled.setSelected(((InetDevice)this.current).isOrderManagerDisabled());
                DeviceGroup deviceGroupRoot = this.wsDevice.deviceGroupRoot();
                this.deviceGroup.setData((Id)deviceGroupRoot, ((InetDevice)this.current).getInvDeviceGroupIds() != null ? ((InetDevice)this.current).getInvDeviceGroupIds() : Collections.emptySet());
                this.deviceGroup.expand();
                if (this.customDeviceGroup != null) {
                    this.customDeviceGroup.setData((Id)deviceGroupRoot, ((InetDevice)this.current).getDeviceGroupIds() != null ? ((InetDevice)this.current).getDeviceGroupIds() : Collections.emptySet());
                    this.customDeviceGroup.expand();
                }
                this.comment.setText(((InetDevice)this.current).getComment());
                this.config.setText(((InetDevice)this.current).getInvConfig());
                this.customConfig.setText(((InetDevice)this.current).getConfig());
                this.svlan.setText(((InetDevice)this.current).getSvlan() < 0 ? "" : String.valueOf(((InetDevice)this.current).getSvlan()));
            }
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (InetDeviceFormMain.this.deviceType.getSelectedItem() == null) {
                    return;
                }
                ((InetDevice)InetDeviceFormMain.this.current).setInvDeviceTypeId(((InetDeviceType)InetDeviceFormMain.this.deviceType.getSelectedItem()).getId());
                ((InetDevice)InetDeviceFormMain.this.current).setDeviceTypeId(((InetDeviceType)InetDeviceFormMain.this.customDeviceType.getSelectedItem()).getId());
                ((InetDevice)InetDeviceFormMain.this.current).setInvDeviceGroupIds(InetDeviceFormMain.this.deviceGroup.getChecked());
                ((InetDevice)InetDeviceFormMain.this.current).setDeviceGroupIds(InetDeviceFormMain.this.customDeviceGroup.getChecked());
                ((InetDevice)InetDeviceFormMain.this.current).setInvIdentifier(InetDeviceFormMain.this.identifier.getText());
                ((InetDevice)InetDeviceFormMain.this.current).setIdentifier(Utils.notBlankString((String)InetDeviceFormMain.this.customIdentifier.getText()) ? InetDeviceFormMain.this.customIdentifier.getText() : null);
                ((InetDevice)InetDeviceFormMain.this.current).setInvHost(InetDeviceFormMain.this.host.getText());
                ((InetDevice)InetDeviceFormMain.this.current).setHost(Utils.notBlankString((String)InetDeviceFormMain.this.customHost.getText()) ? InetDeviceFormMain.this.customHost.getText() : null);
                ((InetDevice)InetDeviceFormMain.this.current).setDateFrom(InetDeviceFormMain.this.period.getDateFrom());
                ((InetDevice)InetDeviceFormMain.this.current).setDateTo(InetDeviceFormMain.this.period.getDateTo());
                ((InetDevice)InetDeviceFormMain.this.current).setUsername(InetDeviceFormMain.this.user.getText());
                ((InetDevice)InetDeviceFormMain.this.current).setPassword(new String(InetDeviceFormMain.this.password.getPassword()));
                ((InetDevice)InetDeviceFormMain.this.current).setSecret(new String(InetDeviceFormMain.this.secret.getPassword()));
                ((InetDevice)InetDeviceFormMain.this.current).setInvConfig(InetDeviceFormMain.this.config.getText());
                ((InetDevice)InetDeviceFormMain.this.current).setComment(InetDeviceFormMain.this.comment.getText());
                ((InetDevice)InetDeviceFormMain.this.current).setConfig(InetDeviceFormMain.this.customConfig.getText());
                ((InetDevice)InetDeviceFormMain.this.current).setOrderManagerDisabled(InetDeviceFormMain.this.orderManagerDisabled.isSelected());
                ((InetDevice)InetDeviceFormMain.this.current).setSvlan(Utils.parseInt((String)InetDeviceFormMain.this.svlan.getText(), (int)-1));
            }
        };
        final HashSet cutSet = new HashSet();
        new AbstractBGUPanel.MenuAction("device.cut", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", ClientUtils.getIcon((String)"cut")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                cutSet.clear();
                InetDeviceFormMain.this.devicePanel.getModel().optSelectedRows().ifPresent(a -> a.forEach(d -> cutSet.add(d.getId())));
            }
        };
        new AbstractBGUPanel.MenuAction("device.paste", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", ClientUtils.getIcon((String)"paste")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetDevice parent = (InetDevice)InetDeviceFormMain.this.devicePanel.getModel().getSelectedRow();
                if (parent != null && cutSet.size() > 0) {
                    InetDeviceFormMain.this.devicePanel.deviceMove(parent.getId(), cutSet);
                    cutSet.clear();
                    InetDeviceFormMain.this.devicePanel.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.MenuAction("device.delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", ClientUtils.getIcon((String)"delete")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetDeviceFormMain.this.devicePanel.performAction("delete");
            }
        };
    }
}

