/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.contract;

import bitel.billing.module.common.BGUndoManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.TextAction;
import javax.swing.text.rtf.RTFEditorKit;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Russian;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class HelpdeskMessagePaneRTF
extends JTextPane {
    private RTFEditorKit editorKit = new RTFEditorKit();
    private DefaultStyledDocument doc = new CyrilicDocument();
    private BGUndoManager man = new BGUndoManager();
    private JLanguageTool langTool;

    public HelpdeskMessagePaneRTF() {
        this.setEditorKit(this.editorKit);
        this.setContentType(this.editorKit.getContentType());
        this.setDocument(this.doc);
        this.langTool = new JLanguageTool((Language)new Russian());
        for (Rule rule : this.langTool.getAllRules()) {
            if (rule.isDictionaryBasedSpellingRule()) continue;
            this.langTool.disableRule(rule.getId());
        }
        final ActionListener itemAction = e -> {
            try {
                JMenuItem item = (JMenuItem)e.getSource();
                JPopupMenu menu = (JPopupMenu)item.getParent();
                WordData data = (WordData)menu.getClientProperty("data");
                this.doc.replace(data.fP, data.length, item.getText(), null);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int position;
                if (e.getButton() == 3) {
                    HelpdeskMessagePaneRTF.this.setCaretPosition(HelpdeskMessagePaneRTF.this.viewToModel(e.getPoint()));
                }
                if ((position = HelpdeskMessagePaneRTF.this.getCaretPosition()) <= HelpdeskMessagePaneRTF.this.doc.getLength()) {
                    if (e.getButton() == 1) {
                        return;
                    }
                    try {
                        Element ele = HelpdeskMessagePaneRTF.this.doc.getCharacterElement(position);
                        AttributeSet as = ele.getAttributes();
                        WordData wordData = (WordData)as.getAttribute("linkact");
                        if (wordData != null) {
                            wordData.fP = ele.getStartOffset();
                            wordData.length = ele.getEndOffset() - ele.getStartOffset();
                            JPopupMenu menu = new JPopupMenu();
                            menu.putClientProperty("data", wordData);
                            if (wordData.listSuggest.size() > 0) {
                                for (int i = 0; i < wordData.listSuggest.size() && i < 10; ++i) {
                                    JMenuItem item = new JMenuItem(wordData.listSuggest.get(i));
                                    menu.add(item);
                                    item.addActionListener(itemAction);
                                }
                            } else {
                                JMenuItem item = new JMenuItem("<html>  <p style=\"color:#ff0000\">\u041d\u0435\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0439 \u0437\u0430\u043c\u0435\u043d\u044b</p> </html>");
                                menu.add(item);
                            }
                            menu.show(HelpdeskMessagePaneRTF.this, e.getX(), e.getY());
                        }
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isValidCodePoint(e.getKeyChar())) {
                    try {
                        MutableAttributeSet atr = HelpdeskMessagePaneRTF.this.getInputAttributes();
                        StyleConstants.setUnderline(atr, false);
                        HelpdeskMessagePaneRTF.this.getDocument().insertString(HelpdeskMessagePaneRTF.this.getCaretPosition(), "", atr);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
        TextAction actionPast = new TextAction("paste-from-clipboard"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    HelpdeskMessagePaneRTF.this.doc.replace(HelpdeskMessagePaneRTF.this.getSelectionStart(), HelpdeskMessagePaneRTF.this.getSelectionEnd() - HelpdeskMessagePaneRTF.this.getSelectionStart(), data, null);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        };
        this.getActionMap().put("paste-from-clipboard", actionPast);
        this.man.setActionUndoAndRedo((JTextComponent)this);
    }

    @Override
    public void setText(String t) {
        String s = "{\\rtf1\\f1\\i0\\b0\\cf0 " + t.replace("\\", "\\\\").replaceAll("\n", "\\\\par\n").replace("{", "\\{").replace("}", "\\}") + "}";
        super.setText(s);
        this.setCaretPosition(0);
        this.man.discardAllEdits();
    }

    @Override
    public String getText() {
        StringBuilder str = new StringBuilder();
        try {
            Segment text = new Segment();
            text.setPartialReturn(true);
            int nleft = this.doc.getLength();
            int offs = 0;
            while (nleft > 0) {
                this.doc.getText(offs, nleft, text);
                str.append(text.toString());
                nleft -= text.count;
                offs += text.count;
            }
        }
        catch (BadLocationException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        return str.toString();
    }

    public void checkSpell() {
        try {
            if (!this.isEditable() || !this.editorKit.getContentType().equals(this.getContentType())) {
                return;
            }
            int caretPosition = this.getCaretPosition();
            this.setText(this.getText());
            String text = this.getText();
            Pattern patternRus = Pattern.compile("[\u0430-\u044f\u0410-\u042f]");
            List matches = this.langTool.check(text);
            block2: for (RuleMatch match : matches) {
                String wrongWord = text.substring(match.getFromPos(), match.getToPos());
                Matcher matcherRus = patternRus.matcher(wrongWord);
                MutableAttributeSet atr = this.getInputAttributes();
                StyleConstants.setUnderline(atr, true);
                if (!match.getShortMessage().equals("\u041e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430") || !matcherRus.lookingAt()) continue;
                ArrayList<CallSite> replaceWords = match.getSuggestedReplacements();
                if (replaceWords.size() > 0) {
                    if (wrongWord.charAt(0) == wrongWord.toUpperCase().charAt(0)) {
                        replaceWords = new ArrayList<CallSite>();
                        for (String string : match.getSuggestedReplacements()) {
                            replaceWords.add((CallSite)((Object)(string.substring(0, 1).toUpperCase() + string.substring(1))));
                        }
                    } else {
                        for (String string : replaceWords) {
                            if (string.length() != wrongWord.length() || !wrongWord.replaceAll("\u0435", "\u0451").equals(string)) continue;
                            this.doc.replace(match.getFromPos(), string.length(), string, null);
                            continue block2;
                        }
                    }
                }
                atr.addAttribute("linkact", new WordData(this, (List<String>)replaceWords));
                this.doc.replace(match.getFromPos(), wrongWord.length(), wrongWord, atr);
            }
            this.setCaretPosition(caretPosition);
            this.requestFocus();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public class CyrilicDocument
    extends DefaultStyledDocument {
        boolean reading = false;

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.isReading()) {
                try {
                    str = new String(str.getBytes("ISO-8859-1"), "cp1251");
                }
                catch (UnsupportedEncodingException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            super.insertString(offs, str, a);
        }

        public void setReadingProcess(boolean readingO) {
            this.reading = readingO;
        }

        public boolean isReading() {
            return this.reading;
        }
    }

    private class WordData {
        public List<String> listSuggest;
        public int fP;
        public int length;

        WordData(HelpdeskMessagePaneRTF helpdeskMessagePaneRTF, List<String> listSuggest) {
            this.listSuggest = listSuggest;
        }
    }
}

