/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.traffic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import ru.bitel.bgbilling.modules.dialup.server.traffic.Traffic;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class NASServiceConfig {
    private Logger logger;
    private Map<String, Properties> time_services = new HashMap<String, Properties>();
    private Map<String, Properties> traffics = new HashMap<String, Properties>();

    public NASServiceConfig(ParameterMap setup, Logger logger) {
        this.logger = logger;
        String prefix = null;
        prefix = "nas.port_traffic.";
        this.traffics = this.parsePortRealmServices(setup.sub(prefix));
        prefix = "nas.port_time.";
        this.time_services = this.parsePortRealmServices(setup.sub(prefix));
    }

    private Map<String, Properties> parsePortRealmServices(ParameterMap data) {
        HashMap<String, Properties> services = new HashMap<String, Properties>();
        if (data != null) {
            for (Map.Entry me : data.entrySet()) {
                Properties prop;
                String name = (String)me.getKey();
                String val = (String)me.getValue();
                boolean f1 = false;
                boolean f2 = false;
                StringBuffer buf1 = new StringBuffer();
                StringBuffer buf2 = new StringBuffer();
                for (int i = 0; i < name.length(); ++i) {
                    char ch = name.charAt(i);
                    if (ch == '.') {
                        if (f1) {
                            f2 = true;
                            break;
                        }
                        f1 = true;
                        continue;
                    }
                    if (f1) {
                        buf2.append(ch);
                        continue;
                    }
                    buf1.append(ch);
                }
                if (f2 || f1 && (buf1.length() == 0 || buf2.length() == 0)) continue;
                String realm = "default";
                if (f1) {
                    realm = buf1.toString();
                    name = buf2.toString();
                }
                if ((prop = (Properties)services.get(realm)) == null) {
                    prop = new Properties();
                    services.put(realm, prop);
                }
                prop.setProperty(name, val);
            }
        }
        return services;
    }

    public int getTimeService(String realm, String port) {
        return Utils.parseInt((String)this.getValueFromHash(this.time_services, realm, port), (int)-1);
    }

    public List<Traffic> getTrafficConfig(String realm, String port) {
        ArrayList<Traffic> result = null;
        String trafficConfig = this.getValueFromHash(this.traffics, realm, port);
        if (trafficConfig != null) {
            if (Utils.isBlankString((String)trafficConfig)) {
                result = new ArrayList<Traffic>();
            } else {
                String[] configItems = trafficConfig.split(";");
                if (configItems != null && configItems.length > 0) {
                    result = new ArrayList(configItems.length);
                    String item = null;
                    Traffic traffic = null;
                    for (int i = 0; i < configItems.length; ++i) {
                        item = configItems[i].trim();
                        String[] sidAndType = item.split(":");
                        if (sidAndType == null || sidAndType.length != 2) {
                            this.logger.error("wrong traffic config item: " + item);
                            continue;
                        }
                        traffic = new Traffic();
                        traffic.setServiceId(Utils.parseInt((String)sidAndType[0].trim(), (int)-1));
                        traffic.setTrafficSourceFromString(sidAndType[1].trim());
                        if (traffic.getServiceId() <= 0) {
                            this.logger.error("wrong service id in traffic config:" + sidAndType[0].trim());
                            continue;
                        }
                        if (traffic.getTrafficSource() <= 0) {
                            this.logger.error("wrong traffic source ( mast be RADIN | RADOUT | COLLECTOR )");
                            continue;
                        }
                        result.add(traffic);
                    }
                }
            }
        }
        return result;
    }

    private String getValueFromHash(Map<String, Properties> services, String realm, String port) {
        Properties prop;
        String result = null;
        if (services == null || port == null) {
            return null;
        }
        if (realm == null) {
            realm = "default";
        }
        if ((prop = services.get(realm)) != null && (result = prop.getProperty(port)) == null) {
            result = prop.getProperty("*");
        }
        return result;
    }
}

