/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;

public class EmailMaster
extends BGLogger {
    private int userId;
    private int moduleId;
    private DocumentSendParameters.SendingDataType type;
    private boolean sendSubAsParent;
    private final Setup setup;
    private final Connection con;
    private final Preferences moduleSetup;
    private AbstractManager billManager;
    private ContractDao contractDao;
    private ContractManager contractManager;
    private int id;
    private byte[] data;
    private BillDoc billDocInfo;
    private int contractId;
    private int subContractId;
    private Contract contract;
    private Contract subContract;

    public EmailMaster(Setup setup, Connection con, int moduleId, int userId) {
        this.con = con;
        this.setup = setup;
        this.moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId));
        this.moduleId = moduleId;
        this.sendSubAsParent = this.moduleSetup.getBoolean("mail.send.sub.as.parent", false);
        this.userId = userId;
        this.contractDao = new ContractDao(con, userId);
        this.contractManager = new ContractManager(con);
    }

    public EmailMaster setDocumentId(DocumentSendParameters.SendingDataType type, int id) {
        this.id = id;
        this.type = type;
        this.billManager = type.equals((Object)DocumentSendParameters.SendingDataType.BILL) ? new BillManager(this.con, this.moduleId) : new InvoiceManager(this.con, this.moduleId);
        this.data = this.billManager.getXMLData(id);
        try {
            this.billDocInfo = this.billManager.getBillDocInfo(id);
        }
        catch (Exception ex) {
            this.getLogger().error("id={}, type={} [{}]", new Object[]{id, type, ex});
        }
        return this;
    }

    public EmailMaster setContractId(int contractId) {
        this.subContractId = this.contractId = contractId;
        if (contractId <= 0) {
            this.subContractId = this.contractId = this.billDocInfo.getContractId();
        }
        this.subContract = this.contract = this.contractManager.getContractById(this.contractId);
        if (this.sendSubAsParent && this.contract.isSub()) {
            this.contractId = this.contract.getSuperId();
            this.contract = this.contractManager.getContractById(this.contractId);
            this.getLogger().debug("document for contractId {} send as for contractId {}", (Object)this.billDocInfo.getContractId(), (Object)this.contractId);
        }
        return this;
    }

    public String getEmail() throws BGException {
        int parameterId = this.moduleSetup.getInt("mail.contract.param", -1);
        if (parameterId == -1) {
            throw new BGException("mail.contract.param not define!");
        }
        Optional attrEmail = this.contractDao.getContractParameterEmail(this.contractId, parameterId);
        if (attrEmail.isEmpty() || ((EntityAttrEmail)attrEmail.get()).getContactList().isEmpty()) {
            throw new BGException("Email for contractId => " + this.contractId + " is empty.");
        }
        return ((EntityAttrEmail)attrEmail.get()).getAddressList().stream().collect(Collectors.joining("\n"));
    }

    public String getSubject() {
        int domainId = 0;
        if (this.contract != null) {
            domainId = this.contract.getDomainId();
        }
        String subject = this.moduleSetup.get("mail." + domainId + ".subject", "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e\u0442 BGBilling ${fileName}");
        subject = this.moduleSetup.get("mail.subject", subject);
        return this.replaceMacros(subject, false);
    }

    public void addAttach(ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData mailData, String key) throws Exception {
        Document doc = XMLUtils.newDocument();
        if (this.data != null) {
            Element rootNode = doc.createElement("data");
            doc.appendChild(rootNode);
            BillUtil.addInline(rootNode, this.moduleSetup, this.userId);
            Document billDoc = XMLUtils.parseDocument((byte[])this.data);
            Element bill = (Element)billDoc.getElementsByTagName("bill").item(0);
            rootNode.appendChild(doc.importNode(bill, true));
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);){
            String patternName = BillUtil.getPatternName(this.type, this.con, this.moduleId, this.id);
            BillUtil.convertDocument(this.setup, this.con, this.moduleId, doc, patternName, outputStream);
            String fileName = this.getFileName() + ".pdf";
            mailData.addPart(key, "attachment", "application/pdf", fileName, outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private String getFileName() {
        String fileName = this.moduleSetup.get("mail.filename", "${type}_${N}");
        fileName = this.replaceMacros(fileName, true);
        return fileName;
    }

    public void addMessage(ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData mailData, String key) throws BGException {
        try {
            mailData.addTextPart(key, this.replaceMacros(this.moduleSetup.get("mail.text", ""), false).replace("\\n", "\n"), "text/" + this.moduleSetup.get("mail.text.type", "plain") + "; charset=utf-8;");
        }
        catch (MessagingException e) {
            throw new BGException((Throwable)e);
        }
    }

    private String replaceMacros(String text, boolean asFileName) {
        if (asFileName) {
            text = text.replaceAll("\\$\\{type\\}", DocumentSendParameters.SendingDataType.BILL.equals((Object)this.type) ? "bill" : "invoice");
            text = text.replaceAll("\\$\\{N\\}", String.valueOf(this.billDocInfo.getNumber()));
            text = text.replaceAll("\\$\\{formatN\\}", String.valueOf(this.billDocInfo.getFormatNumber()));
            text = text.replaceAll("\\$\\{contract.id\\}", String.valueOf(this.contractId));
            text = text.replaceAll("\\$\\{contract.id.sub\\}", String.valueOf(this.subContractId));
        } else {
            text = this.type != null ? text.replaceAll("\\$\\{fileName\\}", this.getFileName()) : text.replaceAll("\\$\\{fileName\\}", "");
        }
        if (this.contract != null) {
            text = text.replaceAll("\\$\\{contract.title\\}", this.contract.getTitle());
            text = text.replaceAll("\\$\\{contract.comment\\}", this.contract.getComment());
        } else {
            text = text.replaceAll("\\$\\{contract.title\\}", "");
            text = text.replaceAll("\\$\\{contract.comment\\}", "");
        }
        if (this.subContract != null) {
            text = text.replaceAll("\\$\\{contract.title.sub\\}", this.subContract.getTitle());
            text = text.replaceAll("\\$\\{contract.comment.sub\\}", this.subContract.getComment());
        } else {
            text = text.replaceAll("\\$\\{contract.title.sub\\}", "");
            text = text.replaceAll("\\$\\{contract.comment.sub\\}", "");
        }
        if (this.billDocInfo != null) {
            text = text.replaceAll("\\$\\{year\\}", String.valueOf(this.billDocInfo.getYy()));
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(2, this.billDocInfo.getMm());
            text = text.replaceAll("\\$\\{month\\}", TimeUtils.format((Calendar)calendar, (String)"MM"));
            text = text.replaceAll("\\$\\{monthName\\}", TimeUtils.format((Calendar)calendar, (String)"LLLL"));
        } else {
            text = text.replaceAll("\\$\\{year\\}", "");
            text = text.replaceAll("\\$\\{month\\}", "");
        }
        text = this.replaceParamsMacros(text, false);
        return this.replaceParamsMacros(text, true);
    }

    private String replaceParamsMacros(String text, boolean sub) {
        Set<Integer> pids = this.getPids(text, sub);
        try (ContractParameterManager parameterManager = new ContractParameterManager(this.con);){
            HashMap values = parameterManager.getValuesForPids(pids, sub ? this.subContractId : this.contractId);
            String prefix = sub ? "\\$\\{sub.param_" : "\\$\\{param_";
            for (int key : pids) {
                text = text.replaceAll(prefix + key + "\\}", Utils.maskNull((String)((String)values.get(key))));
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return text;
    }

    private Set<Integer> getPids(String val, boolean sub) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        int last = 0;
        String prefix = sub ? "${sub.param_" : "${param_";
        while (true) {
            int found = -1;
            found = val.indexOf(prefix, last);
            if (found == -1) break;
            last = found + prefix.length();
            found = val.indexOf("}", last);
            Integer pid = Utils.parseInt((String)val.substring(last, found));
            result.add(pid);
        }
        return result;
    }

    public static final class MailData {
        public Multipart m;
        public String mail;
        public String subject;
    }
}

