/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.Warehouse;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class WarehouseDao
extends AbstractIdDao<Warehouse> {
    public WarehouseDao(Connection con, int moduleId) {
        super(con, moduleId, "warehouse");
    }

    protected Warehouse getFromRS(ResultSet rs) throws SQLException, BGException {
        Warehouse warehouse = new Warehouse();
        warehouse.setId(rs.getInt("id"));
        warehouse.setTitle(rs.getString("title"));
        warehouse.setComment(rs.getString("comment"));
        return warehouse;
    }

    protected void updateImpl(Warehouse warehouse) throws BGException, SQLException {
        boolean isNew = warehouse.getId() <= 0;
        String prefix = isNew ? "INSERT INTO " : "UPDATE ";
        String query = prefix + this.tableName + " SET title=?, comment=?" + (isNew ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, warehouse.getTitle());
            ps.setString(2, warehouse.getComment());
            if (!isNew) {
                ps.setInt(3, warehouse.getId());
            }
            ps.executeUpdate();
            if (isNew) {
                warehouse.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
    }

    public List<Warehouse> getList() throws BGException {
        ArrayList<Warehouse> result = new ArrayList<Warehouse>();
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * FROM " + this.tableName);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

